/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import org.jboss.resource.RARMetaData;

public class RARDeployment
implements DynamicMBean {
    private final RARMetaData rarMetaData;
    private final MBeanInfo mbi;

    public RARDeployment(RARMetaData rarMetaData) {
        this.rarMetaData = rarMetaData;
        this.mbi = this.setupMBeanInfo();
    }

    public Object invoke(String operation, Object[] params, String[] sig) throws MBeanException {
        throw new MBeanException(null, "No operations exposed for RARDeployment");
    }

    public AttributeList getAttributes(String[] attributeNames) {
        AttributeList atts = new AttributeList();
        int i = 0;
        while (i < attributeNames.length) {
            try {
                Object value = this.getAttribute(attributeNames[i]);
                atts.add(new Attribute(attributeNames[i], value));
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        return atts;
    }

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null) {
            throw new MBeanException(new AttributeNotFoundException("Null is not an attribute name"), "No attribute name given to getAttribute");
        }
        if (attributeName.equals("DisplayName")) {
            return this.rarMetaData.getDisplayName();
        }
        if (attributeName.equals("ManagedConnectionFactoryClass")) {
            return this.rarMetaData.getManagedConnectionFactoryClass();
        }
        if (attributeName.equals("TransactionSupport")) {
            return new Integer(this.rarMetaData.getTransactionSupport());
        }
        if (attributeName.equals("AuthMechType")) {
            return this.rarMetaData.getAuthMechType();
        }
        if (attributeName.equals("ReauthenticationSupport")) {
            return new Boolean(this.rarMetaData.getReauthenticationSupport());
        }
        if (attributeName.equals("RARMetaData")) {
            return this.rarMetaData;
        }
        RARMetaData.Property prop = (RARMetaData.Property)this.rarMetaData.getProperties().get(attributeName);
        if (prop != null) {
            return prop.value;
        }
        throw new AttributeNotFoundException("No such attribute: " + attributeName);
    }

    public MBeanInfo getMBeanInfo() {
        return this.mbi;
    }

    public void setAttribute(Attribute param1) throws AttributeNotFoundException {
        throw new AttributeNotFoundException("No settable attributes in RARDeployment");
    }

    public AttributeList setAttributes(AttributeList param1) {
        return null;
    }

    private MBeanInfo setupMBeanInfo() {
        Map rarProps = this.rarMetaData.getProperties();
        int attributeCount = 5 + rarProps.size();
        MBeanAttributeInfo[] attributeInfos = new MBeanAttributeInfo[attributeCount];
        MBeanConstructorInfo[] constructorInfos = new MBeanConstructorInfo[1];
        int i = 0;
        attributeInfos[i++] = new MBeanAttributeInfo("DisplayName", "java.lang.String", "Display name of the Resource Adapter", true, false, false);
        attributeInfos[i++] = new MBeanAttributeInfo("ManagedConnectionFactoryClass", "java.lang.String", "Class name of the ManagedConnectionFactory for this Resource Adapter", true, false, false);
        attributeInfos[i++] = new MBeanAttributeInfo("TransactionSupport", "java.lang.Integer", "Transaction support of the Resource Adapter, expressed as a TX_SUPPORT_* constant", true, false, false);
        attributeInfos[i++] = new MBeanAttributeInfo("AuthMechType", "java.lang.String", "Authorization mechanism type of the Resource Adapter", true, false, false);
        attributeInfos[i++] = new MBeanAttributeInfo("ReauthenticationSupport", "java.lang.boolean", "Whether this Resource Adapter supports reauthentication of existing connections.", true, false, false);
        Iterator propIterator = rarProps.values().iterator();
        while (propIterator.hasNext()) {
            RARMetaData.Property prop = (RARMetaData.Property)propIterator.next();
            attributeInfos[i++] = new MBeanAttributeInfo(prop.name, prop.type, prop.desc, true, false, false);
        }
        Constructor<?>[] constructors = this.getClass().getConstructors();
        constructorInfos[0] = new MBeanConstructorInfo("Constructor for the RARDeployment", constructors[0]);
        MBeanInfo mbi = new MBeanInfo(this.getClass().getName(), "Description of a deployed Resource Adapter", attributeInfos, constructorInfos, new MBeanOperationInfo[0], new MBeanNotificationInfo[0]);
        return mbi;
    }
}

