/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlLoadable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RARMetaData
implements XmlLoadable {
    public static final int TX_SUPPORT_NO = 0;
    public static final int TX_SUPPORT_LOCAL = 1;
    public static final int TX_SUPPORT_XA = 2;
    private Logger category = Logger.getLogger((Class)(class$org$jboss$resource$RARMetaData == null ? (class$org$jboss$resource$RARMetaData = RARMetaData.class$("org.jboss.resource.RARMetaData")) : class$org$jboss$resource$RARMetaData));
    private ClassLoader classLoader;
    private String displayName;
    private String managedConnectionFactoryClass;
    private String connectionFactoryInterface;
    private String connectionFactoryImplClass;
    private String connectionInterface;
    private String connectionImplClass;
    private int transactionSupport;
    private Map properties = new HashMap();
    private String authMechType;
    private String credentialInterface;
    private boolean reauthenticationSupport;
    static /* synthetic */ Class class$org$jboss$resource$RARMetaData;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getManagedConnectionFactoryClass() {
        return this.managedConnectionFactoryClass;
    }

    public int getTransactionSupport() {
        return this.transactionSupport;
    }

    public Map getProperties() {
        return this.properties;
    }

    public String getPropertyType(String name) {
        Property prop = (Property)this.properties.get(name);
        return prop == null ? null : prop.type;
    }

    public String getAuthMechType() {
        return this.authMechType;
    }

    public boolean getReauthenticationSupport() {
        return this.reauthenticationSupport;
    }

    public void importXml(Element root) throws DeploymentException {
        String rootTag = root.getTagName();
        if (!rootTag.equals("connector")) {
            throw new DeploymentException("Not a resrouce adapter deployment descriptor because its root tag, '" + rootTag + "', is not 'connector'");
        }
        this.invokeChildren(root);
    }

    private void setDisplayName(Element element) throws DeploymentException {
        this.displayName = this.getElementContent(element);
    }

    private void setVendorName(Element element) {
    }

    private void setSpecVersion(Element element) {
    }

    private void setVersion(Element element) {
    }

    private void setEisType(Element element) {
    }

    private void setResourceadapter(Element element) throws DeploymentException {
        this.invokeChildren(element);
    }

    private void setManagedconnectionfactoryClass(Element element) throws DeploymentException {
        this.managedConnectionFactoryClass = this.getElementContent(element);
    }

    private void setConnectionfactoryInterface(Element element) throws DeploymentException {
        this.connectionFactoryInterface = this.getElementContent(element);
    }

    private void setConnectionfactoryImplClass(Element element) throws DeploymentException {
        this.connectionFactoryImplClass = this.getElementContent(element);
    }

    private void setConnectionInterface(Element element) throws DeploymentException {
        this.connectionInterface = this.getElementContent(element);
    }

    private void setConnectionImplClass(Element element) throws DeploymentException {
        this.connectionImplClass = this.getElementContent(element);
    }

    private void setTransactionSupport(Element element) throws DeploymentException {
        int ts;
        String s = this.getElementContent(element);
        if (s.equals("NoTransaction")) {
            ts = 0;
        } else if (s.equals("LocalTransaction")) {
            ts = 1;
        } else if (s.equals("XATransaction")) {
            ts = 2;
        } else {
            throw new DeploymentException("Invalid transaction support '" + s + "', it must be one of " + "'NoTransaction', " + "'LocalTransaction' or " + "'XATransaction'");
        }
        this.transactionSupport = ts;
    }

    private void setConfigProperty(Element element) throws DeploymentException {
        Element nameE = MetaData.getUniqueChild((Element)element, (String)"config-property-name");
        Element typeE = MetaData.getUniqueChild((Element)element, (String)"config-property-type");
        Element valueE = MetaData.getOptionalChild((Element)element, (String)"config-property-value");
        Element descE = MetaData.getOptionalChild((Element)element, (String)"description");
        Property p = new Property();
        p.name = this.getElementContent(nameE);
        p.type = this.getElementContent(typeE);
        if (valueE != null) {
            p.value = this.getElementContent(valueE);
        }
        if (descE != null) {
            p.desc = this.getElementContent(descE);
        }
        this.properties.put(p.name, p);
    }

    private void setLicense(Element element) throws DeploymentException {
        Element requiredE = MetaData.getUniqueChild((Element)element, (String)"license-required");
        Element descriptionE = MetaData.getOptionalChild((Element)element, (String)"description");
        boolean required = new Boolean(this.getElementContent(requiredE).trim());
        if (required) {
            this.category.info((Object)"Required license terms present. See deployment descriptor.");
        } else {
            this.category.info((Object)"License terms present. See deployment descriptor.");
        }
    }

    private void setDescription(Element element) throws DeploymentException {
        this.category.info((Object)("Loading " + this.getElementContent(element).trim()));
    }

    private void setAuthenticationMechanism(Element element) throws DeploymentException {
        this.invokeChildren(element);
    }

    private void setAuthenticationMechanismType(Element element) throws DeploymentException {
        this.authMechType = this.getElementContent(element);
    }

    private void setCredentialInterface(Element element) throws DeploymentException {
        this.credentialInterface = this.getElementContent(element);
    }

    private void setReauthenticationSupport(Element element) throws DeploymentException {
        String value = this.getElementContent(element);
        if (!value.equals("true") && !value.equals("false")) {
            throw new DeploymentException("reauthentication-support must be one of 'true' or 'false', not '" + value + "'");
        }
        this.reauthenticationSupport = Boolean.valueOf(value);
    }

    private void setSecurityPermission(Element element) throws DeploymentException {
        Element permSpec = MetaData.getUniqueChild((Element)element, (String)"security-permission-spec");
        String spec = this.getElementContent(permSpec);
        if (this.category.isDebugEnabled()) {
            this.category.debug((Object)("Ignoring security-permission(" + spec + ")"));
        }
    }

    private String getElementContent(Element element) throws DeploymentException {
        return MetaData.getElementContent((Element)element);
    }

    private void invokeChildren(Element element) throws DeploymentException {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeType() == 1) {
                Element child = (Element)node;
                Method method = this.elementToMethod(child);
                if (method == null) {
                    this.category.warn((Object)("Element '" + child + "' not recognised."));
                } else {
                    try {
                        method.invoke((Object)this, child);
                    }
                    catch (InvocationTargetException ite) {
                        Throwable t = ite.getTargetException();
                        if (t instanceof DeploymentException) {
                            throw (DeploymentException)t;
                        }
                        if (t instanceof Exception) {
                            throw new DeploymentException("Exception handling element", (Throwable)((Exception)t));
                        }
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        throw new DeploymentException("WTF?: " + t.toString());
                    }
                    catch (Exception e) {
                        throw new DeploymentException("Exception handling element", (Throwable)e);
                    }
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Method elementToMethod(Element element) {
        int next_hyphen;
        String tag = element.getTagName();
        StringBuffer methodName = new StringBuffer("set");
        int last_hyphen = -1;
        while ((next_hyphen = tag.indexOf(45, last_hyphen + 1)) != -1) {
            void var5_6;
            String thisbit = tag.substring(last_hyphen + 1, (int)var5_6);
            methodName.append(this.toTitleCase(thisbit));
            last_hyphen = var5_6;
        }
        methodName.append(this.toTitleCase(tag.substring(last_hyphen + 1)));
        if (this.category.isDebugEnabled()) {
            this.category.debug((Object)("methodName = '" + methodName + "'"));
        }
        try {
            return this.getClass().getDeclaredMethod(methodName.toString(), class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = RARMetaData.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
    }

    private String toTitleCase(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s.toUpperCase();
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Property {
        public String name;
        public String type;
        public String value;
        public String desc;
    }
}

