/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.jboss.resource.connectionmanager.CachedConnectionManagerMBean;
import org.jboss.resource.connectionmanager.ConnectionCacheListener;
import org.jboss.resource.connectionmanager.ConnectionRecord;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.usertx.client.ServerVMClientUserTransaction;

public class CachedConnectionManager
extends ServiceMBeanSupport
implements ServerVMClientUserTransaction.UserTransactionStartedListener,
CachedConnectionManagerMBean {
    private final ThreadLocal currentObjects = new ThreadLocal();
    private final Map objectToConnectionManagerMap = new HashMap();
    protected final Logger log = Logger.getLogger(this.getClass());

    public CachedConnectionManager getInstance() {
        return this;
    }

    protected void startService() throws Exception {
        ServerVMClientUserTransaction.getSingleton().registerTxStartedListener((ServerVMClientUserTransaction.UserTransactionStartedListener)this);
    }

    protected void stopService() throws Exception {
        ServerVMClientUserTransaction.getSingleton().unregisterTxStartedListener((ServerVMClientUserTransaction.UserTransactionStartedListener)this);
    }

    public void pushMetaAwareObject(Object key, Set unsharableResources) throws ResourceException {
        LinkedList<Object> stack = (LinkedList<Object>)this.currentObjects.get();
        if (stack == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("new stack for key: " + key));
            }
            stack = new LinkedList<Object>();
            this.currentObjects.set(stack);
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("old stack for key: " + key));
            }
            if (!stack.isEmpty()) {
                Object oldKey = stack.getLast();
                this.disconnect(oldKey, unsharableResources);
            }
        }
        stack.addLast(key);
        this.reconnect(key, unsharableResources);
    }

    public void popMetaAwareObject(Set unsharableResources) throws ResourceException {
        LinkedList stack = (LinkedList)this.currentObjects.get();
        Object oldKey = stack.removeLast();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("popped object: " + oldKey));
        }
        this.disconnect(oldKey, unsharableResources);
        if (!stack.isEmpty()) {
            Object key = stack.getLast();
            this.reconnect(key, unsharableResources);
        }
    }

    Object peekMetaAwareObject() {
        LinkedList stack = (LinkedList)this.currentObjects.get();
        if (stack == null) {
            return null;
        }
        if (!stack.isEmpty()) {
            return stack.getLast();
        }
        return null;
    }

    void registerConnection(ConnectionCacheListener cm, ConnectionRecord cr) {
        Object key = this.peekMetaAwareObject();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("registering connection from " + cm + ", connection record: " + cr + ", key: " + key));
        }
        if (key == null) {
            return;
        }
        HashMap<ConnectionCacheListener, ArrayList<ConnectionRecord>> cmToConnectionsMap = null;
        Map map = this.objectToConnectionManagerMap;
        synchronized (map) {
            cmToConnectionsMap = (HashMap<ConnectionCacheListener, ArrayList<ConnectionRecord>>)this.objectToConnectionManagerMap.get(key);
            if (cmToConnectionsMap == null) {
                cmToConnectionsMap = new HashMap<ConnectionCacheListener, ArrayList<ConnectionRecord>>();
                this.objectToConnectionManagerMap.put(key, cmToConnectionsMap);
            }
        }
        HashMap<ConnectionCacheListener, ArrayList<ConnectionRecord>> hashMap = cmToConnectionsMap;
        synchronized (hashMap) {
            ArrayList<ConnectionRecord> conns = (ArrayList<ConnectionRecord>)cmToConnectionsMap.get(cm);
            if (conns == null) {
                conns = new ArrayList<ConnectionRecord>();
                cmToConnectionsMap.put(cm, conns);
            }
            conns.add(cr);
        }
    }

    void unregisterConnection(ConnectionCacheListener cm, Object c) {
        Object key = this.peekMetaAwareObject();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("unregistering connection from " + cm + ", object: " + c + ", key: " + key));
        }
        if (key == null) {
            return;
        }
        Map cmToConnectionsMap = null;
        Map map = this.objectToConnectionManagerMap;
        synchronized (map) {
            cmToConnectionsMap = (Map)this.objectToConnectionManagerMap.get(key);
            if (cmToConnectionsMap == null) {
                return;
            }
        }
        Map map2 = cmToConnectionsMap;
        synchronized (map2) {
            Collection conns = (Collection)cmToConnectionsMap.get(cm);
            if (conns == null) {
                return;
            }
            Iterator i = conns.iterator();
            while (i.hasNext()) {
                if (((ConnectionRecord)i.next()).connection != c) continue;
                i.remove();
                if (conns.size() == 0) {
                    cmToConnectionsMap.remove(cm);
                    if (cmToConnectionsMap.size() == 0) {
                        Map map3 = this.objectToConnectionManagerMap;
                        synchronized (map3) {
                            this.objectToConnectionManagerMap.remove(key);
                        }
                    }
                }
                return;
            }
        }
    }

    public void userTransactionStarted() throws SystemException {
        Object key = this.peekMetaAwareObject();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("user tx started, key: " + key));
        }
        if (key == null) {
            return;
        }
        Map cmToConnectionsMap = null;
        Map map = this.objectToConnectionManagerMap;
        synchronized (map) {
            cmToConnectionsMap = (Map)this.objectToConnectionManagerMap.get(key);
            if (cmToConnectionsMap == null) {
                return;
            }
        }
        Map map2 = cmToConnectionsMap;
        synchronized (map2) {
            Iterator i = cmToConnectionsMap.keySet().iterator();
            while (i.hasNext()) {
                ConnectionCacheListener cm = (ConnectionCacheListener)i.next();
                Collection conns = (Collection)cmToConnectionsMap.get(cm);
                cm.transactionStarted(conns);
            }
        }
    }

    private void reconnect(Object key, Set unsharableResources) throws ResourceException {
        Map cmToConnectionsMap = null;
        Map map = this.objectToConnectionManagerMap;
        synchronized (map) {
            cmToConnectionsMap = (Map)this.objectToConnectionManagerMap.get(key);
            if (cmToConnectionsMap == null) {
                return;
            }
        }
        Map map2 = cmToConnectionsMap;
        synchronized (map2) {
            Iterator i = cmToConnectionsMap.keySet().iterator();
            while (i.hasNext()) {
                ConnectionCacheListener cm = (ConnectionCacheListener)i.next();
                Collection conns = (Collection)cmToConnectionsMap.get(cm);
                cm.reconnect(conns, unsharableResources);
            }
        }
    }

    private void disconnect(Object key, Set unsharableResources) throws ResourceException {
        Map cmToConnectionsMap = null;
        Map map = this.objectToConnectionManagerMap;
        synchronized (map) {
            cmToConnectionsMap = (Map)this.objectToConnectionManagerMap.get(key);
            if (cmToConnectionsMap == null) {
                return;
            }
        }
        Map map2 = cmToConnectionsMap;
        synchronized (map2) {
            Iterator i = cmToConnectionsMap.keySet().iterator();
            while (i.hasNext()) {
                ConnectionCacheListener cm = (ConnectionCacheListener)i.next();
                Collection conns = (Collection)cmToConnectionsMap.get(cm);
                cm.disconnect(conns, unsharableResources);
            }
        }
    }

    void unregisterConnectionCacheListener(ConnectionCacheListener cm) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("unregisterConnectionCacheListener: " + cm));
        }
        Map map = this.objectToConnectionManagerMap;
        synchronized (map) {
            Iterator i = this.objectToConnectionManagerMap.values().iterator();
            while (i.hasNext()) {
                Map cmToConnectionsMap = (Map)i.next();
                if (cmToConnectionsMap == null) continue;
                cmToConnectionsMap.remove(cm);
            }
        }
    }
}

