/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.logging.util.CategoryWriter;
import org.jboss.metadata.MetaData;
import org.jboss.naming.Util;
import org.jboss.resource.RARMetaData;
import org.jboss.resource.connectionmanager.RARDeploymentMBean;
import org.jboss.util.Classes;
import org.jboss.util.jmx.MBeanServerLocator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RARDeployment
implements RARDeploymentMBean,
ObjectFactory {
    private static final Map cfs = new HashMap();
    private Logger log = Logger.getLogger(this.getClass());
    private ObjectName oldRarDeployment;
    private String displayName;
    private String vendorName;
    private String specVersion;
    private String eisType;
    private String version;
    private String managedConnectionFactoryClass;
    private String connectionFactoryInterface;
    private String connectionFactoryImplClass;
    private String connectionInterface;
    private String connectionImplClass;
    private String transactionSupport;
    private Element managedConnectionFactoryProperties;
    private String authenticationMechanismType;
    private String credentialInterface;
    private boolean reauthenticationSupport;
    private String jndiName;
    private Class mcfClass;
    private ManagedConnectionFactory mcf;

    public ObjectName getOldRarDeployment() {
        return this.oldRarDeployment;
    }

    public void setOldRarDeployment(ObjectName oldRarDeployment) {
        this.oldRarDeployment = oldRarDeployment;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    public String getEisType() {
        return this.eisType;
    }

    public void setEisType(String eisType) {
        this.eisType = eisType;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getManagedConnectionFactoryClass() {
        return this.managedConnectionFactoryClass;
    }

    public void setManagedConnectionFactoryClass(String managedConnectionFactoryClass) {
        this.managedConnectionFactoryClass = managedConnectionFactoryClass;
    }

    public String getConnectionFactoryInterface() {
        return this.connectionFactoryInterface;
    }

    public void setConnectionFactoryInterface(String connectionFactoryInterface) {
        this.connectionFactoryInterface = connectionFactoryInterface;
    }

    public String getConnectionFactoryImplClass() {
        return this.connectionFactoryImplClass;
    }

    public void setConnectionFactoryImplClass(String connectionFactoryImplClass) {
        this.connectionFactoryImplClass = connectionFactoryImplClass;
    }

    public String getConnectionInterface() {
        return this.connectionInterface;
    }

    public void setConnectionInterface(String connectionInterface) {
        this.connectionInterface = connectionInterface;
    }

    public String getConnectionImplClass() {
        return this.connectionImplClass;
    }

    public void setConnectionImplClass(String connectionImplClass) {
        this.connectionImplClass = connectionImplClass;
    }

    public String getTransactionSupport() {
        return this.transactionSupport;
    }

    public void setTransactionSupport(String transactionSupport) {
        this.transactionSupport = transactionSupport;
    }

    public Element getManagedConnectionFactoryProperties() {
        return this.managedConnectionFactoryProperties;
    }

    public void setManagedConnectionFactoryProperties(Element managedConnectionFactoryProperties) {
        this.managedConnectionFactoryProperties = managedConnectionFactoryProperties;
    }

    public String getAuthenticationMechanismType() {
        return this.authenticationMechanismType;
    }

    public void setAuthenticationMechanismType(String authenticationMechanismType) {
        this.authenticationMechanismType = authenticationMechanismType;
    }

    public String getCredentialInterface() {
        return this.credentialInterface;
    }

    public void setCredentialInterface(String credentialInterface) {
        this.credentialInterface = credentialInterface;
    }

    public boolean isReauthenticationSupport() {
        return this.reauthenticationSupport;
    }

    public void setReauthenticationSupport(boolean reauthenticationSupport) {
        this.reauthenticationSupport = reauthenticationSupport;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public ManagedConnectionFactory startManagedConnectionFactory(ConnectionManager cm) throws DeploymentException {
        if (this.mcf != null) {
            throw new DeploymentException("Stop the RARDeployment before restarting it");
        }
        if (this.oldRarDeployment != null) {
            this.copyRaInfo();
        }
        try {
            this.mcfClass = Thread.currentThread().getContextClassLoader().loadClass(this.managedConnectionFactoryClass);
        }
        catch (ClassNotFoundException cnfe) {
            this.log.error((Object)("Could not find ManagedConnectionFactory class: " + this.managedConnectionFactoryClass), (Throwable)cnfe);
            throw new DeploymentException("Could not find ManagedConnectionFactory class: " + this.managedConnectionFactoryClass);
        }
        try {
            this.mcf = (ManagedConnectionFactory)this.mcfClass.newInstance();
        }
        catch (Exception e) {
            this.log.error((Object)("Could not instantiate ManagedConnectionFactory: " + this.managedConnectionFactoryClass), (Throwable)e);
            throw new DeploymentException("Could not instantiate ManagedConnectionFactory: " + this.managedConnectionFactoryClass);
        }
        this.setMcfProperties();
        String categoryName = this.mcf.getClass().getName() + "." + this.jndiName;
        Logger log = Logger.getLogger((String)categoryName);
        CategoryWriter logWriter = new CategoryWriter(log.getCategory());
        try {
            this.mcf.setLogWriter((PrintWriter)logWriter);
        }
        catch (ResourceException re) {
            log.warn((Object)("Unable to set log writer '" + logWriter + "' on " + "managed connection factory"), (Throwable)re);
            log.warn((Object)"Linked exception:", (Throwable)re.getLinkedException());
        }
        String bindName = "java:/" + this.jndiName;
        try {
            Object cf = this.mcf.createConnectionFactory(cm);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Binding object '" + cf + "' into JNDI at '" + bindName + "'"));
            }
            Map map = cfs;
            synchronized (map) {
                cfs.put(this.jndiName, cf);
            }
            ((Referenceable)cf).setReference(new Reference(cf.getClass().getName(), this.getClass().getName(), null));
            Util.bind((Context)new InitialContext(), (String)bindName, (Object)cf);
            log.info((Object)("Bound connection factory for resource adapter '" + this.displayName + "' to JNDI name '" + bindName + "'"));
        }
        catch (ResourceException re) {
            log.error((Object)("Could not create ConnectionFactory for adapter: " + this.managedConnectionFactoryClass), (Throwable)re);
            throw new DeploymentException("Could not create ConnectionFactory for adapter: " + this.managedConnectionFactoryClass);
        }
        catch (NamingException ne) {
            log.error((Object)("Unable to bind connection factory to JNDI name '" + bindName + "'"), (Throwable)ne);
            throw new DeploymentException("Could not bind ConnectionFactory into jndi: " + bindName);
        }
        return this.mcf;
    }

    public void stopManagedConnectionFactory() {
        String bindName = "java:/" + this.jndiName;
        try {
            new InitialContext().unbind(bindName);
        }
        catch (NamingException ne) {
            this.log.error((Object)("could not unbind managedConnectionFactory from jndi: " + this.jndiName), (Throwable)ne);
        }
        Map map = cfs;
        synchronized (map) {
            cfs.remove(this.jndiName);
        }
        this.mcf = null;
        this.mcfClass = null;
    }

    public void setManagedConnectionFactoryAttribute(String name, Class clazz, Object value) {
        Method setter;
        try {
            setter = this.mcfClass.getMethod("set" + name, clazz);
        }
        catch (NoSuchMethodException nsme) {
            this.log.warn((Object)("The class '" + this.mcfClass.toString() + "' has no " + "setter for config property '" + name + "'"));
            throw new IllegalArgumentException("The class '" + this.mcfClass.toString() + "' has no " + "setter for config property '" + name + "'");
        }
        try {
            setter.invoke((Object)this.mcf, value);
            this.log.debug((Object)("set property " + name + " to value " + value));
        }
        catch (Exception e) {
            this.log.warn((Object)("Unable to invoke setter method '" + setter + "' " + "on object '" + this.mcf + "'"), (Throwable)e);
            throw new IllegalArgumentException("Unable to invoke setter method '" + setter + "' " + "on object '" + this.mcf + "'");
        }
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("RARDeployment.getObjectInstance, name = '" + name + "'"));
        }
        Map map = cfs;
        synchronized (map) {
            Object v = cfs.get(name.toString());
            return v;
        }
    }

    protected void setMcfProperties() throws DeploymentException {
        if (this.managedConnectionFactoryProperties == null) {
            return;
        }
        NodeList props = this.managedConnectionFactoryProperties.getChildNodes();
        int i = 0;
        while (i < props.getLength()) {
            block14: {
                Element prop;
                Node p = props.item(i);
                if (props.item(i).getNodeType() == 1 && (prop = (Element)props.item(i)).getTagName().equals("config-property")) {
                    String name = null;
                    String type = null;
                    String value = null;
                    if (prop.hasAttribute("name")) {
                        name = prop.getAttribute("name");
                        type = prop.getAttribute("type");
                        value = MetaData.getElementContent((Element)prop);
                    } else {
                        name = MetaData.getElementContent((Element)MetaData.getUniqueChild((Element)prop, (String)"config-property-name"));
                        type = MetaData.getElementContent((Element)MetaData.getUniqueChild((Element)prop, (String)"config-property-type"));
                        value = MetaData.getElementContent((Element)MetaData.getUniqueChild((Element)prop, (String)"config-property-value"));
                    }
                    if (name == null || type == null || value == null) {
                        this.log.warn((Object)("Not setting config property '" + name + "'"));
                    } else {
                        PropertyEditor pe;
                        Class<?> clazz = Classes.getPrimitiveTypeForName((String)type);
                        if (clazz == null) {
                            try {
                                clazz = Thread.currentThread().getContextClassLoader().loadClass(type);
                            }
                            catch (ClassNotFoundException cnfe) {
                                this.log.warn((Object)("Unable to find class '" + type + "' for " + "property '" + name + "' - skipping property."));
                                break block14;
                            }
                        }
                        if ((pe = PropertyEditorManager.findEditor(clazz)) == null) {
                            this.log.warn((Object)("Unable to find a PropertyEditor for class '" + clazz + "' of property '" + name + "' - " + "skipping property"));
                        } else {
                            try {
                                pe.setAsText(value);
                            }
                            catch (IllegalArgumentException iae) {
                                this.log.warn((Object)("Value '" + value + "' is not valid for property '" + name + "' of class '" + clazz + "' - skipping " + "property"));
                                break block14;
                            }
                            Object v = pe.getValue();
                            this.setManagedConnectionFactoryAttribute(name, clazz, v);
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void copyRaInfo() throws DeploymentException {
        try {
            RARMetaData rarMD = (RARMetaData)MBeanServerLocator.locate().getAttribute(this.oldRarDeployment, "RARMetaData");
            this.setDisplayName(rarMD.getDisplayName());
            this.setManagedConnectionFactoryClass(rarMD.getManagedConnectionFactoryClass());
            this.setReauthenticationSupport(rarMD.getReauthenticationSupport());
        }
        catch (Exception e) {
            throw new DeploymentException("couldn't get oldRarDeployment!", (Throwable)e);
        }
    }
}

