/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.resource.security.AbstractPasswordCredentialLoginModule;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;

public class CallerIdentityLoginModule
extends AbstractPasswordCredentialLoginModule {
    private String userName;
    private String password;
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$resource$security$CallerIdentityLoginModule == null ? (class$org$jboss$resource$security$CallerIdentityLoginModule = CallerIdentityLoginModule.class$("org.jboss.resource.security.CallerIdentityLoginModule")) : class$org$jboss$resource$security$CallerIdentityLoginModule));
    static /* synthetic */ Class class$org$jboss$resource$security$CallerIdentityLoginModule;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        super.initialize(subject, handler, sharedState, options);
        this.userName = (String)options.get("userName");
        if (this.userName == null) {
            log.info((Object)"No default username supplied.");
        }
        this.password = (String)options.get("password");
        if (this.password == null) {
            log.info((Object)"No default password supplied.");
        }
        log.info((Object)("got default principal: " + this.userName + ", username: " + this.userName + ", password: " + this.password));
    }

    public boolean login() throws LoginException {
        log.trace((Object)"Caller Association login called");
        String username = this.userName;
        char[] pass = this.password.toCharArray();
        try {
            Principal user = SecurityAssociation.getPrincipal();
            Object o = SecurityAssociation.getCredential();
            if (o != null) {
                pass = (char[])o;
            }
            if (user != null) {
                username = user.getName();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Current Calling principal is: " + username + " ThreadName: " + Thread.currentThread().getName()));
                }
            }
        }
        catch (Throwable e) {
            throw new LoginException("Unable to get the calling principal or its credentials for resource association");
        }
        if (super.login()) {
            return true;
        }
        SimplePrincipal principal = new SimplePrincipal(username);
        this.subject.getPrincipals().add((Principal)principal);
        this.sharedState.put("javax.security.auth.login.name", username);
        PasswordCredential cred = new PasswordCredential(username, pass);
        cred.setManagedConnectionFactory(this.getMcf());
        this.subject.getPrivateCredentials().add(cred);
        return true;
    }

    protected Principal getIdentity() {
        log.trace((Object)"getIdentity called");
        SimplePrincipal principal = new SimplePrincipal(this.userName);
        return principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        log.trace((Object)"getRoleSets called");
        return new Group[0];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

