/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.DistributedStateImplMBean;
import org.jboss.logging.Logger;
import org.jboss.system.Registry;

public class DistributedStateImpl
implements DistributedStateImplMBean,
HAPartition.HAPartitionStateTransfer {
    protected static final String SERVICE_NAME = "DistributedState";
    protected HashMap categories = new HashMap();
    protected HashMap keyListeners = new HashMap();
    protected HAPartition partition;
    protected Logger log = null;
    protected MBeanServer mbeanServer = null;
    protected String name = null;

    public DistributedStateImpl() {
    }

    public DistributedStateImpl(HAPartition partition, MBeanServer server) {
        this.partition = partition;
        this.mbeanServer = server;
        this.log = Logger.getLogger(this.getClass());
    }

    public void init() throws Exception {
        this.partition.subscribeToStateTransferEvents(SERVICE_NAME, this);
        this.partition.registerRPCHandler(SERVICE_NAME, this);
        this.name = "jboss:service=DistributedState,partitionName=" + this.partition.getPartitionName();
        ObjectName jmxName = new ObjectName(this.name);
        this.mbeanServer.registerMBean(this, jmxName);
        Registry.bind((Object)this.name, (Object)this);
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        Registry.unbind((Object)this.name);
        ObjectName jmxName = new ObjectName(this.name);
        this.mbeanServer.unregisterMBean(jmxName);
    }

    public String listContent() throws Exception {
        StringBuffer result = new StringBuffer();
        Collection cats = this.getAllCategories();
        Iterator catsIter = cats.iterator();
        while (catsIter.hasNext()) {
            String category = (String)catsIter.next();
            Iterator keysIter = this.getAllKeys(category).iterator();
            result.append("-----------------------------------------------\n");
            result.append("Category : ").append(category).append("\n\n");
            result.append("KEY\t:\tVALUE\n");
            while (keysIter.hasNext()) {
                String key = (String)keysIter.next();
                String value = this.get(category, key).toString();
                result.append("\"").append(key).append("\"\t:\t\"").append(value).append("\"\n");
            }
            result.append("\n");
        }
        return result.toString();
    }

    public String listXmlContent() throws Exception {
        StringBuffer result = new StringBuffer();
        Collection cats = this.getAllCategories();
        Iterator catsIter = cats.iterator();
        result.append("<DistributedState>\n");
        while (catsIter.hasNext()) {
            String category = (String)catsIter.next();
            Iterator keysIter = this.getAllKeys(category).iterator();
            result.append("\t<Category>\n");
            result.append("\t\t<CategoryName>").append(category).append("</CategoryName>\n");
            while (keysIter.hasNext()) {
                String key = (String)keysIter.next();
                String value = this.get(category, key).toString();
                result.append("\t\t<Entry>\n");
                result.append("\t\t\t<Key>").append(key).append("</Key>\n");
                result.append("\t\t\t<Value>").append(value).append("</Value>\n");
                result.append("\t\t</Entry>\n");
                result.append("\"").append(key).append("\"\t:\t\"").append(value).append("\"\n");
            }
            result.append("\t</Category>\n");
        }
        result.append("</DistributedState>\n");
        return result.toString();
    }

    public void set(String category, String key, Serializable value) throws Exception {
        this.set(category, key, value, true);
    }

    public void set(String category, String key, Serializable value, boolean asynchronousCall) throws Exception {
        Object[] args = new Object[]{category, key, value};
        if (asynchronousCall) {
            this.partition.callAsynchMethodOnCluster(SERVICE_NAME, "_set", args, true);
        } else {
            this.partition.callMethodOnCluster(SERVICE_NAME, "_set", args, true);
        }
        this._setInternal(category, key, value);
        this.notifyKeyListeners(category, key, value, true);
    }

    public Serializable remove(String category, String key) throws Exception {
        return this.remove(category, key, true);
    }

    public Serializable remove(String category, String key, boolean asynchronousCall) throws Exception {
        Object[] args = new Object[]{category, key};
        if (asynchronousCall) {
            this.partition.callAsynchMethodOnCluster(SERVICE_NAME, "_remove", args, true);
        } else {
            this.partition.callMethodOnCluster(SERVICE_NAME, "_remove", args, true);
        }
        Serializable removed = this._removeInternal(category, key);
        this.notifyKeyListenersOfRemove(category, key, removed, true);
        return removed;
    }

    public Serializable get(String category, String key) {
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            HashMap cat = (HashMap)this.categories.get(category);
            if (cat == null) {
                Serializable serializable = null;
                return serializable;
            }
            Serializable serializable = (Serializable)cat.get(key);
            return serializable;
        }
    }

    public Collection getAllCategories() {
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            Set set = this.categories.keySet();
            return set;
        }
    }

    public Collection getAllKeys(String category) {
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            HashMap cat = (HashMap)this.categories.get(category);
            if (cat == null) {
                Collection collection = null;
                return collection;
            }
            Set set = cat.keySet();
            return set;
        }
    }

    public Collection getAllValues(String category) {
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            HashMap cat = (HashMap)this.categories.get(category);
            if (cat == null) {
                Collection collection = null;
                return collection;
            }
            Collection collection = cat.values();
            return collection;
        }
    }

    public void registerDSListener(String category, DistributedState.DSListener subscriber) {
        HashMap hashMap = this.keyListeners;
        synchronized (hashMap) {
            ArrayList<DistributedState.DSListener> listeners = (ArrayList<DistributedState.DSListener>)this.keyListeners.get(category);
            if (listeners == null) {
                listeners = new ArrayList<DistributedState.DSListener>();
                this.keyListeners.put(category, listeners);
            }
            listeners.add(subscriber);
        }
    }

    public void unregisterDSListener(String category, DistributedState.DSListener subscriber) {
        HashMap hashMap = this.keyListeners;
        synchronized (hashMap) {
            ArrayList listeners = (ArrayList)this.keyListeners.get(category);
            if (listeners == null) {
                return;
            }
            listeners.remove(subscriber);
            if (listeners.size() == 0) {
                this.keyListeners.remove(category);
            }
        }
    }

    public void _set(String category, String key, Serializable value) throws Exception {
        this._setInternal(category, key, value);
        this.notifyKeyListeners(category, key, value, false);
    }

    public void _setInternal(String category, String key, Serializable value) throws Exception {
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            HashMap<String, Serializable> cat = (HashMap<String, Serializable>)this.categories.get(category);
            if (cat == null) {
                cat = new HashMap<String, Serializable>();
                this.categories.put(category, cat);
            }
            cat.put(key, value);
        }
    }

    public void _remove(String category, String key) throws Exception {
        Serializable removed = this._removeInternal(category, key);
        this.notifyKeyListenersOfRemove(category, key, removed, false);
    }

    public Serializable _removeInternal(String category, String key) throws Exception {
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            HashMap cat = (HashMap)this.categories.get(category);
            if (cat == null) {
                Serializable serializable = null;
                return serializable;
            }
            Object removed = cat.remove(key);
            if (removed != null && cat.size() == 0) {
                this.categories.remove(category);
            }
            Serializable serializable = (Serializable)removed;
            return serializable;
        }
    }

    public Serializable getCurrentState() {
        return this.categories;
    }

    public void setCurrentState(Serializable newState) {
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            this.categories.clear();
            this.categories.putAll((HashMap)newState);
            if (this.keyListeners.size() > 0) {
                this.cleanupKeyListeners();
            }
        }
    }

    protected void notifyKeyListeners(String category, String key, Serializable value, boolean locallyModified) {
        HashMap hashMap = this.keyListeners;
        synchronized (hashMap) {
            ArrayList listeners = (ArrayList)this.keyListeners.get(category);
            if (listeners == null) {
                return;
            }
            int i = 0;
            while (i < listeners.size()) {
                DistributedState.DSListener listener = (DistributedState.DSListener)listeners.get(i);
                listener.valueHasChanged(category, key, value, locallyModified);
                ++i;
            }
        }
    }

    protected void notifyKeyListenersOfRemove(String category, String key, Serializable oldContent, boolean locallyModified) {
        HashMap hashMap = this.keyListeners;
        synchronized (hashMap) {
            ArrayList listeners = (ArrayList)this.keyListeners.get(category);
            if (listeners == null) {
                return;
            }
            int i = 0;
            while (i < listeners.size()) {
                DistributedState.DSListener listener = (DistributedState.DSListener)listeners.get(i);
                listener.keyHasBeenRemoved(category, key, oldContent, locallyModified);
                ++i;
            }
        }
    }

    protected void cleanupKeyListeners() {
    }
}

