/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.FarmMemberServiceMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;

public class FarmMemberService
extends ServiceMBeanSupport
implements FarmMemberServiceMBean {
    private static final String DEFAULT_DEPLOY_DIRECTORY = "./farm";
    private static final String DEFAULT_SCANNER_NAME = "jboss.deployment:type=DeploymentScanner,flavor=URL";
    protected ObjectName mFarmMemberName = null;
    protected ObjectName mClusterPartitionName = null;
    protected String mBackgroundPartition = "DefaultPartition";
    protected static final String SERVICE_NAME = "FarmMemberService";
    private MBeanServer mServer;
    private Hashtable mDeployedServices = new Hashtable();
    private File mTempDirectory;
    private String mFarmDeployDirectory = "./farm";
    private String mScannerName = "jboss.deployment:type=DeploymentScanner,flavor=URL";
    private File mDeployDirectory;
    private NotificationListener mListener = new Listener();
    static /* synthetic */ Class class$java$net$URL;

    public boolean isDeployed(String pFileURL) throws MalformedURLException, DeploymentException {
        try {
            return (Boolean)this.mServer.invoke(MainDeployerMBean.OBJECT_NAME, "Deployed", new Object[]{new URL(pFileURL)}, new String[]{(class$java$net$URL == null ? (class$java$net$URL = FarmMemberService.class$("java.net.URL")) : class$java$net$URL).getName()});
        }
        catch (JMException jme) {
            this.logException(jme);
            throw new DeploymentException("Could not retrieve isDeployed attribute from local Deployer Service", (Throwable)jme);
        }
    }

    public void deploy(URL pFile) {
        try {
            this.log.info((Object)("deploy(), file: " + pFile));
            File lFile = new File(pFile.getFile());
            Date lFileDate = new Date(lFile.lastModified());
            Date lOldFileDate = (Date)this.mDeployedServices.get(lFile.getName());
            if (lOldFileDate != null && !lFileDate.after(lOldFileDate)) {
                this.log.info((Object)"deploy(), file is locally already deployed, ignore");
                return;
            }
            FarmMemberServiceMBean.FileContent lFileContent = this.getFileContent(lFile);
            HAPartition lHAPartition = (HAPartition)this.mServer.getAttribute(this.mClusterPartitionName, "HAPartition");
            lHAPartition.callMethodOnCluster(SERVICE_NAME, "doDeployment", new Object[]{lFileContent, lFileDate}, false);
        }
        catch (Exception e) {
            this.logException(e);
        }
    }

    public void undeploy(URL pFile) {
        try {
            this.log.info((Object)("undeploy(), file: " + pFile));
            File lFile = new File(pFile.getFile());
            Date lFileDate = new Date(lFile.lastModified());
            HAPartition lHAPartition = (HAPartition)this.mServer.getAttribute(this.mClusterPartitionName, "HAPartition");
            lHAPartition.callMethodOnCluster(SERVICE_NAME, "doUndeployment", new Object[]{lFile, lFileDate}, false);
        }
        catch (Exception e) {
            this.logException(e);
        }
    }

    public void doDeployment(FarmMemberServiceMBean.FileContent pFile, Date pDate) {
        try {
            this.log.info((Object)("doDeployment(), File: " + pFile + ", data: " + pDate));
            Date lLastDate = (Date)this.mDeployedServices.get(pFile.mFile.getName());
            if (lLastDate == null || lLastDate.before(pDate)) {
                File lFile = new File(this.mTempDirectory, pFile.mFile.getName());
                FileOutputStream lOutput = new FileOutputStream(lFile);
                lOutput.write(pFile.mContent);
                lOutput.close();
                this.log.info((Object)("doDeployment(), deploy locally: " + lFile));
                File lFarmFile = new File(this.mDeployDirectory, pFile.mFile.getName());
                if (lFarmFile.exists()) {
                    lFarmFile.delete();
                }
                lFile.setLastModified(pDate.getTime());
                lFile.renameTo(lFarmFile);
                this.log.info((Object)"doDeployment(), file copied back to /deploy/farm");
                this.mDeployedServices.put(lFile.getName(), pDate);
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
    }

    public void doUndeployment(File pFile, Date pDate) {
        try {
            File lFarmFile;
            this.log.info((Object)("doUndeployment(), File: " + pFile + ", data: " + pDate));
            if (this.mDeployedServices.containsKey(pFile.getName()) && (lFarmFile = new File(this.mDeployDirectory, pFile.getName())).exists()) {
                lFarmFile.delete();
                this.log.info((Object)"doUndeployment(), removed file from /deploy/farm");
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
    }

    public FarmMemberServiceMBean.FileContent getFileContent(File pFile) {
        try {
            byte[] lBuffer = new byte[1024];
            FileInputStream lInput = new FileInputStream(pFile);
            ByteArrayOutputStream lOutput = new ByteArrayOutputStream();
            int j = 0;
            while ((j = ((InputStream)lInput).read(lBuffer)) > 0) {
                lOutput.write(lBuffer, 0, j);
            }
            return new FarmMemberServiceMBean.FileContent(pFile, lOutput.toByteArray());
        }
        catch (FileNotFoundException fnfe) {
            this.logException(fnfe);
        }
        catch (IOException ioe) {
            this.logException(ioe);
        }
        return null;
    }

    public String getPartitionName() {
        return this.mBackgroundPartition;
    }

    public void setPartitionName(String pPartitionName) {
        if (this.getState() != 3 && this.getState() != 2) {
            this.mBackgroundPartition = pPartitionName;
        }
    }

    public String getFarmDeployDirectory() {
        return this.mFarmDeployDirectory;
    }

    public void setFarmDeployDirectory(String pDirectory) {
        this.mFarmDeployDirectory = pDirectory == null || pDirectory.trim().equals("") ? DEFAULT_DEPLOY_DIRECTORY : pDirectory;
    }

    public String getScannerName() {
        return this.mScannerName;
    }

    public void setScannerName(String pName) {
        this.mScannerName = pName == null || pName.trim().equals("") ? DEFAULT_SCANNER_NAME : pName;
    }

    public ObjectName preRegister(MBeanServer pServer, ObjectName pName) throws Exception {
        this.mServer = pServer;
        this.log.info((Object)"Farm Member Service MBean online");
        this.mFarmMemberName = new ObjectName(FarmMemberServiceMBean.OBJECT_NAME + ",Partition=" + this.mBackgroundPartition);
        try {
            this.mServer.addNotificationListener(MainDeployerMBean.OBJECT_NAME, this.mListener, (NotificationFilter)new Filter(), null);
        }
        catch (Exception e) {
            this.logException(e);
            throw e;
        }
        return this.mFarmMemberName;
    }

    public void preDeregister() throws Exception {
        try {
            this.mServer.removeNotificationListener(MainDeployerMBean.OBJECT_NAME, this.mListener);
        }
        catch (Exception e) {
            this.logException(e);
            throw e;
        }
        super.preDeregister();
    }

    public String getName() {
        return "Farm Member Service";
    }

    protected void createService() throws Exception {
        ServerConfig lConfig = ServerConfigLocator.locate();
        this.mTempDirectory = lConfig.getServerTempDir();
        this.mDeployDirectory = new File(lConfig.getServerHomeDir(), this.mFarmDeployDirectory);
        if (!this.mDeployDirectory.exists()) {
            this.mDeployDirectory.mkdirs();
        }
    }

    protected void startService() throws Exception {
        this.mClusterPartitionName = new ObjectName("jboss:service=" + this.mBackgroundPartition);
        this.log.debug((Object)"registerRPCHandler");
        HAPartition lHAPartition = (HAPartition)this.mServer.getAttribute(this.mClusterPartitionName, "HAPartition");
        lHAPartition.registerRPCHandler(SERVICE_NAME, this);
        this.log.debug((Object)("Add a new deployment directory to the scanner: " + this.mDeployDirectory));
        this.mServer.invoke(new ObjectName(this.mScannerName), "addURL", new Object[]{this.mDeployDirectory.toURL()}, new String[]{(class$java$net$URL == null ? (class$java$net$URL = FarmMemberService.class$("java.net.URL")) : class$java$net$URL).getName()});
    }

    protected void stopService() {
        try {
            this.log.debug((Object)("Remove the deployment directory from the scanner: " + this.mDeployDirectory));
            this.mServer.invoke(new ObjectName(this.mScannerName), "removeURL", new Object[]{this.mDeployDirectory.toURL()}, new String[]{(class$java$net$URL == null ? (class$java$net$URL = FarmMemberService.class$("java.net.URL")) : class$java$net$URL).getName()});
        }
        catch (Exception e) {
            this.log.error((Object)"Could not remove farm-deploy-directory from Scanner", (Throwable)e);
        }
    }

    private void logException(Throwable e) {
        if (e instanceof RuntimeErrorException) {
            e = ((RuntimeErrorException)e).getTargetError();
        } else if (e instanceof RuntimeMBeanException) {
            e = ((RuntimeMBeanException)e).getTargetException();
        } else if (e instanceof RuntimeOperationsException) {
            e = ((RuntimeOperationsException)e).getTargetException();
        } else if (e instanceof MBeanException) {
            e = ((MBeanException)e).getTargetException();
        } else if (e instanceof ReflectionException) {
            e = ((ReflectionException)e).getTargetException();
        }
        e.printStackTrace();
        this.log.error((Object)e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Filter
    extends NotificationFilterSupport {
        public Filter() {
            this.enableType("Deployment");
            this.enableType("Undeployment");
        }
    }

    public class Listener
    implements NotificationListener {
        public void handleNotification(Notification pNotification, Object pHandback) {
            URL lURL = (URL)pNotification.getUserData();
            try {
                if (lURL.equals(FarmMemberService.this.mDeployDirectory.toURL())) {
                    return;
                }
                if (lURL.toString().startsWith(FarmMemberService.this.mDeployDirectory.toURL().toString())) {
                    if (pNotification.getType().equals("Deployment")) {
                        FarmMemberService.this.deploy(lURL);
                    } else if (pNotification.getType().equals("Undeployment")) {
                        FarmMemberService.this.undeploy(lURL);
                    }
                }
            }
            catch (MalformedURLException ignored) {
                // empty catch block
            }
        }
    }
}

