/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.hasessionstate.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.hasessionstate.interfaces.HASessionState;
import org.jboss.ha.hasessionstate.interfaces.PackagedSession;
import org.jboss.ha.hasessionstate.server.PackagedSessionImpl;
import org.jboss.logging.Logger;
import org.jboss.naming.NonSerializableFactory;

public class HASessionStateImpl
implements HASessionState,
HAPartition.HAPartitionStateTransfer {
    protected String _sessionStateName;
    protected Logger log;
    protected HAPartition hapGeneral;
    protected String sessionStateIdentifier;
    protected String myNodeName;
    protected long beanCleaningDelay;
    protected String haPartitionName;
    protected String haPartitionJndiName;
    protected final String DEFAULT_PARTITION_JNDI_NAME = "DefaultPartition";
    protected final String JNDI_FOLDER_NAME_FOR_HASESSIONSTATE = "/HASessionState/";
    protected final String JNDI_FOLDER_NAME_FOR_HAPARTITION = "/HAPartition/";
    protected final long MAX_DELAY_BEFORE_CLEANING_UNRECLAIMED_STATE = 1800000L;
    protected static final String HA_SESSION_STATE_STATE_TRANSFER = "HASessionStateTransfer";
    protected Hashtable appSessions = new Hashtable();
    protected Object lockAppSession = new Object();
    protected Hashtable listeners = new Hashtable();
    static /* synthetic */ Class class$org$jboss$ha$hasessionstate$server$HASessionStateImpl;
    static /* synthetic */ Class class$org$jboss$naming$NonSerializableFactory;

    public HASessionStateImpl() {
    }

    public HASessionStateImpl(String sessionStateName, String mainHAPartitionName, long beanCleaningDelay) {
        this._sessionStateName = sessionStateName == null ? "/HASessionState/Default" : sessionStateName;
        this.sessionStateIdentifier = "SessionState-'" + this._sessionStateName + "'";
        this.haPartitionName = mainHAPartitionName == null ? "DefaultPartition" : mainHAPartitionName;
        this.haPartitionJndiName = "/HAPartition/" + this.haPartitionName;
        this.beanCleaningDelay = beanCleaningDelay > 0L ? beanCleaningDelay : 1800000L;
    }

    public void init() throws Exception {
        this.log = Logger.getLogger((String)((class$org$jboss$ha$hasessionstate$server$HASessionStateImpl == null ? (class$org$jboss$ha$hasessionstate$server$HASessionStateImpl = HASessionStateImpl.class$("org.jboss.ha.hasessionstate.server.HASessionStateImpl")) : class$org$jboss$ha$hasessionstate$server$HASessionStateImpl).getName() + "." + this._sessionStateName));
        InitialContext ctx = new InitialContext();
        this.hapGeneral = (HAPartition)ctx.lookup(this.haPartitionJndiName);
        if (this.hapGeneral == null) {
            this.log.error((Object)("Unable to get default HAPartition under name '" + this.haPartitionJndiName + "'."));
        }
        this.hapGeneral.registerRPCHandler(this.sessionStateIdentifier, this);
        this.hapGeneral.subscribeToStateTransferEvents(HA_SESSION_STATE_STATE_TRANSFER, this);
        this.bind(this._sessionStateName, this, class$org$jboss$ha$hasessionstate$server$HASessionStateImpl == null ? (class$org$jboss$ha$hasessionstate$server$HASessionStateImpl = HASessionStateImpl.class$("org.jboss.ha.hasessionstate.server.HASessionStateImpl")) : class$org$jboss$ha$hasessionstate$server$HASessionStateImpl, ctx);
    }

    protected void bind(String jndiName, Object who, Class classType, Context ctx) throws Exception {
        NonSerializableFactory.bind((String)jndiName, (Object)who);
        Name n = ctx.getNameParser("").parse(jndiName);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                this.log.debug((Object)("creating Subcontext" + ctxName));
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        StringRefAddr addr = new StringRefAddr("nns", jndiName);
        Reference ref = new Reference(classType.getName(), addr, (class$org$jboss$naming$NonSerializableFactory == null ? (class$org$jboss$naming$NonSerializableFactory = HASessionStateImpl.class$("org.jboss.naming.NonSerializableFactory")) : class$org$jboss$naming$NonSerializableFactory).getName(), null);
        ctx.bind(n.get(0), (Object)ref);
    }

    public void start() throws Exception {
        this.myNodeName = this.hapGeneral.getNodeName();
        this.log.debug((Object)("HASessionState node name : " + this.myNodeName));
    }

    public void stop() throws Exception {
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind(this._sessionStateName);
            NonSerializableFactory.unbind((String)this._sessionStateName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getNodeName() {
        return this.myNodeName;
    }

    public Serializable getCurrentState() {
        this.log.debug((Object)"Building and returning state of HASessionState");
        if (this.appSessions == null) {
            this.appSessions = new Hashtable();
        }
        byte[] result = null;
        Object object = this.lockAppSession;
        synchronized (object) {
            this.purgeState();
            try {
                result = this.deflate(this.appSessions);
            }
            catch (Exception e) {
                this.log.error((Object)"operation failed", (Throwable)e);
            }
        }
        return result;
    }

    public void setCurrentState(Serializable newState) {
        this.log.debug((Object)"Receiving state of HASessionState");
        if (this.appSessions == null) {
            this.appSessions = new Hashtable();
        }
        Object object = this.lockAppSession;
        synchronized (object) {
            try {
                this.appSessions.clear();
                this.appSessions = (Hashtable)this.inflate((byte[])newState);
            }
            catch (Exception e) {
                this.log.error((Object)"operation failed", (Throwable)e);
            }
        }
    }

    public void purgeState() {
        Object object = this.lockAppSession;
        synchronized (object) {
            Enumeration keyEnum = this.appSessions.keys();
            while (keyEnum.hasMoreElements()) {
                Object key = keyEnum.nextElement();
                Hashtable value = (Hashtable)this.appSessions.get(key);
                long currentTime = System.currentTimeMillis();
                Iterator iterSessions = value.values().iterator();
                while (iterSessions.hasNext()) {
                    PackagedSession ps;
                    PackagedSession packagedSession = ps = (PackagedSession)iterSessions.next();
                    synchronized (packagedSession) {
                        if (currentTime - ps.unmodifiedExistenceInVM() > this.beanCleaningDelay) {
                            iterSessions.remove();
                        }
                    }
                }
            }
        }
    }

    protected byte[] deflate(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Deflater def = new Deflater(9);
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, def);
        ObjectOutputStream out = new ObjectOutputStream(dos);
        out.writeObject(object);
        out.close();
        dos.finish();
        dos.close();
        return baos.toByteArray();
    }

    protected Object inflate(byte[] compressedContent) throws IOException {
        if (compressedContent == null) {
            return null;
        }
        try {
            ObjectInputStream in = new ObjectInputStream(new InflaterInputStream(new ByteArrayInputStream(compressedContent)));
            Object object = in.readObject();
            in.close();
            return object;
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    protected Hashtable getHashtableForApp(String appName) {
        if (this.appSessions == null) {
            this.appSessions = new Hashtable();
        }
        Hashtable result = null;
        Object object = this.lockAppSession;
        synchronized (object) {
            result = (Hashtable)this.appSessions.get(appName);
            if (result == null) {
                result = new Hashtable();
                this.appSessions.put(appName, result);
            }
        }
        return result;
    }

    public void createSession(String appName, Object keyId) {
        this._createSession(appName, keyId);
    }

    public PackagedSessionImpl _createSession(String appName, Object keyId) {
        Hashtable app = this.getHashtableForApp(appName);
        PackagedSessionImpl result = new PackagedSessionImpl((Serializable)keyId, null, this.myNodeName);
        app.put(keyId, result);
        return result;
    }

    public void setState(String appName, Object keyId, byte[] state) {
        Hashtable app = this.getHashtableForApp(appName);
        PackagedSession ps = (PackagedSession)app.get(keyId);
        if (ps == null) {
            ps = this._createSession(appName, keyId);
        }
        PackagedSession packagedSession = ps;
        synchronized (packagedSession) {
            if (!ps.setState(state)) {
                Object[] args = new Object[]{appName, ps};
                try {
                    this.hapGeneral.callMethodOnCluster(this.sessionStateIdentifier, "_setState", args, true);
                }
                catch (Exception e) {
                    this.log.error((Object)"operation failed", (Throwable)e);
                }
            }
        }
    }

    public void _setStates(String appName, Hashtable packagedSessions) {
        Object object = this.lockAppSession;
        synchronized (object) {
            Hashtable app = this.getHashtableForApp(appName);
            if (app == null) {
                app = new Hashtable(packagedSessions.size());
                this.appSessions.put(appName, app);
            }
            app.putAll(packagedSessions);
        }
    }

    public void _setState(String appName, PackagedSession session) {
        Hashtable app = this.getHashtableForApp(appName);
        PackagedSession ps = (PackagedSession)app.get(session.getKey());
        if (ps == null) {
            ps = session;
            Hashtable hashtable = app;
            synchronized (hashtable) {
                app.put(ps.getKey(), ps);
            }
        }
        Hashtable hashtable = app;
        synchronized (hashtable) {
            PackagedSession packagedSession = ps;
            synchronized (packagedSession) {
                if (ps.getOwner().equals(this.myNodeName)) {
                    this.ownedObjectExternallyModified(appName, session.getKey(), ps, session);
                }
                ps.update(session);
            }
        }
    }

    public PackagedSession getState(String appName, Object keyId) {
        Hashtable app = this.getHashtableForApp(appName);
        return (PackagedSession)app.get(keyId);
    }

    public PackagedSession getStateWithOwnership(String appName, Object keyId) throws RemoteException {
        return this.localTakeOwnership(appName, keyId);
    }

    public PackagedSession localTakeOwnership(String appName, Object keyId) throws RemoteException {
        PackagedSession ps;
        Hashtable app = this.getHashtableForApp(appName);
        PackagedSession packagedSession = ps = (PackagedSession)app.get(keyId);
        synchronized (packagedSession) {
            if (!ps.getOwner().equals(this.myNodeName)) {
                Object[] args = new Object[]{appName, keyId, this.sessionStateIdentifier, new Long(ps.getVersion())};
                ArrayList answers = null;
                try {
                    answers = this.hapGeneral.callMethodOnCluster(this.sessionStateIdentifier, "_setOwnership", args, true);
                }
                catch (Exception e) {
                    this.log.error((Object)"operation failed", (Throwable)e);
                }
                if (answers != null && answers.contains(Boolean.FALSE)) {
                    throw new RemoteException("Concurent calls on session object.");
                }
                PackagedSession packagedSession2 = ps;
                return packagedSession2;
            }
            PackagedSession packagedSession3 = ps;
            return packagedSession3;
        }
    }

    public Boolean _setOwnership(String appName, Object keyId, String newOwner, Long remoteVersion) {
        Hashtable app = this.getHashtableForApp(appName);
        PackagedSession ps = (PackagedSession)app.get(keyId);
        Boolean answer = Boolean.TRUE;
        PackagedSession packagedSession = ps;
        synchronized (packagedSession) {
            if (!ps.getOwner().equals(this.myNodeName)) {
                answer = Boolean.TRUE;
            } else if (ps.getVersion() > remoteVersion) {
                answer = Boolean.FALSE;
            } else {
                ps.setOwner(newOwner);
                this.ownedObjectExternallyModified(appName, keyId, ps, ps);
                answer = Boolean.TRUE;
            }
        }
        return answer;
    }

    public void takeOwnership(String appName, Object keyId) throws RemoteException {
        this.localTakeOwnership(appName, keyId);
    }

    public void removeSession(String appName, Object keyId) {
        Hashtable app = this.getHashtableForApp(appName);
        if (app != null) {
            Hashtable hashtable = app;
            synchronized (hashtable) {
                PackagedSession ps = (PackagedSession)app.remove(keyId);
                if (ps != null) {
                    PackagedSession packagedSession = ps;
                    synchronized (packagedSession) {
                        Object[] args = new Object[]{appName, keyId};
                        try {
                            this.hapGeneral.callMethodOnCluster(this.sessionStateIdentifier, "_removeSession", args, true);
                        }
                        catch (Exception e) {
                            this.log.error((Object)"operation failed", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public void _removeSession(String appName, Object keyId) {
        Hashtable app = this.getHashtableForApp(appName);
        PackagedSession ps = null;
        Hashtable hashtable = app;
        synchronized (hashtable) {
            ps = (PackagedSession)app.remove(keyId);
        }
        if (ps != null && ps.getOwner().equals(this.myNodeName)) {
            this.ownedObjectExternallyModified(appName, keyId, ps, ps);
        }
    }

    public synchronized void subscribe(String appName, HASessionState.HASessionStateListener listener) {
        Vector<HASessionState.HASessionStateListener> members = (Vector<HASessionState.HASessionStateListener>)this.listeners.get(appName);
        if (members == null) {
            members = new Vector<HASessionState.HASessionStateListener>();
            this.listeners.put(appName, members);
        }
        if (!members.contains(listener)) {
            members.add(listener);
        }
    }

    public synchronized void unsubscribe(String appName, HASessionState.HASessionStateListener listener) {
        Vector members = (Vector)this.listeners.get(appName);
        if (members != null && members.contains(listener)) {
            members.remove(listener);
        }
    }

    public void ownedObjectExternallyModified(String appName, Object key, PackagedSession oldSession, PackagedSession newSession) {
        Vector members = (Vector)this.listeners.get(appName);
        if (members != null) {
            int i = 0;
            while (i < members.size()) {
                ((HASessionState.HASessionStateListener)members.elementAt(i)).sessionExternallyModified(newSession);
                ++i;
            }
        }
    }

    public HAPartition getCurrentHAPartition() {
        return this.hapGeneral;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

