/*
 * Decompiled with CFR 0.152.
 */
package org.jnp.interfaces;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.ServiceUnavailableException;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ResolveResult;
import javax.net.SocketFactory;
import org.jnp.interfaces.MarshalledValuePair;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingEnumerationImpl;
import org.jnp.interfaces.NamingParser;
import org.jnp.interfaces.TimedSocketFactory;

public class NamingContext
implements Context,
Serializable {
    static final long serialVersionUID = 8906455608484282128L;
    public static final String JNP_SOCKET_FACTORY = "jnp.socketFactory";
    public static final String JNP_LOCAL_ADDRESS = "jnp.localAddress";
    public static final String JNP_LOCAL_PORT = "jnp.localPort";
    public static Naming localServer;
    public static final String DEFAULT_DISCOVERY_GROUP_ADDRESS = "230.0.0.4";
    public static final int DEFAULT_DISCOVERY_GROUP_PORT = 1102;
    public static final int DEFAULT_DISCOVERY_TIMEOUT = 5000;
    Naming naming;
    Hashtable env;
    Name prefix;
    NameParser parser = new NamingParser();
    static HashMap cachedServers;
    static /* synthetic */ Class class$org$jnp$interfaces$NamingContext;
    static /* synthetic */ Class class$org$jnp$interfaces$TimedSocketFactory;
    static /* synthetic */ Class class$java$util$Hashtable;

    static void addServer(String name, Naming server) {
        Class clazz = class$org$jnp$interfaces$NamingContext == null ? (class$org$jnp$interfaces$NamingContext = NamingContext.class$("org.jnp.interfaces.NamingContext")) : class$org$jnp$interfaces$NamingContext;
        synchronized (clazz) {
            HashMap newServers = (HashMap)cachedServers.clone();
            newServers.put(name, new WeakReference<Naming>(server));
            cachedServers = newServers;
        }
    }

    static Naming getServer(String host, int port, Hashtable serverEnv) throws NamingException {
        Naming server;
        String hostKey = host + ":" + port;
        WeakReference ref = (WeakReference)cachedServers.get(hostKey);
        if (ref != null && (server = (Naming)ref.get()) != null) {
            return server;
        }
        try {
            Socket s;
            SocketFactory factory = NamingContext.loadSocketFactory(serverEnv);
            try {
                InetAddress localAddr = null;
                int localPort = 0;
                String localAddrStr = (String)serverEnv.get(JNP_LOCAL_ADDRESS);
                String localPortStr = (String)serverEnv.get(JNP_LOCAL_PORT);
                if (localAddrStr != null) {
                    localAddr = InetAddress.getByName(localAddrStr);
                }
                if (localPortStr != null) {
                    localPort = Integer.parseInt(localPortStr);
                }
                s = factory.createSocket(host, port, localAddr, localPort);
            }
            catch (IOException e) {
                ServiceUnavailableException ex = new ServiceUnavailableException("Failed to connect to server " + hostKey);
                ex.setRootCause(e);
                throw ex;
            }
            BufferedInputStream bis = new BufferedInputStream(s.getInputStream());
            ObjectInputStream in = new ObjectInputStream(bis);
            MarshalledObject stub = (MarshalledObject)in.readObject();
            server = (Naming)stub.get();
            s.close();
            NamingContext.addServer(hostKey, server);
            return server;
        }
        catch (IOException e) {
            CommunicationException ex = new CommunicationException("Failed to retrieve stub from server " + hostKey);
            ex.setRootCause(e);
            throw ex;
        }
        catch (Exception e) {
            CommunicationException ex = new CommunicationException("Failed to connect to server " + hostKey);
            ex.setRootCause(e);
            throw ex;
        }
    }

    static SocketFactory loadSocketFactory(Hashtable serverEnv) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        SocketFactory factory = null;
        String socketFactoryName = (String)serverEnv.get(JNP_SOCKET_FACTORY);
        if (socketFactoryName == null || socketFactoryName.equals((class$org$jnp$interfaces$TimedSocketFactory == null ? (class$org$jnp$interfaces$TimedSocketFactory = NamingContext.class$("org.jnp.interfaces.TimedSocketFactory")) : class$org$jnp$interfaces$TimedSocketFactory).getName())) {
            factory = new TimedSocketFactory(serverEnv);
            return factory;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> factoryClass = loader.loadClass(socketFactoryName);
        try {
            Class[] ctorSig = new Class[]{class$java$util$Hashtable == null ? (class$java$util$Hashtable = NamingContext.class$("java.util.Hashtable")) : class$java$util$Hashtable};
            Constructor<?> ctor = factoryClass.getConstructor(ctorSig);
            Object[] ctorArgs = new Object[]{serverEnv};
            factory = (SocketFactory)ctor.newInstance(ctorArgs);
        }
        catch (NoSuchMethodException e) {
            factory = (SocketFactory)factoryClass.newInstance();
        }
        return factory;
    }

    static void removeServer(Hashtable serverEnv) {
        String host = "localhost";
        int port = 1099;
        if (serverEnv.get("java.naming.provider.url") != null) {
            String providerURL = (String)serverEnv.get("java.naming.provider.url");
            StringTokenizer tkn = new StringTokenizer(providerURL, ":");
            host = tkn.nextToken();
            try {
                port = Integer.parseInt(tkn.nextToken());
            }
            catch (Exception ex) {
                // empty catch block
            }
            Class clazz = class$org$jnp$interfaces$NamingContext == null ? (class$org$jnp$interfaces$NamingContext = NamingContext.class$("org.jnp.interfaces.NamingContext")) : class$org$jnp$interfaces$NamingContext;
            synchronized (clazz) {
                HashMap newServers = (HashMap)cachedServers.clone();
                newServers.remove(host + ":" + port);
                cachedServers = newServers;
            }
        }
    }

    static String parseNameForScheme(Name n) throws InvalidNameException {
        String serverInfo = null;
        if (n.size() > 0) {
            String scheme = n.get(0);
            int schemeLength = 0;
            if (scheme.startsWith("java:")) {
                schemeLength = 5;
            } else if (scheme.startsWith("jnp:")) {
                schemeLength = 4;
            }
            if (schemeLength > 0) {
                String suffix = scheme.substring(schemeLength);
                if (suffix.length() == 0) {
                    n.remove(0);
                    if (n.size() > 1 && n.get(0).equals("")) {
                        serverInfo = n.get(1);
                        n.remove(0);
                        n.remove(0);
                        if (n.size() == 1 && n.get(0).length() == 0) {
                            n.remove(0);
                        }
                    }
                } else {
                    n.remove(0);
                    n.add(0, suffix);
                }
            }
        }
        return serverInfo;
    }

    public static void setLocal(Naming server) {
        localServer = server;
    }

    public NamingContext(Hashtable e, Name baseName, Naming server) throws NamingException {
        this.prefix = baseName == null ? this.parser.parse("") : baseName;
        this.env = e != null ? (Hashtable)e.clone() : new Hashtable();
        this.naming = server;
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(this.getNameParser(name).parse(name), obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        Hashtable refEnv = this.getEnv(name);
        this.checkRef(refEnv);
        try {
            String className;
            if (obj instanceof Referenceable) {
                obj = ((Referenceable)obj).getReference();
            }
            if (!(obj instanceof Reference)) {
                className = obj.getClass().getName();
                obj = new MarshalledValuePair(obj);
            } else {
                className = ((Reference)obj).getClassName();
            }
            this.naming.rebind(this.getAbsoluteName(name), obj, className);
        }
        catch (CannotProceedException cpe) {
            cpe.setEnvironment(refEnv);
            Context cctx = NamingManager.getContinuationContext(cpe);
            cctx.rebind(cpe.getRemainingName(), obj);
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(refEnv);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(this.getNameParser(name).parse(name), obj);
    }

    public void bind(Name name, Object obj) throws NamingException {
        Hashtable refEnv = this.getEnv(name);
        this.checkRef(refEnv);
        try {
            String className;
            if (obj instanceof Referenceable) {
                obj = ((Referenceable)obj).getReference();
            }
            if (!(obj instanceof Reference)) {
                className = obj.getClass().getName();
                obj = new MarshalledValuePair(obj);
            } else {
                className = ((Reference)obj).getClassName();
            }
            name = this.getAbsoluteName(name);
            this.naming.bind(name, obj, className);
        }
        catch (CannotProceedException cpe) {
            cpe.setEnvironment(refEnv);
            Context cctx = NamingManager.getContinuationContext(cpe);
            cctx.bind(cpe.getRemainingName(), obj);
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(refEnv);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(this.getNameParser(name).parse(name));
    }

    public Object lookup(Name name) throws NamingException {
        Hashtable refEnv = this.getEnv(name);
        this.checkRef(refEnv);
        if (name.isEmpty()) {
            return new NamingContext(refEnv, this.prefix, this.naming);
        }
        try {
            Name n = this.getAbsoluteName(name);
            Object res = this.naming.lookup(n);
            if (res instanceof MarshalledValuePair) {
                MarshalledValuePair mvp = (MarshalledValuePair)res;
                return mvp.get();
            }
            if (res instanceof MarshalledObject) {
                MarshalledObject mo = (MarshalledObject)res;
                return mo.get();
            }
            if (res instanceof Context) {
                Enumeration keys = refEnv.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    ((Context)res).addToEnvironment(key, refEnv.get(key));
                }
                return res;
            }
            if (res instanceof ResolveResult) {
                try {
                    Object resolveRes = ((ResolveResult)res).getResolvedObj();
                    if (resolveRes instanceof LinkRef) {
                        String ref = ((LinkRef)resolveRes).getLinkName();
                        try {
                            Context ctx = ref.startsWith("./") ? (Context)this.lookup(ref.substring(2)) : (Context)new InitialContext(refEnv).lookup(ref);
                            return ctx.lookup(((ResolveResult)res).getRemainingName());
                        }
                        catch (ClassCastException e) {
                            throw new NotContextException(ref + " is not a context");
                        }
                    }
                    try {
                        Context ctx = (Context)NamingManager.getObjectInstance(resolveRes, this.getAbsoluteName(name), this, refEnv);
                        return ctx.lookup(((ResolveResult)res).getRemainingName());
                    }
                    catch (ClassCastException e) {
                        throw new NotContextException();
                    }
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    NamingException ex = new NamingException("Could not dereference object");
                    ex.setRootCause(e);
                    throw ex;
                }
            }
            if (res instanceof LinkRef) {
                try {
                    String ref = ((LinkRef)res).getLinkName();
                    if (ref.startsWith("./")) {
                        return this.lookup(ref.substring(2));
                    }
                    return new InitialContext(refEnv).lookup(ref);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    NamingException ex = new NamingException("Could not dereference object");
                    ex.setRootCause(e);
                    throw ex;
                }
            }
            if (res instanceof Reference) {
                try {
                    return NamingManager.getObjectInstance(res, this.getAbsoluteName(name), this, refEnv);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    NamingException ex = new NamingException("Could not dereference object");
                    ex.setRootCause(e);
                    throw ex;
                }
            }
            return res;
        }
        catch (CannotProceedException cpe) {
            cpe.setEnvironment(refEnv);
            Context cctx = NamingManager.getContinuationContext(cpe);
            return cctx.lookup(cpe.getRemainingName());
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(refEnv);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
        catch (ClassNotFoundException e) {
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
    }

    public void unbind(String name) throws NamingException {
        this.unbind(this.getNameParser(name).parse(name));
    }

    public void unbind(Name name) throws NamingException {
        Hashtable refEnv = this.getEnv(name);
        this.checkRef(refEnv);
        try {
            this.naming.unbind(this.getAbsoluteName(name));
        }
        catch (CannotProceedException cpe) {
            cpe.setEnvironment(refEnv);
            Context cctx = NamingManager.getContinuationContext(cpe);
            cctx.unbind(cpe.getRemainingName());
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(refEnv);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
    }

    public void rename(String oldname, String newname) throws NamingException {
        this.rename(this.getNameParser(oldname).parse(oldname), this.getNameParser(newname).parse(newname));
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.bind(newName, this.lookup(oldName));
        this.unbind(oldName);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(this.getNameParser(name).parse(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        Hashtable refEnv = this.getEnv(name);
        this.checkRef(refEnv);
        try {
            return new NamingEnumerationImpl(this.naming.list(this.getAbsoluteName(name)));
        }
        catch (CannotProceedException cpe) {
            cpe.setEnvironment(refEnv);
            Context cctx = NamingManager.getContinuationContext(cpe);
            return cctx.list(cpe.getRemainingName());
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(refEnv);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(this.getNameParser(name).parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        Hashtable refEnv = this.getEnv(name);
        this.checkRef(refEnv);
        try {
            Collection bindings = this.naming.listBindings(this.getAbsoluteName(name));
            ArrayList<Binding> realBindings = new ArrayList<Binding>(bindings.size());
            Iterator iterator = bindings.iterator();
            while (iterator.hasNext()) {
                Binding binding = (Binding)iterator.next();
                Object obj = binding.getObject();
                if (obj instanceof MarshalledValuePair) {
                    try {
                        obj = ((MarshalledValuePair)obj).get();
                    }
                    catch (ClassNotFoundException e) {
                        CommunicationException ex = new CommunicationException();
                        ex.setRootCause(e);
                        throw ex;
                    }
                }
                if (obj instanceof MarshalledObject) {
                    try {
                        obj = ((MarshalledObject)obj).get();
                    }
                    catch (ClassNotFoundException e) {
                        CommunicationException ex = new CommunicationException();
                        ex.setRootCause(e);
                        throw ex;
                    }
                }
                realBindings.add(new Binding(binding.getName(), binding.getClassName(), obj));
            }
            return new NamingEnumerationImpl(realBindings);
        }
        catch (CannotProceedException cpe) {
            cpe.setEnvironment(refEnv);
            Context cctx = NamingManager.getContinuationContext(cpe);
            return cctx.listBindings(cpe.getRemainingName());
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(refEnv);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(this.parser.parse(name), this.parser.parse(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.parser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.getNameParser(name).parse(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Cannot pass an empty name to createSubcontext");
        }
        Hashtable refEnv = this.getEnv(name);
        this.checkRef(refEnv);
        try {
            name = this.getAbsoluteName(name);
            return this.naming.createSubcontext(name);
        }
        catch (CannotProceedException cpe) {
            cpe.setEnvironment(refEnv);
            Context cctx = NamingManager.getContinuationContext(cpe);
            return cctx.createSubcontext(cpe.getRemainingName());
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(refEnv);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        Object old = this.env.get(propName);
        this.env.put(propName, propVal);
        return old;
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    public void close() throws NamingException {
        this.env = null;
        this.naming = null;
    }

    public String getNameInNamespace() throws NamingException {
        return this.prefix.toString();
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(this.getNameParser(name).parse(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this.lookup(name);
        }
        Object link = null;
        try {
            Name n = this.getAbsoluteName(name);
            link = this.naming.lookup(n);
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(this.env);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
        return link;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Naming discoverServer(Hashtable serverEnv) throws NamingException {
        block16: {
            block15: {
                s = null;
                try {
                    try {
                        group = "230.0.0.4";
                        port = 1102;
                        timeout = 5000;
                        discoveryTimeout = (String)serverEnv.get("DISCOVERY_TIMEOUT");
                        if (discoveryTimeout != null && !discoveryTimeout.equals("")) {
                            timeout = Integer.parseInt(discoveryTimeout);
                        }
                        if ((discoveryGroupPort = (String)serverEnv.get("DISCOVERY_GROUP")) != null && !discoveryGroupPort.equals("")) {
                            colon = discoveryGroupPort.indexOf(58);
                            if (colon < 0) {
                                group = discoveryGroupPort;
                            } else {
                                group = discoveryGroupPort.substring(0, colon);
                                try {
                                    port = Integer.parseInt(discoveryGroupPort.substring(colon + 1));
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                        }
                        iaGroup = InetAddress.getByName(group);
                        s = new DatagramSocket();
                        s.setSoTimeout(timeout);
                        buf = "GET_ADDRESS".getBytes();
                        packet = new DatagramPacket(buf, buf.length, iaGroup, port);
                        s.send(packet);
                        buf = new byte[50];
                        packet = new DatagramPacket(buf, buf.length);
                        s.receive(packet);
                        myServer = new String(packet.getData());
                        colon = myServer.indexOf(58);
                        if (colon < 0) {
                            var16_17 = null;
                            var19_18 = null;
                            break block15;
                        }
                        serverHost = myServer.substring(0, colon);
                        serverPort = Double.valueOf(myServer.substring(colon + 1)).intValue();
                        var17_26 = NamingContext.getServer(serverHost, serverPort, serverEnv);
                        break block16;
                    }
                    catch (IOException e) {
                        ex = new CommunicationException(e.getMessage());
                        ex.setRootCause(e);
                        throw ex;
                    }
                }
                catch (Throwable var18_27) {
                    var19_20 = null;
                    try {
                        if (s == null) throw var18_27;
                        s.close();
                        throw var18_27;
                    }
                    catch (Exception ignore) {
                        throw var18_27;
                    }
                }
            }
            ** try [egrp 3[TRYBLOCK] [3 : 319->330)] { 
lbl57:
            // 1 sources

            if (s == null) return var16_17;
            s.close();
            return var16_17;
lbl60:
            // 1 sources

            catch (Exception ignore) {
                // empty catch block
            }
            return var16_17;
        }
        var19_19 = null;
        ** try [egrp 3[TRYBLOCK] [3 : 319->330)] { 
lbl66:
        // 1 sources

        if (s == null) return var17_26;
        s.close();
        return var17_26;
lbl69:
        // 1 sources

        catch (Exception ignore) {
            // empty catch block
        }
        return var17_26;
    }

    private void checkRef(Hashtable refEnv) throws NamingException {
        if (this.naming == null) {
            String host = "localhost";
            int port = 1099;
            String urls = (String)refEnv.get("java.naming.provider.url");
            if (urls != null && urls.length() > 0) {
                StringTokenizer tokenizer = new StringTokenizer(urls, ",");
                while (tokenizer.hasMoreElements()) {
                    String url = tokenizer.nextToken();
                    int colon = url.indexOf(58);
                    if (colon < 0) {
                        host = url;
                    } else {
                        host = url.substring(0, colon);
                        try {
                            port = Integer.parseInt(url.substring(colon + 1));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    try {
                        this.naming = NamingContext.getServer(host, port, refEnv);
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                if (this.naming == null) {
                    this.naming = this.discoverServer(refEnv);
                    if (this.naming == null) {
                        throw new CommunicationException("Could not obtain connection to any of these urls: " + urls);
                    }
                }
            } else {
                this.naming = localServer;
                if (this.naming == null) {
                    this.naming = this.discoverServer(refEnv);
                    if (this.naming == null) {
                        throw new ConfigurationException("No valid Context.PROVIDER_URL was found");
                    }
                }
            }
        }
    }

    private Name getAbsoluteName(Name n) throws NamingException {
        if (n.isEmpty()) {
            return this.composeName(n, this.prefix);
        }
        if (n.get(0).toString().equals("")) {
            return n.getSuffix(1);
        }
        return this.composeName(n, this.prefix);
    }

    private Hashtable getEnv(Name n) throws InvalidNameException {
        Hashtable nameEnv = this.env;
        String serverInfo = NamingContext.parseNameForScheme(n);
        if (serverInfo != null) {
            nameEnv = (Hashtable)this.env.clone();
            nameEnv.put("java.naming.provider.url", serverInfo);
        }
        return nameEnv;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        cachedServers = new HashMap();
    }
}

