/*
 * Decompiled with CFR 0.152.
 */
package org.jnp.interfaces;

import java.util.Hashtable;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;
import org.jnp.interfaces.NamingContext;
import org.jnp.interfaces.NamingParser;

public class NamingContextFactory
implements InitialContextFactory,
ObjectFactory {
    public Context getInitialContext(Hashtable env) throws NamingException {
        CompoundName name;
        String serverInfo;
        String providerURL = (String)env.get("java.naming.provider.url");
        CompoundName prefix = null;
        if (providerURL != null && (serverInfo = NamingContext.parseNameForScheme(name = new CompoundName(providerURL, NamingParser.syntax))) != null) {
            env = (Hashtable)env.clone();
            env.put("java.naming.provider.url", serverInfo);
            prefix = name;
        }
        return new NamingContext(env, prefix, null);
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        Context ctx = this.getInitialContext(environment);
        Reference ref = (Reference)obj;
        return ctx.lookup((String)ref.get("URL").getContent());
    }
}

