/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.property;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.varia.property.PropertyEditorManagerServiceMBean;

public class PropertyEditorManagerService
extends ServiceMBeanSupport
implements PropertyEditorManagerServiceMBean {
    public PropertyEditor findEditor(Class type) {
        return PropertyEditorManager.findEditor(type);
    }

    public PropertyEditor findEditor(String typeName) throws ClassNotFoundException {
        Class<?> type = Class.forName(typeName);
        return PropertyEditorManager.findEditor(type);
    }

    public void registerEditor(Class type, Class editorType) {
        PropertyEditorManager.registerEditor(type, editorType);
    }

    public void registerEditor(String typeName, String editorTypeName) throws ClassNotFoundException {
        Class<?> type = Class.forName(typeName);
        Class<?> editorType = Class.forName(editorTypeName);
        PropertyEditorManager.registerEditor(type, editorType);
    }

    private String makeString(String[] array) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            buff.append(array[i]);
            if (i + 1 < array.length) {
                buff.append(",");
            }
            ++i;
        }
        return buff.toString();
    }

    private String[] makeArray(String listspec) {
        StringTokenizer stok = new StringTokenizer(listspec, ",");
        LinkedList<String> list = new LinkedList<String>();
        while (stok.hasMoreTokens()) {
            String url = stok.nextToken();
            list.add(url);
        }
        return list.toArray(new String[list.size()]);
    }

    public String getEditorSearchPath() {
        return this.makeString(PropertyEditorManager.getEditorSearchPath());
    }

    public void setEditorSearchPath(String path) {
        PropertyEditorManager.setEditorSearchPath(this.makeArray(path));
    }

    public void setEditors(Properties props) throws ClassNotFoundException {
        Iterator<Object> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String typeName = (String)iter.next();
            String editorTypeName = props.getProperty(typeName);
            this.registerEditor(typeName, editorTypeName);
        }
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? PropertyEditorManagerServiceMBean.OBJECT_NAME : name;
    }
}

