/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.hsqldb.Access;
import org.hsqldb.Channel;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.DatabaseInformation;
import org.hsqldb.Library;
import org.hsqldb.Log;
import org.hsqldb.Parser;
import org.hsqldb.Result;
import org.hsqldb.Table;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.Trigger;
import org.hsqldb.TriggerDef;
import org.hsqldb.User;

class Database {
    private String sName;
    private Access aAccess;
    private Vector tTable;
    private DatabaseInformation dInfo;
    private Log lLog;
    private boolean bReadOnly;
    private boolean bShutdown;
    private Hashtable hAlias;
    private boolean bIgnoreCase;
    private boolean bReferentialIntegrity;
    private Vector cChannel;

    Database(String name) throws SQLException {
        this.sName = name;
        this.tTable = new Vector();
        this.aAccess = new Access();
        this.cChannel = new Vector();
        this.hAlias = new Hashtable();
        this.bReferentialIntegrity = true;
        Library.register(this.hAlias);
        this.dInfo = new DatabaseInformation(this, this.tTable, this.aAccess);
        boolean newdatabase = false;
        Channel sys = new Channel(this, new User(null, null, true, null), true, false, 0);
        this.registerChannel(sys);
        if (name.equals(".")) {
            newdatabase = true;
        } else {
            this.lLog = new Log(this, sys, name);
            newdatabase = this.lLog.open();
        }
        if (newdatabase) {
            this.execute("CREATE USER SA PASSWORD \"\" ADMIN", sys);
        }
        this.aAccess.grant("PUBLIC", "CLASS \"java.lang.Math\"", 15);
        this.aAccess.grant("PUBLIC", "CLASS \"org.hsqldb.Library\"", 15);
    }

    String getName() {
        return this.sName;
    }

    boolean isShutdown() {
        return this.bShutdown;
    }

    synchronized Channel connect(String username, String password) throws SQLException {
        int size;
        User user = this.aAccess.getUser(username.toUpperCase(), password.toUpperCase());
        int id = size = this.cChannel.size();
        int i = 0;
        while (i < size) {
            if (this.cChannel.elementAt(i) == null) {
                id = i;
                break;
            }
            ++i;
        }
        Channel c = new Channel(this, user, true, this.bReadOnly, id);
        if (this.lLog != null) {
            this.lLog.write(c, "CONNECT USER " + username + " PASSWORD \"" + password + "\"");
        }
        this.registerChannel(c);
        return c;
    }

    void registerChannel(Channel channel) {
        int size = this.cChannel.size();
        int id = channel.getId();
        if (id >= size) {
            this.cChannel.setSize(id + 1);
        }
        this.cChannel.setElementAt(channel, id);
    }

    byte[] execute(String user, String password, String statement) {
        Result r = null;
        try {
            Channel channel = this.connect(user, password);
            r = this.execute(statement, channel);
            this.execute("DISCONNECT", channel);
        }
        catch (Exception e) {
            r = new Result(e.getMessage());
        }
        try {
            return r.getBytes();
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    synchronized Result execute(String statement, Channel channel) {
        Tokenizer c = new Tokenizer(statement);
        Parser p = new Parser(this, c, channel);
        Result rResult = new Result();
        try {
            if (this.lLog != null && this.lLog.cCache != null) {
                this.lLog.cCache.cleanUp();
            }
            Trace.check(channel != null, 31);
            Trace.check(!this.bShutdown, 3);
            while (true) {
                int begin = c.getPosition();
                boolean script = false;
                String sToken = c.getString();
                if (!sToken.equals("")) {
                    if (sToken.equals("SELECT")) {
                        rResult = p.processSelect();
                    } else if (sToken.equals("INSERT")) {
                        rResult = p.processInsert();
                    } else if (sToken.equals("UPDATE")) {
                        rResult = p.processUpdate();
                    } else if (sToken.equals("DELETE")) {
                        rResult = p.processDelete();
                    } else if (sToken.equals("CREATE")) {
                        rResult = this.processCreate(c, channel);
                        script = true;
                    } else if (sToken.equals("DROP")) {
                        rResult = this.processDrop(c, channel);
                        script = true;
                    } else if (sToken.equals("GRANT")) {
                        rResult = this.processGrantOrRevoke(c, channel, true);
                        script = true;
                    } else if (sToken.equals("REVOKE")) {
                        rResult = this.processGrantOrRevoke(c, channel, false);
                        script = true;
                    } else if (sToken.equals("CONNECT")) {
                        rResult = this.processConnect(c, channel);
                    } else if (sToken.equals("DISCONNECT")) {
                        rResult = this.processDisconnect(c, channel);
                    } else if (sToken.equals("SET")) {
                        rResult = this.processSet(c, channel);
                        script = true;
                    } else if (sToken.equals("SCRIPT")) {
                        rResult = this.processScript(c, channel);
                    } else if (sToken.equals("COMMIT")) {
                        rResult = this.processCommit(c, channel);
                        script = true;
                    } else if (sToken.equals("ROLLBACK")) {
                        rResult = this.processRollback(c, channel);
                        script = true;
                    } else if (sToken.equals("SHUTDOWN")) {
                        rResult = this.processShutdown(c, channel);
                    } else if (sToken.equals("CHECKPOINT")) {
                        rResult = this.processCheckpoint(channel);
                    } else if (sToken.equals("CALL")) {
                        rResult = p.processCall();
                    } else if (!sToken.equals(";")) {
                        throw Trace.error(10, sToken);
                    }
                    if (!script || this.lLog == null) continue;
                    int end = c.getPosition();
                    this.lLog.write(channel, c.getPart(begin, end));
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            rResult = new Result(Trace.getMessage(e) + " in statement [" + statement + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
            String s = Trace.getMessage(38) + " " + e;
            rResult = new Result(s + " in statement [" + statement + "]");
        }
        return rResult;
    }

    void setReadOnly() {
        this.bReadOnly = true;
    }

    Vector getTables() {
        return this.tTable;
    }

    void setReferentialIntegrity(boolean ref) {
        this.bReferentialIntegrity = ref;
    }

    boolean isReferentialIntegrity() {
        return this.bReferentialIntegrity;
    }

    Hashtable getAlias() {
        return this.hAlias;
    }

    String getAlias(String s) {
        Object o = this.hAlias.get(s);
        if (o == null) {
            return s;
        }
        return (String)o;
    }

    Log getLog() {
        return this.lLog;
    }

    Table getTable(String name, Channel channel) throws SQLException {
        Table t = null;
        int i = 0;
        while (i < this.tTable.size()) {
            t = (Table)this.tTable.elementAt(i);
            if (t.getName().equals(name)) {
                return t;
            }
            ++i;
        }
        t = this.dInfo.getSystemTable(name, channel);
        if (t == null) {
            throw Trace.error(21, name);
        }
        return t;
    }

    Result getScript(boolean drop, boolean insert, boolean cached, Channel channel) throws SQLException {
        return this.dInfo.getScript(drop, insert, cached, channel);
    }

    void linkTable(Table t) throws SQLException {
        String name = t.getName();
        int i = 0;
        while (i < this.tTable.size()) {
            Table o = (Table)this.tTable.elementAt(i);
            if (o.getName().equals(name)) {
                throw Trace.error(20, name);
            }
            ++i;
        }
        this.tTable.addElement(t);
    }

    boolean isIgnoreCase() {
        return this.bIgnoreCase;
    }

    private Result processScript(Tokenizer c, Channel channel) throws SQLException {
        String sToken = c.getString();
        if (c.wasValue()) {
            sToken = (String)c.getAsValue();
            Log.scriptToFile(this, sToken, true, channel);
            return new Result();
        }
        c.back();
        return this.getScript(true, true, false, channel);
    }

    private Result processCreate(Tokenizer c, Channel channel) throws SQLException {
        channel.checkReadWrite();
        channel.checkAdmin();
        String sToken = c.getString();
        if (sToken.equals("TABLE")) {
            this.processCreateTable(c, channel, false);
        } else if (sToken.equals("MEMORY")) {
            c.getThis("TABLE");
            this.processCreateTable(c, channel, false);
        } else if (sToken.equals("CACHED")) {
            c.getThis("TABLE");
            this.processCreateTable(c, channel, true);
        } else if (sToken.equals("TRIGGER")) {
            this.processCreateTrigger(c, channel);
        } else if (sToken.equals("USER")) {
            String u = c.getStringToken();
            c.getThis("PASSWORD");
            String p = c.getStringToken();
            boolean admin = c.getString().equals("ADMIN");
            this.aAccess.createUser(u, p, admin);
        } else if (sToken.equals("ALIAS")) {
            String name = c.getString();
            sToken = c.getString();
            Trace.check(sToken.equals("FOR"), 10, sToken);
            sToken = c.getString();
            if (sToken.startsWith("org.hsql.Library.")) {
                sToken = "org.hsqldb.Library." + sToken.substring("org.hsql.Library.".length());
            }
            this.hAlias.put(name, sToken);
        } else {
            boolean unique = false;
            if (sToken.equals("UNIQUE")) {
                unique = true;
                sToken = c.getString();
            }
            if (!sToken.equals("INDEX")) {
                throw Trace.error(10, sToken);
            }
            String name = c.getName();
            c.getThis("ON");
            Table t = this.getTable(c.getString(), channel);
            this.addIndexOn(c, channel, name, t, unique);
        }
        return new Result();
    }

    private int[] processColumnList(Tokenizer c, Table t) throws SQLException {
        Vector<String> v;
        block2: {
            String sToken;
            v = new Vector<String>();
            c.getThis("(");
            do {
                v.addElement(c.getString());
                sToken = c.getString();
                if (sToken.equals(")")) break block2;
            } while (sToken.equals(","));
            throw Trace.error(10, sToken);
        }
        int s = v.size();
        int[] col = new int[s];
        int i = 0;
        while (i < s) {
            col[i] = t.getColumnNr((String)v.elementAt(i));
            ++i;
        }
        return col;
    }

    private void createIndex(Channel channel, Table t, int[] col, String name, boolean unique) throws SQLException {
        channel.commit();
        if (t.isEmpty()) {
            t.createIndex(col, name, unique);
        } else {
            Table tn = t.moveDefinition(null);
            tn.createIndex(col, name, unique);
            tn.moveData(t);
            this.dropTable(t.getName());
            this.linkTable(tn);
        }
    }

    private void addForeignKeyOn(Tokenizer c, Channel channel, String name, Table t) throws SQLException {
        int[] col = this.processColumnList(c, t);
        c.getThis("REFERENCES");
        Table t2 = this.getTable(c.getString(), channel);
        int[] col2 = this.processColumnList(c, t2);
        if (t.getIndexForColumns(col) == null) {
            this.createIndex(channel, t, col, "SYSTEM_FOREIGN_KEY_" + name, false);
        }
        if (t2.getIndexForColumns(col2) == null) {
            this.createIndex(channel, t2, col2, "SYSTEM_REFERENCE_" + name, false);
        }
        t.addConstraint(new Constraint(0, t2, t, col2, col));
        t2.addConstraint(new Constraint(1, t2, t, col2, col));
    }

    private void addUniqueConstraintOn(Tokenizer c, Channel channel, String name, Table t) throws SQLException {
        int[] col = this.processColumnList(c, t);
        this.createIndex(channel, t, col, name, true);
        t.addConstraint(new Constraint(2, t, col));
    }

    private void addIndexOn(Tokenizer c, Channel channel, String name, Table t, boolean unique) throws SQLException {
        int[] col = this.processColumnList(c, t);
        this.createIndex(channel, t, col, name, unique);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processCreateTrigger(Tokenizer c, Channel channel) throws SQLException {
        boolean bForEach = false;
        String sTrigName = c.getName();
        String sWhen = c.getString();
        String sOper = c.getString();
        c.getThis("ON");
        String sTableName = c.getString();
        Table t = this.getTable(sTableName, channel);
        String tok = c.getString();
        if (tok.equals("FOR")) {
            tok = c.getString();
            if (!tok.equals("EACH")) throw Trace.error(11, tok);
            tok = c.getString();
            if (!tok.equals("ROW")) throw Trace.error(11, tok);
            bForEach = true;
            tok = c.getString();
        }
        if (!tok.equals("CALL")) {
            throw Trace.error(11, tok);
        }
        String sClassName = c.getString();
        try {
            Class<?> cl = Class.forName(sClassName);
            Trigger o = (Trigger)cl.newInstance();
            TriggerDef td = new TriggerDef(sTrigName, sWhen, sOper, bForEach, t, o, "\"" + sClassName + "\"");
            if (!td.isValid()) {
                String msg = "Error in parsing trigger command ";
                throw Trace.error(10, msg);
            }
            t.addTrigger(td);
            td.start();
            return;
        }
        catch (Exception e) {
            String msg = "Exception in loading trigger class " + e.getMessage();
            throw Trace.error(12, msg);
        }
    }

    private void processCreateTable(Tokenizer c, Channel channel, boolean cached) throws SQLException {
        Table t;
        block22: {
            String sToken = c.getName();
            t = cached && this.lLog != null ? new Table(this, true, sToken, true) : new Table(this, true, sToken, false);
            c.getThis("(");
            int primarykeycolumn = -1;
            int column = 0;
            boolean constraint = false;
            while (true) {
                boolean identity = false;
                sToken = c.getString();
                if (sToken.equals("CONSTRAINT") || sToken.equals("PRIMARY") || sToken.equals("FOREIGN") || sToken.equals("UNIQUE")) {
                    c.back();
                    constraint = true;
                    break;
                }
                String sColumn = sToken;
                int iType = Column.getTypeNr(c.getString());
                if (iType == 12 && this.bIgnoreCase) {
                    iType = 100;
                }
                sToken = c.getString();
                if (iType == 8 && sToken.equals("PRECISION")) {
                    sToken = c.getString();
                }
                if (sToken.equals("(")) {
                    while (!(sToken = c.getString()).equals(")")) {
                    }
                    sToken = c.getString();
                }
                boolean nullable = true;
                if (sToken.equals("NULL")) {
                    sToken = c.getString();
                } else if (sToken.equals("NOT")) {
                    c.getThis("NULL");
                    nullable = false;
                    sToken = c.getString();
                }
                if (sToken.equals("IDENTITY")) {
                    identity = true;
                    Trace.check(primarykeycolumn == -1, 23, sColumn);
                    sToken = c.getString();
                    primarykeycolumn = column;
                }
                if (sToken.equals("PRIMARY")) {
                    c.getThis("KEY");
                    Trace.check(identity || primarykeycolumn == -1, 23, sColumn);
                    primarykeycolumn = column;
                    sToken = c.getString();
                }
                t.addColumn(sColumn, iType, nullable, identity);
                if (sToken.equals(")")) break;
                if (!sToken.equals(",")) {
                    throw Trace.error(10, sToken);
                }
                ++column;
            }
            if (primarykeycolumn != -1) {
                t.createPrimaryKey(primarykeycolumn);
            } else {
                t.createPrimaryKey();
            }
            if (constraint) {
                int i = 0;
                do {
                    sToken = c.getString();
                    String name = "SYSTEM_CONSTRAINT" + i;
                    ++i;
                    if (sToken.equals("CONSTRAINT")) {
                        name = c.getString();
                        sToken = c.getString();
                    }
                    if (sToken.equals("PRIMARY")) {
                        c.getThis("KEY");
                        this.addUniqueConstraintOn(c, channel, name, t);
                    } else if (sToken.equals("UNIQUE")) {
                        this.addUniqueConstraintOn(c, channel, name, t);
                    } else if (sToken.equals("FOREIGN")) {
                        c.getThis("KEY");
                        this.addForeignKeyOn(c, channel, name, t);
                    }
                    sToken = c.getString();
                    if (sToken.equals(")")) break block22;
                } while (sToken.equals(","));
                throw Trace.error(10, sToken);
            }
        }
        channel.commit();
        this.linkTable(t);
    }

    private Result processDrop(Tokenizer c, Channel channel) throws SQLException {
        channel.checkReadWrite();
        channel.checkAdmin();
        String sToken = c.getString();
        if (sToken.equals("TABLE")) {
            sToken = c.getString();
            if (sToken.equals("IF")) {
                sToken = c.getString();
                sToken = c.getString();
                this.dropTable(sToken, true);
            } else {
                this.dropTable(sToken, false);
            }
            channel.commit();
        } else if (sToken.equals("USER")) {
            this.aAccess.dropUser(c.getStringToken());
        } else if (sToken.equals("TRIGGER")) {
            this.dropTrigger(c.getString());
        } else if (sToken.equals("INDEX")) {
            sToken = c.getString();
            if (!c.wasLongName()) {
                throw Trace.error(10, sToken);
            }
            String table = c.getLongNameFirst();
            String index = c.getLongNameLast();
            Table t = this.getTable(table, channel);
            t.checkDropIndex(index);
            Table tn = t.moveDefinition(index);
            tn.moveData(t);
            this.dropTable(table);
            this.linkTable(tn);
            channel.commit();
        } else {
            throw Trace.error(10, sToken);
        }
        return new Result();
    }

    private Result processGrantOrRevoke(Tokenizer c, Channel channel, boolean grant) throws SQLException {
        String sToken;
        channel.checkReadWrite();
        channel.checkAdmin();
        int right = 0;
        do {
            String sRight = c.getString();
            right |= Access.getRight(sRight);
        } while ((sToken = c.getString()).equals(","));
        if (!sToken.equals("ON")) {
            throw Trace.error(10, sToken);
        }
        String table = c.getString();
        if (table.equals("CLASS")) {
            table = table + " \"" + c.getString() + "\"";
        } else {
            this.getTable(table, channel);
        }
        c.getThis("TO");
        String user = c.getStringToken();
        if (grant) {
            this.aAccess.grant(user, table, right);
            String command = "GRANT";
        } else {
            this.aAccess.revoke(user, table, right);
            String command = "REVOKE";
        }
        return new Result();
    }

    private Result processConnect(Tokenizer c, Channel channel) throws SQLException {
        c.getThis("USER");
        String username = c.getStringToken();
        c.getThis("PASSWORD");
        String password = c.getStringToken();
        User user = this.aAccess.getUser(username, password);
        channel.commit();
        channel.setUser(user);
        return new Result();
    }

    private Result processDisconnect(Tokenizer c, Channel channel) throws SQLException {
        if (!channel.isClosed()) {
            channel.disconnect();
            this.cChannel.setElementAt(null, channel.getId());
        }
        return new Result();
    }

    private Result processSet(Tokenizer c, Channel channel) throws SQLException {
        String sToken = c.getString();
        if (sToken.equals("PASSWORD")) {
            channel.checkReadWrite();
            channel.setPassword(c.getStringToken());
        } else if (sToken.equals("READONLY")) {
            channel.commit();
            channel.setReadOnly(this.processTrueOrFalse(c));
        } else if (sToken.equals("LOGSIZE")) {
            channel.checkAdmin();
            int i = Integer.parseInt(c.getString());
            if (this.lLog != null) {
                this.lLog.setLogSize(i);
            }
        } else if (sToken.equals("IGNORECASE")) {
            channel.checkAdmin();
            this.bIgnoreCase = this.processTrueOrFalse(c);
        } else if (sToken.equals("MAXROWS")) {
            int i = Integer.parseInt(c.getString());
            channel.setMaxRows(i);
        } else if (sToken.equals("AUTOCOMMIT")) {
            channel.setAutoCommit(this.processTrueOrFalse(c));
        } else if (sToken.equals("TABLE")) {
            channel.checkReadWrite();
            channel.checkAdmin();
            Table t = this.getTable(c.getString(), channel);
            c.getThis("INDEX");
            c.getString();
            t.setIndexRoots((String)c.getAsValue());
        } else if (sToken.equals("REFERENCIAL_INTEGRITY") || sToken.equals("REFERENTIAL_INTEGRITY")) {
            channel.checkAdmin();
            this.bReferentialIntegrity = this.processTrueOrFalse(c);
        } else if (sToken.equals("WRITE_DELAY")) {
            channel.checkAdmin();
            boolean delay = this.processTrueOrFalse(c);
            if (this.lLog != null) {
                this.lLog.setWriteDelay(delay);
            }
        } else {
            throw Trace.error(10, sToken);
        }
        return new Result();
    }

    private boolean processTrueOrFalse(Tokenizer c) throws SQLException {
        String sToken = c.getString();
        if (sToken.equals("TRUE")) {
            return true;
        }
        if (sToken.equals("FALSE")) {
            return false;
        }
        throw Trace.error(10, sToken);
    }

    private Result processCommit(Tokenizer c, Channel channel) throws SQLException {
        String sToken = c.getString();
        if (!sToken.equals("WORK")) {
            c.back();
        }
        channel.commit();
        return new Result();
    }

    private Result processRollback(Tokenizer c, Channel channel) throws SQLException {
        String sToken = c.getString();
        if (!sToken.equals("WORK")) {
            c.back();
        }
        channel.rollback();
        return new Result();
    }

    public void finalize() {
        try {
            this.close(0);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void close(int type) throws SQLException {
        if (this.lLog == null) {
            return;
        }
        this.lLog.stop();
        if (type == -1) {
            this.lLog.shutdown();
        } else if (type == 0) {
            this.lLog.close(false);
        } else if (type == 1) {
            this.lLog.close(true);
        }
        this.lLog = null;
        this.bShutdown = true;
    }

    private Result processShutdown(Tokenizer c, Channel channel) throws SQLException {
        channel.checkAdmin();
        int i = 1;
        while (i < this.cChannel.size()) {
            Channel d = (Channel)this.cChannel.elementAt(i);
            if (d != null) {
                d.disconnect();
            }
            ++i;
        }
        this.cChannel.removeAllElements();
        String token = c.getString();
        if (token.equals("IMMEDIATELY")) {
            this.close(-1);
        } else if (token.equals("COMPACT")) {
            this.close(1);
        } else {
            c.back();
            this.close(0);
        }
        this.processDisconnect(c, channel);
        return new Result();
    }

    private Result processCheckpoint(Channel channel) throws SQLException {
        channel.checkAdmin();
        if (this.lLog != null) {
            this.lLog.checkpoint();
        }
        return new Result();
    }

    private void dropTable(String name) throws SQLException {
        this.dropTable(name, false);
    }

    private void dropTable(String name, boolean bExists) throws SQLException {
        int i = 0;
        while (i < this.tTable.size()) {
            Table o = (Table)this.tTable.elementAt(i);
            if (o.getName().equals(name)) {
                this.tTable.removeElementAt(i);
                return;
            }
            ++i;
        }
        if (!bExists) {
            throw Trace.error(21, name);
        }
    }

    private void dropTrigger(String name) throws SQLException {
        int i = 0;
        while (i < this.tTable.size()) {
            Table t = (Table)this.tTable.elementAt(i);
            int numTrigs = TriggerDef.numTrigs();
            int tv = 0;
            while (tv < numTrigs) {
                Vector v = t.vTrigs[tv];
                int tr = 0;
                while (tr < v.size()) {
                    TriggerDef td = (TriggerDef)v.elementAt(tr);
                    if (td.name.equals(name)) {
                        v.removeElementAt(tr);
                        return;
                    }
                    ++tr;
                }
                ++tv;
            }
            ++i;
        }
        throw Trace.error(21, name);
    }
}

