/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.DriverManager;
import java.util.Hashtable;
import java.util.Properties;
import org.hsqldb.Database;
import org.hsqldb.Embedded_ServerConnection;

public class Embedded_Server {
    boolean mSilent;
    Database mDatabase;
    boolean bEmbedded = false;
    boolean bRun = true;
    ServerSocket serverSocket;
    int port;

    public static void main(String[] arg) {
        Embedded_Server server = new Embedded_Server();
        server.run(arg);
    }

    private void run(String[] arg) {
        try {
            Properties prop = new Properties();
            File f = new File("Server.properties");
            if (f.exists()) {
                FileInputStream fi = new FileInputStream(f);
                prop.load(fi);
                fi.close();
            }
            int i = 0;
            while (i < arg.length) {
                String p = arg[i];
                if (p.equals("-?")) {
                    this.printHelp();
                }
                if (p.charAt(0) == '-') {
                    ((Hashtable)prop).put(p.substring(1), arg[i + 1]);
                    ++i;
                }
                ++i;
            }
            this.port = 9001;
            this.port = Integer.parseInt(prop.getProperty("port", "" + this.port));
            String database = prop.getProperty("database", "test");
            this.mSilent = prop.getProperty("silent", "true").equalsIgnoreCase("true");
            if (prop.getProperty("trace", "false").equalsIgnoreCase("true")) {
                DriverManager.setLogStream(System.out);
            }
            this.serverSocket = new ServerSocket(this.port);
            this.trace("port    =" + this.port);
            this.trace("database=" + database);
            this.trace("silent  =" + this.mSilent);
            this.mDatabase = new Database(database);
            this.setEmbedded(true);
            System.out.println("Server 1.6 is running");
            System.out.println("Press [Ctrl]+[C] to abort");
        }
        catch (Exception e) {
            this.traceError("Server.run/init: " + e);
            e.printStackTrace();
            return;
        }
        try {
            while (this.bRun) {
                Socket s = this.serverSocket.accept();
                Embedded_ServerConnection c = new Embedded_ServerConnection(s, this);
                Thread thread = new Thread(c);
                thread.start();
                if (this.bRun) continue;
                this.closeServerSocket();
                System.out.println("Calling hsqldb closeServerSocket();");
            }
        }
        catch (IOException e) {
            this.traceError("Server.run/loop: " + e.getMessage());
            e.printStackTrace();
        }
    }

    void printHelp() {
        System.out.println("Usage: java Server [-options]\nwhere options include:\n    -port <nr>            port where the server is listening\n    -database <name>      name of the database\n    -silent <true/false>  false means display all queries\n    -trace <true/false>   display print JDBC trace messages\nThe command line arguments override the values in the properties file.");
        System.exit(0);
    }

    void trace(String s) {
        if (!this.mSilent) {
            System.out.println(s);
        }
    }

    void traceError(String s) {
        System.out.println(s);
    }

    public void setEmbedded(boolean b) {
        this.bEmbedded = b;
    }

    public boolean getEmbedded() {
        return this.bEmbedded;
    }

    public synchronized void setRun(boolean b) {
        this.bRun = b;
    }

    public synchronized void closeServerSocket() {
        try {
            if (this.serverSocket != null) {
                this.setRun(false);
                ServerSocket ss = this.serverSocket;
                this.serverSocket = null;
                new Socket(InetAddress.getLocalHost(), this.port);
                ss.close();
                System.out.println("hsqldb serverSocket closed");
            }
        }
        catch (Exception e) {
            System.out.println("Exception in hsqldb serverSocket");
        }
    }
}

