/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.sql.SQLException;
import org.hsqldb.Trace;

class StringConverter {
    private static final char[] HEXCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String HEXINDEX = "0123456789abcdef          ABCDEF";

    StringConverter() {
    }

    public static byte[] hexToByte(String s) {
        int l = s.length() / 2;
        byte[] data = new byte[l];
        int j = 0;
        int i = 0;
        while (i < l) {
            char c = s.charAt(j++);
            int n = HEXINDEX.indexOf(c);
            int b = (n & 0xF) << 4;
            c = s.charAt(j++);
            n = HEXINDEX.indexOf(c);
            data[i] = (byte)(b += n & 0xF);
            ++i;
        }
        return data;
    }

    static String byteToHex(byte[] b) {
        int len = b.length;
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < len) {
            int c = b[i] & 0xFF;
            s.append(HEXCHAR[c >> 4 & 0xF]);
            s.append(HEXCHAR[c & 0xF]);
            ++i;
        }
        return s.toString();
    }

    static String unicodeToHexString(String s) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        try {
            out.writeUTF(s);
            out.close();
            bout.close();
        }
        catch (IOException e) {
            return null;
        }
        return StringConverter.byteToHex(bout.toByteArray());
    }

    public static String hexStringToUnicode(String s) {
        byte[] b = StringConverter.hexToByte(s);
        ByteArrayInputStream bin = new ByteArrayInputStream(b);
        DataInputStream in = new DataInputStream(bin);
        try {
            return in.readUTF();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String unicodeToAscii(String s) {
        if (s == null || s.equals("")) {
            return s;
        }
        int len = s.length();
        StringBuffer b = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '\\') {
                if (i < len - 1 && s.charAt(i + 1) == 'u') {
                    b.append(c);
                    b.append("u005c");
                } else {
                    b.append(c);
                }
            } else if (c >= ' ' && c <= '\u007f') {
                b.append(c);
            } else {
                b.append("\\u");
                b.append(HEXCHAR[c >> 12 & 0xF]);
                b.append(HEXCHAR[c >> 8 & 0xF]);
                b.append(HEXCHAR[c >> 4 & 0xF]);
                b.append(HEXCHAR[c & 0xF]);
            }
            ++i;
        }
        return b.toString();
    }

    public static String asciiToUnicode(String s) {
        if (s == null || s.indexOf("\\u") == -1) {
            return s;
        }
        int len = s.length();
        char[] b = new char[len];
        int j = 0;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c != '\\' || i == len - 1) {
                b[j++] = c;
            } else if ((c = s.charAt(++i)) != 'u' || i == len - 1) {
                b[j++] = 92;
                b[j++] = c;
            } else {
                int k = (HEXINDEX.indexOf(s.charAt(++i)) & 0xF) << 12;
                k += (HEXINDEX.indexOf(s.charAt(++i)) & 0xF) << 8;
                k += (HEXINDEX.indexOf(s.charAt(++i)) & 0xF) << 4;
                b[j++] = (char)(k += HEXINDEX.indexOf(s.charAt(++i)) & 0xF);
            }
            ++i;
        }
        return new String(b, 0, j);
    }

    public static String InputStreamToString(InputStream x) throws SQLException {
        InputStreamReader in = new InputStreamReader(x);
        StringWriter write = new StringWriter();
        int blocksize = 8192;
        char[] buffer = new char[blocksize];
        try {
            int l;
            while ((l = in.read(buffer, 0, blocksize)) != -1) {
                write.write(buffer, 0, l);
            }
            write.close();
            x.close();
        }
        catch (IOException e) {
            throw Trace.error(32, e.getMessage());
        }
        return write.toString();
    }
}

