/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Hashtable;
import org.hsqldb.Trace;

class Tokenizer {
    private static final int NAME = 1;
    private static final int LONG_NAME = 2;
    private static final int SPECIAL = 3;
    private static final int NUMBER = 4;
    private static final int FLOAT = 5;
    private static final int STRING = 6;
    private static final int LONG = 7;
    private static final int QUOTED_IDENTIFIER = 9;
    private static final int REMARK_LINE = 10;
    private static final int REMARK = 11;
    private String sCommand;
    private char[] cCommand;
    private int iLength;
    private Object oValue;
    private int iIndex;
    private int iType;
    private String sToken;
    private String sLongNameFirst;
    private String sLongNameLast;
    private boolean bWait;
    private static Hashtable hKeyword = new Hashtable();

    Tokenizer(String s) {
        this.sCommand = s;
        this.cCommand = s.toCharArray();
        this.iLength = this.cCommand.length;
        this.iIndex = 0;
    }

    void back() throws SQLException {
        Trace.assert(!this.bWait, "back");
        this.bWait = true;
    }

    void getThis(String match) throws SQLException {
        this.getToken();
        if (!this.sToken.equals(match)) {
            throw Trace.error(10, this.sToken);
        }
    }

    String getStringToken() throws SQLException {
        this.getToken();
        if (this.iType == 6) {
            return this.sToken.substring(1).toUpperCase();
        }
        if (this.iType == 1) {
            return this.sToken;
        }
        if (this.iType == 9) {
            return this.sToken.toUpperCase();
        }
        throw Trace.error(10, this.sToken);
    }

    boolean wasValue() {
        if (this.iType == 6 || this.iType == 4 || this.iType == 5) {
            return true;
        }
        if (this.sToken.equals("NULL")) {
            return true;
        }
        return this.sToken.equals("TRUE") || this.sToken.equals("FALSE");
    }

    boolean wasLongName() {
        return this.iType == 2;
    }

    boolean wasName() {
        if (this.iType == 9) {
            return true;
        }
        if (this.iType != 1) {
            return false;
        }
        return !hKeyword.containsKey(this.sToken);
    }

    String getLongNameFirst() {
        return this.sLongNameFirst;
    }

    String getLongNameLast() {
        return this.sLongNameLast;
    }

    String getName() throws SQLException {
        this.getToken();
        if (!this.wasName()) {
            throw Trace.error(10, this.sToken);
        }
        return this.sToken;
    }

    String getString() throws SQLException {
        this.getToken();
        return this.sToken;
    }

    int getType() {
        switch (this.iType) {
            case 6: {
                return 12;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 8;
            }
            case 7: {
                return -5;
            }
        }
        return 0;
    }

    Object getAsValue() throws SQLException {
        if (!this.wasValue()) {
            throw Trace.error(10, this.sToken);
        }
        if (this.iType == 6) {
            return this.sToken.substring(1);
        }
        if (this.sToken.equals("NULL")) {
            return null;
        }
        if (this.iType == 4) {
            if (this.sToken.length() > 9) {
                this.iType = 7;
                return new Long(this.sToken);
            }
            return new Integer(this.sToken);
        }
        if (this.iType == 5) {
            return new Double(this.sToken);
        }
        return this.sToken;
    }

    int getPosition() {
        return this.iIndex;
    }

    String getPart(int begin, int end) {
        return this.sCommand.substring(begin, end);
    }

    /*
     * Unable to fully structure code
     */
    private void getToken() throws SQLException {
        if (!this.bWait) ** GOTO lbl5
        this.bWait = false;
        return;
lbl-1000:
        // 1 sources

        {
            ++this.iIndex;
lbl5:
            // 2 sources

            ** while (this.iIndex < this.iLength && Character.isWhitespace((char)this.cCommand[this.iIndex]))
        }
lbl6:
        // 1 sources

        this.sToken = "";
        if (this.iIndex >= this.iLength) {
            this.iType = 0;
            return;
        }
        point = false;
        digit = false;
        exp = false;
        afterexp = false;
        end = false;
        c = this.cCommand[this.iIndex];
        cfirst = '\u0000';
        name = new StringBuffer();
        if (Character.isJavaIdentifierStart(c)) {
            this.iType = 1;
        } else {
            if ("(),*=;+%".indexOf(c) >= 0) {
                this.iType = 3;
                ++this.iIndex;
                this.sToken = "" + c;
                return;
            }
            if (Character.isDigit(c)) {
                this.iType = 4;
                digit = true;
            } else if ("!<>|/-".indexOf(c) >= 0) {
                cfirst = c;
                this.iType = 3;
            } else if (c == '\"') {
                this.iType = 9;
            } else if (c == '\'') {
                this.iType = 6;
                name.append('\'');
            } else if (c == '.') {
                this.iType = 5;
                point = true;
            } else {
                throw Trace.error(10, "" + c);
            }
        }
        start = this.iIndex++;
        while (true) {
            if (this.iIndex >= this.iLength) {
                c = ' ';
                end = true;
                Trace.check(this.iType != 6 && this.iType != 9, 11);
            } else {
                c = this.cCommand[this.iIndex];
            }
            switch (this.iType) {
                case 1: {
                    if (Character.isJavaIdentifierPart(c)) break;
                    this.sToken = this.sCommand.substring(start, this.iIndex).toUpperCase();
                    if (c == '.') {
                        this.sLongNameFirst = this.sToken;
                        ++this.iIndex;
                        this.getToken();
                        this.sLongNameLast = this.sToken;
                        this.iType = 2;
                        this.sToken = this.sLongNameFirst + "." + this.sLongNameLast;
                    }
                    return;
                }
                case 9: {
                    if (c == '\"') {
                        ++this.iIndex;
                        if (this.iIndex >= this.iLength) {
                            this.sToken = name.toString();
                            return;
                        }
                        c = this.cCommand[this.iIndex];
                        if (c == '.') {
                            this.sLongNameFirst = name.toString();
                            ++this.iIndex;
                            this.getToken();
                            this.sLongNameLast = this.sToken;
                            this.iType = 2;
                            this.sToken = this.sLongNameFirst + "." + this.sLongNameLast;
                            return;
                        }
                        if (c != '\"') {
                            this.sToken = name.toString();
                            return;
                        }
                    }
                    name.append(c);
                    break;
                }
                case 6: {
                    if (c == '\'') {
                        ++this.iIndex;
                        if (this.iIndex >= this.iLength || this.cCommand[this.iIndex] != '\'') {
                            this.sToken = name.toString();
                            return;
                        }
                    }
                    name.append(c);
                    break;
                }
                case 11: {
                    if (end) {
                        this.iType = 0;
                        return;
                    }
                    if (c != 42) break;
                    ++this.iIndex;
                    if (this.iIndex >= this.iLength || this.cCommand[this.iIndex] != '/') break;
                    ++this.iIndex;
                    this.getToken();
                    return;
                }
                case 10: {
                    if (end) {
                        this.iType = 0;
                        return;
                    }
                    if (c != '\r' && c != 10) break;
                    this.getToken();
                    return;
                }
                case 3: {
                    if (c == '/' && cfirst == '/') {
                        this.iType = 10;
                        break;
                    }
                    if (c == '-' && cfirst == '-') {
                        this.iType = 10;
                        break;
                    }
                    if (c == '*' && cfirst == '/') {
                        this.iType = 11;
                        break;
                    }
                    if (">=|".indexOf(c) >= 0) break;
                    this.sToken = this.sCommand.substring(start, this.iIndex);
                    return;
                }
                case 4: 
                case 5: {
                    if (Character.isDigit(c)) {
                        digit = true;
                        break;
                    }
                    if (c == '.') {
                        this.iType = 5;
                        if (point) {
                            throw Trace.error(10, ".");
                        }
                        point = true;
                        break;
                    }
                    if (c == 'E' || c == 'e') {
                        if (exp) {
                            throw Trace.error(10, "E");
                        }
                        afterexp = true;
                        point = true;
                        exp = true;
                        break;
                    }
                    if (c == '-' && afterexp) {
                        afterexp = false;
                        break;
                    }
                    if (c == '+' && afterexp) {
                        afterexp = false;
                        break;
                    }
                    afterexp = false;
                    if (!digit) {
                        if (point && start == this.iIndex - 1) {
                            this.sToken = ".";
                            this.iType = 3;
                            return;
                        }
                        throw Trace.error(10, "" + c);
                    }
                    this.sToken = this.sCommand.substring(start, this.iIndex);
                    return;
                }
            }
            ++this.iIndex;
        }
    }

    static {
        String[] keyword = new String[]{"AND", "ALL", "AVG", "BY", "BETWEEN", "COUNT", "CASEWHEN", "DISTINCT", "DISTINCT", "EXISTS", "EXCEPT", "FALSE", "FROM", "GROUP", "IF", "INTO", "IFNULL", "IS", "IN", "INTERSECT", "INNER", "LEFT", "LIKE", "MAX", "MIN", "NULL", "NOT", "ON", "ORDER", "OR", "OUTER", "PRIMARY", "SELECT", "SET", "SUM", "TO", "TRUE", "UNIQUE", "UNION", "VALUES", "WHERE", "CONVERT", "CAST", "CONCAT", "MINUS", "CALL"};
        int i = 0;
        while (i < keyword.length) {
            hKeyword.put(keyword[i], hKeyword);
            ++i;
        }
    }
}

