/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import EDU.oswego.cs.dl.util.concurrent.FIFOReadWriteLock;
import org.jboss.ejb.Container;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ha.framework.interfaces.GenericClusteringException;
import org.jboss.invocation.Invocation;

public class CleanShutdownInterceptor
extends AbstractInterceptor {
    protected Container container = null;
    protected boolean allowInvocations = false;
    public long runningInvocations = 0L;
    public long runningHomeInvocations = 0L;
    protected FIFOReadWriteLock rwLock = new FIFOReadWriteLock();

    public void create() throws Exception {
        super.create();
        this.allowInvocations = false;
    }

    public void start() throws Exception {
        super.start();
        this.allowInvocations = true;
    }

    public void stop() {
        super.stop();
        this.log.debug((Object)("Stopping container " + this.container.getJmxName().toString() + ". " + this.runningHomeInvocations + " current home invocations and " + this.runningInvocations + " current remote invocations."));
        this.forbidInvocations();
    }

    public void destroy() {
        super.destroy();
        this.log.debug((Object)("Destroying container " + this.container.getJmxName().toString() + ". " + this.runningHomeInvocations + " current home invocations and " + this.runningInvocations + " current remote invocations."));
        this.forbidInvocations();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invokeHome(Invocation mi) throws Exception {
        Object ie2;
        if (!this.allowInvocations) {
            throw new GenericClusteringException(GenericClusteringException.COMPLETED_NO, "Container is shuting down on this node");
        }
        try {
            this.rwLock.readLock().attempt(0L);
        }
        catch (InterruptedException ie2) {
            throw new GenericClusteringException(GenericClusteringException.COMPLETED_NO, "Container is shuting down on this node");
        }
        ++this.runningHomeInvocations;
        try {
            try {
                ie2 = this.getNext().invokeHome(mi);
                Object var4_5 = null;
                --this.runningHomeInvocations;
            }
            catch (GenericClusteringException gce) {
                gce.setCompletionStatus(GenericClusteringException.COMPLETED_MAYBE);
                throw gce;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            --this.runningHomeInvocations;
            this.rwLock.readLock().release();
            throw throwable;
        }
        this.rwLock.readLock().release();
        return ie2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Invocation mi) throws Exception {
        Object ie2;
        if (!this.allowInvocations) {
            throw new GenericClusteringException(GenericClusteringException.COMPLETED_NO, "Container is shuting down on this node");
        }
        try {
            this.rwLock.readLock().attempt(0L);
        }
        catch (InterruptedException ie2) {
            throw new GenericClusteringException(GenericClusteringException.COMPLETED_NO, "Container is shuting down on this node");
        }
        ++this.runningInvocations;
        try {
            try {
                ie2 = this.getNext().invoke(mi);
                Object var4_5 = null;
                --this.runningInvocations;
            }
            catch (GenericClusteringException gce) {
                gce.setCompletionStatus(GenericClusteringException.COMPLETED_MAYBE);
                throw gce;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            --this.runningInvocations;
            this.rwLock.readLock().release();
            throw throwable;
        }
        this.rwLock.readLock().release();
        return ie2;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container con) {
        this.container = this.container;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void forbidInvocations() {
        this.allowInvocations = false;
        try {
            try {
                this.rwLock.writeLock().acquire();
            }
            catch (Exception e) {
                Object var3_2 = null;
                this.rwLock.writeLock().release();
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.rwLock.writeLock().release();
            throw throwable;
        }
        this.rwLock.writeLock().release();
    }
}

