/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.jboss.logging.XPriority;

public class Logger
implements Serializable {
    private final String name;
    private transient Category log;

    protected Logger(String name) {
        this.name = name;
        this.log = Category.getInstance((String)name);
    }

    public Category getCategory() {
        return this.log;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTraceEnabled() {
        if (!this.log.isEnabledFor((Priority)XPriority.TRACE)) {
            return false;
        }
        return XPriority.TRACE.isGreaterOrEqual(this.log.getChainedPriority());
    }

    public void trace(Object message) {
        this.log.log((Priority)XPriority.TRACE, message);
    }

    public void trace(Object message, Throwable t) {
        this.log.log((Priority)XPriority.TRACE, message, t);
    }

    public boolean isDebugEnabled() {
        Priority p = Priority.DEBUG;
        if (!this.log.isEnabledFor(p)) {
            return false;
        }
        return p.isGreaterOrEqual(this.log.getChainedPriority());
    }

    public void debug(Object message) {
        this.log.log(Priority.DEBUG, message);
    }

    public void debug(Object message, Throwable t) {
        this.log.log(Priority.DEBUG, message, t);
    }

    public boolean isInfoEnabled() {
        Priority p = Priority.INFO;
        if (!this.log.isEnabledFor(p)) {
            return false;
        }
        return p.isGreaterOrEqual(this.log.getChainedPriority());
    }

    public void info(Object message) {
        this.log.log(Priority.INFO, message);
    }

    public void info(Object message, Throwable t) {
        this.log.log(Priority.INFO, message, t);
    }

    public void warn(Object message) {
        this.log.log(Priority.WARN, message);
    }

    public void warn(Object message, Throwable t) {
        this.log.log(Priority.WARN, message, t);
    }

    public void error(Object message) {
        this.log.log(Priority.ERROR, message);
    }

    public void error(Object message, Throwable t) {
        this.log.log(Priority.ERROR, message, t);
    }

    public void fatal(Object message) {
        this.log.log(Priority.FATAL, message);
    }

    public void fatal(Object message, Throwable t) {
        this.log.log(Priority.FATAL, message, t);
    }

    public void log(Priority p, Object message) {
        this.log.log(p, message);
    }

    public void log(Priority p, Object message, Throwable t) {
        this.log.log(p, message, t);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.log = Category.getInstance((String)this.name);
    }

    public static Logger getLogger(String name) {
        Logger logger = new Logger(name);
        return logger;
    }

    public static Logger getLogger(String name, String suffix) {
        return new Logger(name + "." + suffix);
    }

    public static Logger getLogger(Class clazz) {
        Logger logger = new Logger(clazz.getName());
        return logger;
    }

    public static Logger getLogger(Class clazz, String suffix) {
        return new Logger(clazz.getName() + "." + suffix);
    }
}

