/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.parser.ParserUtils;
import org.apache.jasper.parser.TreeNode;

public class TldLocationsCache {
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private Hashtable mappings = new Hashtable();

    public TldLocationsCache(ServletContext ctxt) {
        try {
            this.processWebDotXml(ctxt);
            this.processJars(ctxt);
        }
        catch (JasperException ex) {
            Constants.message("jsp.error.internal.tldinit", new Object[]{ex.getMessage()}, 1);
        }
    }

    private void processWebDotXml(ServletContext ctxt) throws JasperException {
        InputStream is = ctxt.getResourceAsStream(WEB_XML);
        if (is == null) {
            Constants.message("jsp.error.internal.filenotfound", new Object[]{WEB_XML}, 2);
            return;
        }
        ClassLoader cl = this.getClass().getClassLoader();
        ParserUtils pu = ParserUtils.createParserUtils(cl);
        TreeNode webtld = pu.parseXMLDocument(WEB_XML, is);
        Iterator taglibs = webtld.findChildren("taglib");
        while (taglibs.hasNext()) {
            TreeNode taglib = (TreeNode)taglibs.next();
            String tagUri = null;
            String tagLoc = null;
            TreeNode child = taglib.findChild("taglib-uri");
            if (child != null) {
                tagUri = child.getBody();
            }
            if ((child = taglib.findChild("taglib-location")) != null) {
                tagLoc = child.getBody();
            }
            if (tagLoc == null) continue;
            if (TldLocationsCache.uriType(tagLoc) == 2) {
                tagLoc = "/WEB-INF/" + tagLoc;
            }
            String tagLoc2 = null;
            if (tagLoc.endsWith(".jar")) {
                tagLoc2 = "META-INF/taglib.tld";
            }
            this.mappings.put(tagUri, new String[]{tagLoc, tagLoc2});
        }
    }

    private void processJars(ServletContext ctxt) throws JasperException {
        Set libSet = ctxt.getResourcePaths("/WEB-INF/lib");
        Iterator it = libSet.iterator();
        while (it.hasNext()) {
            String resourcePath = (String)it.next();
            if (!resourcePath.endsWith(".jar")) continue;
            this.tldConfigJar(ctxt, resourcePath);
        }
    }

    private void tldConfigJar(ServletContext ctxt, String resourcePath) throws JasperException {
        block9: {
            ZipFile jarFile = null;
            InputStream stream = null;
            try {
                URL url = ctxt.getResource(resourcePath);
                if (url == null) {
                    return;
                }
                url = new URL("jar:" + url.toString() + "!/");
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                jarFile = conn.getJarFile();
                Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
                while (entries.hasMoreElements()) {
                    String uri;
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith("META-INF/") || !name.endsWith(".tld") || (uri = this.parseTldForUri(resourcePath, stream = ((JarFile)jarFile).getInputStream(entry))) == null) continue;
                    this.mappings.put(uri, new String[]{resourcePath, name});
                }
            }
            catch (Exception ex) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (jarFile == null) break block9;
                try {
                    jarFile.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    }

    private String parseTldForUri(String resourcePath, InputStream in) throws JasperException {
        String body;
        ParserUtils pu = new ParserUtils();
        TreeNode tld = pu.parseXMLDocument(resourcePath, in);
        TreeNode uri = tld.findChild("uri");
        if (uri != null && (body = uri.getBody()) != null) {
            return body;
        }
        return null;
    }

    public String[] getLocation(String uri) throws JasperException {
        return (String[])this.mappings.get(uri);
    }

    public static int uriType(String uri) {
        if (uri.indexOf(58) != -1) {
            return 0;
        }
        if (uri.startsWith("/")) {
            return 1;
        }
        return 2;
    }

    private void p(String s) {
        System.out.println("[TldLocationsCache] " + s);
    }
}

