/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.util;

import com.ibm.wsdl.util.IOUtils;
import java.beans.Introspector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtils {
    public static final String lineSeparator = System.getProperty("line.separator", "\n");
    public static final String lineSeparatorStr = StringUtils.cleanString(lineSeparator);

    public static String classNameToVarName(String className) {
        int arrayDim = 0;
        while (className.endsWith("[]")) {
            className = className.substring(0, className.length() - 2);
            ++arrayDim;
        }
        int iLastPeriod = className.lastIndexOf(46);
        String varName = Introspector.decapitalize(iLastPeriod != -1 ? className.substring(iLastPeriod + 1) : className);
        if (arrayDim > 0) {
            varName = String.valueOf(varName) + "_" + arrayDim + "D";
        }
        return StringUtils.getValidIdentifierName(varName);
    }

    public static String cleanString(String str) {
        if (str == null) {
            return null;
        }
        char[] charArray = str.toCharArray();
        StringBuffer sBuf = new StringBuffer();
        int i = 0;
        while (i < charArray.length) {
            switch (charArray[i]) {
                case '\"': {
                    sBuf.append("\\\"");
                    break;
                }
                case '\\': {
                    sBuf.append("\\\\");
                    break;
                }
                case '\n': {
                    sBuf.append("\\n");
                    break;
                }
                case '\r': {
                    sBuf.append("\\r");
                    break;
                }
                default: {
                    sBuf.append(charArray[i]);
                    break;
                }
            }
            ++i;
        }
        return sBuf.toString();
    }

    public static String getChars(int numberOfChars, char theChar) {
        if (numberOfChars <= 0) {
            return "";
        }
        StringBuffer sRet = new StringBuffer(numberOfChars);
        int i = 0;
        while (i < numberOfChars) {
            sRet.append(theChar);
            ++i;
        }
        return sRet.toString();
    }

    public static String getClassName(Class targetClass) {
        String className = targetClass.getName();
        return targetClass.isArray() ? StringUtils.parseDescriptor(className) : className;
    }

    public static String getCommaListFromVector(Vector sourceVector) {
        StringBuffer strBuf = new StringBuffer();
        int i = 0;
        while (i < sourceVector.size()) {
            strBuf.append(String.valueOf(i > 0 ? ", " : "") + sourceVector.elementAt(i));
            ++i;
        }
        return strBuf.toString();
    }

    public static Reader getContentAsReader(URL url) throws SecurityException, IllegalArgumentException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL cannot be null.");
        }
        try {
            Object content = url.getContent();
            if (content == null) {
                throw new IllegalArgumentException("No content.");
            }
            if (content instanceof InputStream) {
                InputStreamReader in = null;
                in = url.getProtocol().equals("file") ? new InputStreamReader((InputStream)content) : new InputStreamReader((InputStream)content, "ISO-8859-1");
                return in;
            }
            throw new IllegalArgumentException(content instanceof String ? (String)content : "This URL points to a: " + StringUtils.getClassName(content.getClass()));
        }
        catch (SecurityException securityException) {
            throw new SecurityException("Your JVM's SecurityManager has disallowed this.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("This file was not found: " + url);
        }
    }

    public static String getContentAsString(URL url) throws SecurityException, IllegalArgumentException, IOException {
        return IOUtils.getStringFromReader(StringUtils.getContentAsReader(url));
    }

    public static String getNMTokens(List list) {
        if (list != null) {
            StringBuffer strBuf = new StringBuffer();
            int size = list.size();
            int i = 0;
            while (i < size) {
                String token = (String)list.get(i);
                strBuf.append(String.valueOf(i > 0 ? " " : "") + token);
                ++i;
            }
            return strBuf.toString();
        }
        return null;
    }

    public static String getSafeString(String scriptStr) {
        BufferedReader in = new BufferedReader(new StringReader(scriptStr));
        StringBuffer strBuf = new StringBuffer();
        String previousLine = null;
        try {
            String tempLine;
            while ((tempLine = in.readLine()) != null) {
                if (previousLine != null) {
                    strBuf.append("\"" + previousLine + lineSeparatorStr + "\" +" + lineSeparator);
                }
                previousLine = StringUtils.cleanString(tempLine);
            }
        }
        catch (IOException iOException) {}
        strBuf.append("\"" + (previousLine != null ? previousLine : "") + "\"" + lineSeparator);
        return strBuf.toString();
    }

    public static URL getURL(URL contextURL, String spec) throws MalformedURLException {
        return StringUtils.getURL(contextURL, spec, 1);
    }

    private static URL getURL(URL contextURL, String spec, int recursiveDepth) throws MalformedURLException {
        URL url = null;
        try {
            url = new URL(contextURL, spec);
            try {
                url.openStream();
            }
            catch (IOException iOException) {
                throw new MalformedURLException("This file was not found: " + url);
            }
        }
        catch (MalformedURLException malformedURLException) {
            url = new URL("file", "", spec);
            try {
                url.openStream();
            }
            catch (IOException iOException) {
                String contextFileName;
                String parentName;
                if (contextURL != null && (parentName = new File(contextFileName = contextURL.getFile()).getParent()) != null && recursiveDepth < 3) {
                    return StringUtils.getURL(new URL("file", "", String.valueOf(parentName) + '/'), spec, recursiveDepth + 1);
                }
                throw new MalformedURLException("This file was not found: " + url);
            }
        }
        return url;
    }

    public static String getValidIdentifierName(String identifierName) {
        if (identifierName == null || identifierName.length() == 0) {
            return null;
        }
        StringBuffer strBuf = new StringBuffer();
        char[] chars = identifierName.toCharArray();
        strBuf.append(Character.isJavaIdentifierStart(chars[0]) ? chars[0] : (char)'_');
        int i = 1;
        while (i < chars.length) {
            strBuf.append(Character.isJavaIdentifierPart(chars[i]) ? chars[i] : (char)'_');
            ++i;
        }
        return strBuf.toString();
    }

    public static boolean isValidIdentifierName(String identifierName) {
        if (identifierName == null || identifierName.length() == 0) {
            return false;
        }
        char[] chars = identifierName.toCharArray();
        if (!Character.isJavaIdentifierStart(chars[0])) {
            return false;
        }
        int i = 1;
        while (i < chars.length) {
            if (!Character.isJavaIdentifierPart(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isValidPackageName(String packageName) {
        if (packageName == null) {
            return false;
        }
        if (packageName.length() == 0) {
            return true;
        }
        strTok = new StringTokenizer(packageName, ".", true);
        if (strTok.countTokens() % 2 != 1) {
            return false;
        }
        if (StringUtils.isValidIdentifierName(strTok.nextToken())) ** GOTO lbl16
        return false;
lbl-1000:
        // 1 sources

        {
            if (!strTok.nextToken().equals(".")) {
                return false;
            }
            if (strTok.hasMoreTokens()) {
                if (StringUtils.isValidIdentifierName(strTok.nextToken())) continue;
                return false;
            }
            return false;
lbl16:
            // 2 sources

            ** while (strTok.hasMoreTokens())
        }
lbl17:
        // 1 sources

        return true;
    }

    private static String parseDescriptor(String className) {
        char[] classNameChars = className.toCharArray();
        int arrayDim = 0;
        int i = 0;
        while (classNameChars[i] == '[') {
            ++arrayDim;
            ++i;
        }
        StringBuffer classNameBuf = new StringBuffer();
        switch (classNameChars[i++]) {
            case 'B': {
                classNameBuf.append("byte");
                break;
            }
            case 'C': {
                classNameBuf.append("char");
                break;
            }
            case 'D': {
                classNameBuf.append("double");
                break;
            }
            case 'F': {
                classNameBuf.append("float");
                break;
            }
            case 'I': {
                classNameBuf.append("int");
                break;
            }
            case 'J': {
                classNameBuf.append("long");
                break;
            }
            case 'S': {
                classNameBuf.append("short");
                break;
            }
            case 'Z': {
                classNameBuf.append("boolean");
                break;
            }
            case 'L': {
                classNameBuf.append(classNameChars, i, classNameChars.length - i - 1);
                break;
            }
        }
        i = 0;
        while (i < arrayDim) {
            classNameBuf.append("[]");
            ++i;
        }
        return classNameBuf.toString();
    }

    public static List parseNMTokens(String nmTokens) {
        StringTokenizer strTok = new StringTokenizer(nmTokens, " ");
        Vector<String> tokens = new Vector<String>();
        while (strTok.hasMoreTokens()) {
            tokens.add(strTok.nextToken());
        }
        return tokens;
    }
}

