/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.xml;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import com.ibm.wsdl.util.xml.XPathUtils;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.QName;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.InputSource;

public class WSDLReaderImpl
implements WSDLReader {
    private static final List STYLE_ONE_WAY = Arrays.asList("input");
    private static final List STYLE_REQUEST_RESPONSE = Arrays.asList("input", "output");
    private static final List STYLE_SOLICIT_RESPONSE = Arrays.asList("output", "input");
    private static final List STYLE_NOTIFICATION = Arrays.asList("output");
    private boolean verbose = true;
    private boolean importDocuments = true;
    private ExtensionRegistry extReg = null;
    private String factoryImplName = null;
    static /* synthetic */ Class class$javax$wsdl$Definition;
    static /* synthetic */ Class class$javax$wsdl$Types;
    static /* synthetic */ Class class$javax$wsdl$Binding;
    static /* synthetic */ Class class$javax$wsdl$BindingOperation;
    static /* synthetic */ Class class$javax$wsdl$BindingInput;
    static /* synthetic */ Class class$javax$wsdl$BindingOutput;
    static /* synthetic */ Class class$javax$wsdl$BindingFault;
    static /* synthetic */ Class class$javax$wsdl$Service;
    static /* synthetic */ Class class$javax$wsdl$Port;

    private static void checkElementName(Element el, QName qname) throws WSDLException {
        if (!qname.matches(el)) {
            WSDLException wsdlExc = new WSDLException("INVALID_WSDL", "Expected element '" + qname + "'.");
            wsdlExc.setLocation(XPathUtils.getXPathExprFromNode(el));
            throw wsdlExc;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private static Document getDocument(InputSource inputSource, String desc) throws WSDLException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(inputSource);
            return doc;
        }
        catch (Throwable t) {
            throw new WSDLException("PARSER_ERROR", "Problem parsing '" + desc + "'.", t);
        }
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.extReg;
    }

    public String getFactoryImplName() {
        return this.factoryImplName;
    }

    public boolean getFeature(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Feature name must not be null.");
        }
        if (name.equals("javax.wsdl.verbose")) {
            return this.verbose;
        }
        if (name.equals("javax.wsdl.importDocuments")) {
            return this.importDocuments;
        }
        throw new IllegalArgumentException("Feature name '" + name + "' not recognized.");
    }

    private static Binding parseBinding(Element bindingEl, Definition def) throws WSDLException {
        Binding binding = null;
        String name = DOMUtils.getAttribute(bindingEl, "name");
        QName portTypeName = DOMUtils.getQualifiedAttributeValue(bindingEl, "type", "binding", false);
        PortType portType = null;
        if (name != null) {
            QName bindingName = new QName(def.getTargetNamespace(), name);
            binding = def.getBinding(bindingName);
            if (binding == null) {
                binding = def.createBinding();
                binding.setQName(bindingName);
            }
        } else {
            binding = def.createBinding();
        }
        binding.setUndefined(false);
        if (portTypeName != null) {
            portType = def.getPortType(portTypeName);
            if (portType == null) {
                portType = def.createPortType();
                portType.setQName(portTypeName);
                def.addPortType(portType);
            }
            binding.setPortType(portType);
        }
        Element tempEl = DOMUtils.getFirstChildElement(bindingEl);
        while (tempEl != null) {
            if (Constants.Q_ELEM_DOCUMENTATION.matches(tempEl)) {
                binding.setDocumentationElement(tempEl);
            } else if (Constants.Q_ELEM_OPERATION.matches(tempEl)) {
                binding.addBindingOperation(WSDLReaderImpl.parseBindingOperation(tempEl, portType, def));
            } else {
                binding.addExtensibilityElement(WSDLReaderImpl.parseExtensibilityElement(class$javax$wsdl$Binding != null ? class$javax$wsdl$Binding : WSDLReaderImpl.class$("javax.wsdl.Binding"), tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        return binding;
    }

    private static BindingFault parseBindingFault(Element bindingFaultEl, Definition def) throws WSDLException {
        BindingFault bindingFault = def.createBindingFault();
        String name = DOMUtils.getAttribute(bindingFaultEl, "name");
        if (name != null) {
            bindingFault.setName(name);
        }
        Element tempEl = DOMUtils.getFirstChildElement(bindingFaultEl);
        while (tempEl != null) {
            if (Constants.Q_ELEM_DOCUMENTATION.matches(tempEl)) {
                bindingFault.setDocumentationElement(tempEl);
            } else {
                bindingFault.addExtensibilityElement(WSDLReaderImpl.parseExtensibilityElement(class$javax$wsdl$BindingFault != null ? class$javax$wsdl$BindingFault : WSDLReaderImpl.class$("javax.wsdl.BindingFault"), tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        return bindingFault;
    }

    private static BindingInput parseBindingInput(Element bindingInputEl, Definition def) throws WSDLException {
        BindingInput bindingInput = def.createBindingInput();
        String name = DOMUtils.getAttribute(bindingInputEl, "name");
        if (name != null) {
            bindingInput.setName(name);
        }
        Element tempEl = DOMUtils.getFirstChildElement(bindingInputEl);
        while (tempEl != null) {
            if (Constants.Q_ELEM_DOCUMENTATION.matches(tempEl)) {
                bindingInput.setDocumentationElement(tempEl);
            } else {
                bindingInput.addExtensibilityElement(WSDLReaderImpl.parseExtensibilityElement(class$javax$wsdl$BindingInput != null ? class$javax$wsdl$BindingInput : WSDLReaderImpl.class$("javax.wsdl.BindingInput"), tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        return bindingInput;
    }

    private static BindingOperation parseBindingOperation(Element bindingOperationEl, PortType portType, Definition def) throws WSDLException {
        BindingOperation bindingOperation = def.createBindingOperation();
        String name = DOMUtils.getAttribute(bindingOperationEl, "name");
        if (name != null) {
            bindingOperation.setName(name);
        }
        Element tempEl = DOMUtils.getFirstChildElement(bindingOperationEl);
        while (tempEl != null) {
            if (Constants.Q_ELEM_DOCUMENTATION.matches(tempEl)) {
                bindingOperation.setDocumentationElement(tempEl);
            } else if (Constants.Q_ELEM_INPUT.matches(tempEl)) {
                bindingOperation.setBindingInput(WSDLReaderImpl.parseBindingInput(tempEl, def));
            } else if (Constants.Q_ELEM_OUTPUT.matches(tempEl)) {
                bindingOperation.setBindingOutput(WSDLReaderImpl.parseBindingOutput(tempEl, def));
            } else if (Constants.Q_ELEM_FAULT.matches(tempEl)) {
                bindingOperation.addBindingFault(WSDLReaderImpl.parseBindingFault(tempEl, def));
            } else {
                bindingOperation.addExtensibilityElement(WSDLReaderImpl.parseExtensibilityElement(class$javax$wsdl$BindingOperation != null ? class$javax$wsdl$BindingOperation : WSDLReaderImpl.class$("javax.wsdl.BindingOperation"), tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        if (portType != null) {
            BindingOutput bindingOutput;
            String outputName;
            BindingInput bindingInput = bindingOperation.getBindingInput();
            String inputName = bindingInput != null ? bindingInput.getName() : null;
            Operation op = portType.getOperation(name, inputName, outputName = (bindingOutput = bindingOperation.getBindingOutput()) != null ? bindingOutput.getName() : null);
            if (op == null) {
                op = def.createOperation();
                op.setName(name);
                portType.addOperation(op);
            }
            bindingOperation.setOperation(op);
        }
        return bindingOperation;
    }

    private static BindingOutput parseBindingOutput(Element bindingOutputEl, Definition def) throws WSDLException {
        BindingOutput bindingOutput = def.createBindingOutput();
        String name = DOMUtils.getAttribute(bindingOutputEl, "name");
        if (name != null) {
            bindingOutput.setName(name);
        }
        Element tempEl = DOMUtils.getFirstChildElement(bindingOutputEl);
        while (tempEl != null) {
            if (Constants.Q_ELEM_DOCUMENTATION.matches(tempEl)) {
                bindingOutput.setDocumentationElement(tempEl);
            } else {
                bindingOutput.addExtensibilityElement(WSDLReaderImpl.parseExtensibilityElement(class$javax$wsdl$BindingOutput != null ? class$javax$wsdl$BindingOutput : WSDLReaderImpl.class$("javax.wsdl.BindingOutput"), tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        return bindingOutput;
    }

    private Definition parseDefinitions(String documentBaseURI, Element defEl, Map importedDefs) throws WSDLException {
        WSDLReaderImpl.checkElementName(defEl, Constants.Q_ELEM_DEFINITIONS);
        WSDLFactory factory = this.factoryImplName != null ? WSDLFactory.newInstance(this.factoryImplName) : WSDLFactory.newInstance();
        Definition def = factory.newDefinition();
        if (this.extReg != null) {
            def.setExtensionRegistry(this.extReg);
        }
        String name = DOMUtils.getAttribute(defEl, "name");
        String targetNamespace = DOMUtils.getAttribute(defEl, "targetNamespace");
        NamedNodeMap attrs = defEl.getAttributes();
        if (documentBaseURI != null) {
            def.setDocumentBaseURI(documentBaseURI);
        }
        if (name != null) {
            def.setQName(new QName(targetNamespace, name));
        }
        if (targetNamespace != null) {
            def.setTargetNamespace(targetNamespace);
        }
        int size = attrs.getLength();
        int i = 0;
        while (i < size) {
            Attr attr = (Attr)attrs.item(i);
            String namespaceURI = attr.getNamespaceURI();
            String localPart = attr.getLocalName();
            String value = attr.getValue();
            if (namespaceURI != null && namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
                if (localPart != null && !localPart.equals("xmlns")) {
                    def.addNamespace(localPart, value);
                } else {
                    def.addNamespace(null, value);
                }
            }
            ++i;
        }
        Element tempEl = DOMUtils.getFirstChildElement(defEl);
        while (tempEl != null) {
            if (Constants.Q_ELEM_IMPORT.matches(tempEl)) {
                if (importedDefs == null) {
                    importedDefs = new Hashtable<String, Definition>();
                }
                if (documentBaseURI != null) {
                    importedDefs.put(documentBaseURI, def);
                }
                def.addImport(this.parseImport(tempEl, def, importedDefs));
            } else if (Constants.Q_ELEM_DOCUMENTATION.matches(tempEl)) {
                def.setDocumentationElement(tempEl);
            } else if (Constants.Q_ELEM_TYPES.matches(tempEl)) {
                def.setTypes(WSDLReaderImpl.parseTypes(tempEl, def));
            } else if (Constants.Q_ELEM_MESSAGE.matches(tempEl)) {
                def.addMessage(WSDLReaderImpl.parseMessage(tempEl, def));
            } else if (Constants.Q_ELEM_PORT_TYPE.matches(tempEl)) {
                def.addPortType(WSDLReaderImpl.parsePortType(tempEl, def));
            } else if (Constants.Q_ELEM_BINDING.matches(tempEl)) {
                def.addBinding(WSDLReaderImpl.parseBinding(tempEl, def));
            } else if (Constants.Q_ELEM_SERVICE.matches(tempEl)) {
                def.addService(WSDLReaderImpl.parseService(tempEl, def));
            } else {
                def.addExtensibilityElement(WSDLReaderImpl.parseExtensibilityElement(class$javax$wsdl$Definition != null ? class$javax$wsdl$Definition : WSDLReaderImpl.class$("javax.wsdl.Definition"), tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        return def;
    }

    private static ExtensibilityElement parseExtensibilityElement(Class parentType, Element el, Definition def) throws WSDLException {
        QName elementType = new QName(el);
        try {
            ExtensionRegistry extReg = def.getExtensionRegistry();
            if (extReg == null) {
                throw new WSDLException("CONFIGURATION_ERROR", "No ExtensionRegistry set for this Definition, so unable to deserialize a '" + elementType + "' element in the " + "context of a '" + parentType.getName() + "'.");
            }
            ExtensionDeserializer extDS = extReg.queryDeserializer(parentType, elementType);
            return extDS.unmarshall(parentType, elementType, el, def, extReg);
        }
        catch (WSDLException e) {
            if (e.getLocation() == null) {
                e.setLocation(XPathUtils.getXPathExprFromNode(el));
            }
            throw e;
        }
    }

    private static Fault parseFault(Element faultEl, Definition def) throws WSDLException {
        Fault fault = def.createFault();
        String name = DOMUtils.getAttribute(faultEl, "name");
        QName messageName = DOMUtils.getQualifiedAttributeValue(faultEl, "message", "input", false);
        if (name != null) {
            fault.setName(name);
        }
        if (messageName != null) {
            Message message = def.getMessage(messageName);
            if (message == null) {
                message = def.createMessage();
                message.setQName(messageName);
                def.addMessage(message);
            }
            fault.setMessage(message);
        }
        Element tempEl = DOMUtils.getFirstChildElement(faultEl);
        while (tempEl != null) {
            if (Constants.Q_ELEM_DOCUMENTATION.matches(tempEl)) {
                fault.setDocumentationElement(tempEl);
            } else {
                DOMUtils.throwWSDLException(tempEl);
            }
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        return fault;
    }

    private Import parseImport(Element importEl, Definition def, Map importedDefs) throws WSDLException {
        Import importDef = def.createImport();
        String namespaceURI = DOMUtils.getAttribute(importEl, "namespace");
        String locationURI = DOMUtils.getAttribute(importEl, "location");
        if (namespaceURI != null) {
            importDef.setNamespaceURI(namespaceURI);
        }
        if (locationURI != null) {
            importDef.setLocationURI(locationURI);
            if (this.importDocuments) {
                try {
                    Reader reader;
                    InputSource inputSource;
                    Document doc;
                    Element documentElement;
                    String contextURI = def.getDocumentBaseURI();
                    URL contextURL = contextURI != null ? StringUtils.getURL(null, contextURI) : null;
                    URL url = StringUtils.getURL(contextURL, locationURI);
                    Definition importedDef = (Definition)importedDefs.get(url.toString());
                    if (importedDef == null && Constants.Q_ELEM_DEFINITIONS.matches(documentElement = (doc = WSDLReaderImpl.getDocument(inputSource = new InputSource(reader = StringUtils.getContentAsReader(url)), locationURI)).getDocumentElement())) {
                        if (this.verbose) {
                            System.out.println("Retrieving document at '" + locationURI + "'" + (contextURI == null ? "." : ", relative to '" + contextURI + "'."));
                        }
                        importedDef = this.readWSDL(url.toString(), documentElement, importedDefs);
                    }
                    if (importedDef != null) {
                        importDef.setDefinition(importedDef);
                    }
                }
                catch (WSDLException e) {
                    e.setLocation(XPathUtils.getXPathExprFromNode(importEl));
                    throw e;
                }
                catch (Throwable t) {
                    throw new WSDLException("OTHER_ERROR", "Unable to resolve imported document at '" + locationURI + "'.", t);
                }
            }
        }
        Element tempEl = DOMUtils.getFirstChildElement(importEl);
        while (tempEl != null) {
            if (Constants.Q_ELEM_DOCUMENTATION.matches(tempEl)) {
                importDef.setDocumentationElement(tempEl);
            } else {
                DOMUtils.throwWSDLException(tempEl);
            }
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        return importDef;
    }

    private static Input parseInput(Element inputEl, Definition def) throws WSDLException {
        Input input = def.createInput();
        String name = DOMUtils.getAttribute(inputEl, "name");
        QName messageName = DOMUtils.getQualifiedAttributeValue(inputEl, "message", "input", false);
        if (name != null) {
            input.setName(name);
        }
        if (messageName != null) {
            Message message = def.getMessage(messageName);
            if (message == null) {
                message = def.createMessage();
                message.setQName(messageName);
                def.addMessage(message);
            }
            input.setMessage(message);
        }
        Element tempEl = DOMUtils.getFirstChildElement(inputEl);
        while (tempEl != null) {
            if (Constants.Q_ELEM_DOCUMENTATION.matches(tempEl)) {
                input.setDocumentationElement(tempEl);
            } else {
                DOMUtils.throwWSDLException(tempEl);
            }
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        return input;
    }

    private static Message parseMessage(Element msgEl, Definition def) throws WSDLException {
        Message msg = null;
        String name = DOMUtils.getAttribute(msgEl, "name");
        if (name != null) {
            QName messageName = new QName(def.getTargetNamespace(), name);
            msg = def.getMessage(messageName);
            if (msg == null) {
                msg = def.createMessage();
                msg.setQName(messageName);
            }
        } else {
            msg = def.createMessage();
        }
        msg.setUndefined(false);
        Element tempEl = DOMUtils.getFirstChildElement(msgEl);
        while (tempEl != null) {
            if (Constants.Q_ELEM_DOCUMENTATION.matches(tempEl)) {
                msg.setDocumentationElement(tempEl);
            } else if (Constants.Q_ELEM_PART.matches(tempEl)) {
                msg.addPart(WSDLReaderImpl.parsePart(tempEl, def));
            } else {
                DOMUtils.throwWSDLException(tempEl);
            }
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        return msg;
    }

    private static Operation parseOperation(Element opEl, PortType portType, Definition def) throws WSDLException {
        Operation op = null;
        String name = DOMUtils.getAttribute(opEl, "name");
        String parameterOrderStr = DOMUtils.getAttribute(opEl, "parameterOrder");
        Element tempEl = DOMUtils.getFirstChildElement(opEl);
        Vector<String> messageOrder = new Vector<String>();
        Element docEl = null;
        Input input = null;
        Output output = null;
        Vector<Fault> faults = new Vector<Fault>();
        while (tempEl != null) {
            if (Constants.Q_ELEM_DOCUMENTATION.matches(tempEl)) {
                docEl = tempEl;
            } else if (Constants.Q_ELEM_INPUT.matches(tempEl)) {
                input = WSDLReaderImpl.parseInput(tempEl, def);
                messageOrder.add("input");
            } else if (Constants.Q_ELEM_OUTPUT.matches(tempEl)) {
                output = WSDLReaderImpl.parseOutput(tempEl, def);
                messageOrder.add("output");
            } else if (Constants.Q_ELEM_FAULT.matches(tempEl)) {
                faults.add(WSDLReaderImpl.parseFault(tempEl, def));
            } else {
                DOMUtils.throwWSDLException(tempEl);
            }
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        if (name != null) {
            String outputName;
            String inputName = input != null ? input.getName() : null;
            op = portType.getOperation(name, inputName, outputName = output != null ? output.getName() : null);
            if (op == null) {
                op = def.createOperation();
                op.setName(name);
            }
        } else {
            op = def.createOperation();
        }
        op.setUndefined(false);
        if (parameterOrderStr != null) {
            op.setParameterOrdering(StringUtils.parseNMTokens(parameterOrderStr));
        }
        if (docEl != null) {
            op.setDocumentationElement(docEl);
        }
        if (input != null) {
            op.setInput(input);
        }
        if (output != null) {
            op.setOutput(output);
        }
        if (faults.size() > 0) {
            Iterator faultIterator = faults.iterator();
            while (faultIterator.hasNext()) {
                op.addFault((Fault)faultIterator.next());
            }
        }
        OperationType style = null;
        if (messageOrder.equals(STYLE_ONE_WAY)) {
            style = OperationType.ONE_WAY;
        } else if (messageOrder.equals(STYLE_REQUEST_RESPONSE)) {
            style = OperationType.REQUEST_RESPONSE;
        } else if (messageOrder.equals(STYLE_SOLICIT_RESPONSE)) {
            style = OperationType.SOLICIT_RESPONSE;
        } else if (messageOrder.equals(STYLE_NOTIFICATION)) {
            style = OperationType.NOTIFICATION;
        }
        if (style != null) {
            op.setStyle(style);
        }
        return op;
    }

    private static Output parseOutput(Element outputEl, Definition def) throws WSDLException {
        Output output = def.createOutput();
        String name = DOMUtils.getAttribute(outputEl, "name");
        QName messageName = DOMUtils.getQualifiedAttributeValue(outputEl, "message", "input", false);
        if (name != null) {
            output.setName(name);
        }
        if (messageName != null) {
            Message message = def.getMessage(messageName);
            if (message == null) {
                message = def.createMessage();
                message.setQName(messageName);
                def.addMessage(message);
            }
            output.setMessage(message);
        }
        Element tempEl = DOMUtils.getFirstChildElement(outputEl);
        while (tempEl != null) {
            if (Constants.Q_ELEM_DOCUMENTATION.matches(tempEl)) {
                output.setDocumentationElement(tempEl);
            } else {
                DOMUtils.throwWSDLException(tempEl);
            }
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        return output;
    }

    private static Part parsePart(Element partEl, Definition def) throws WSDLException {
        Part part = def.createPart();
        String name = DOMUtils.getAttribute(partEl, "name");
        QName elementName = DOMUtils.getQualifiedAttributeValue(partEl, "element", "message", false);
        QName typeName = DOMUtils.getQualifiedAttributeValue(partEl, "type", "message", false);
        if (name != null) {
            part.setName(name);
        }
        if (elementName != null) {
            part.setElementName(elementName);
        }
        if (typeName != null) {
            part.setTypeName(typeName);
        }
        Element tempEl = DOMUtils.getFirstChildElement(partEl);
        while (tempEl != null) {
            if (Constants.Q_ELEM_DOCUMENTATION.matches(tempEl)) {
                part.setDocumentationElement(tempEl);
            } else {
                DOMUtils.throwWSDLException(tempEl);
            }
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        return part;
    }

    private static Port parsePort(Element portEl, Definition def) throws WSDLException {
        Port port = def.createPort();
        String name = DOMUtils.getAttribute(portEl, "name");
        QName bindingStr = DOMUtils.getQualifiedAttributeValue(portEl, "binding", "port", false);
        if (name != null) {
            port.setName(name);
        }
        if (bindingStr != null) {
            Binding binding = def.getBinding(bindingStr);
            if (binding == null) {
                binding = def.createBinding();
                binding.setQName(bindingStr);
                def.addBinding(binding);
            }
            port.setBinding(binding);
        }
        Element tempEl = DOMUtils.getFirstChildElement(portEl);
        while (tempEl != null) {
            if (Constants.Q_ELEM_DOCUMENTATION.matches(tempEl)) {
                port.setDocumentationElement(tempEl);
            } else {
                port.addExtensibilityElement(WSDLReaderImpl.parseExtensibilityElement(class$javax$wsdl$Port != null ? class$javax$wsdl$Port : WSDLReaderImpl.class$("javax.wsdl.Port"), tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        return port;
    }

    private static PortType parsePortType(Element portTypeEl, Definition def) throws WSDLException {
        PortType portType = null;
        String name = DOMUtils.getAttribute(portTypeEl, "name");
        if (name != null) {
            QName portTypeName = new QName(def.getTargetNamespace(), name);
            portType = def.getPortType(portTypeName);
            if (portType == null) {
                portType = def.createPortType();
                portType.setQName(portTypeName);
            }
        } else {
            portType = def.createPortType();
        }
        portType.setUndefined(false);
        Element tempEl = DOMUtils.getFirstChildElement(portTypeEl);
        while (tempEl != null) {
            if (Constants.Q_ELEM_DOCUMENTATION.matches(tempEl)) {
                portType.setDocumentationElement(tempEl);
            } else if (Constants.Q_ELEM_OPERATION.matches(tempEl)) {
                portType.addOperation(WSDLReaderImpl.parseOperation(tempEl, portType, def));
            } else {
                DOMUtils.throwWSDLException(tempEl);
            }
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        return portType;
    }

    private static Service parseService(Element serviceEl, Definition def) throws WSDLException {
        Service service = def.createService();
        String name = DOMUtils.getAttribute(serviceEl, "name");
        if (name != null) {
            service.setQName(new QName(def.getTargetNamespace(), name));
        }
        Element tempEl = DOMUtils.getFirstChildElement(serviceEl);
        while (tempEl != null) {
            if (Constants.Q_ELEM_DOCUMENTATION.matches(tempEl)) {
                service.setDocumentationElement(tempEl);
            } else if (Constants.Q_ELEM_PORT.matches(tempEl)) {
                service.addPort(WSDLReaderImpl.parsePort(tempEl, def));
            } else {
                service.addExtensibilityElement(WSDLReaderImpl.parseExtensibilityElement(class$javax$wsdl$Service != null ? class$javax$wsdl$Service : WSDLReaderImpl.class$("javax.wsdl.Service"), tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        return service;
    }

    private static Types parseTypes(Element typesEl, Definition def) throws WSDLException {
        Types types = def.createTypes();
        Element tempEl = DOMUtils.getFirstChildElement(typesEl);
        while (tempEl != null) {
            if (Constants.Q_ELEM_DOCUMENTATION.matches(tempEl)) {
                types.setDocumentationElement(tempEl);
            } else {
                types.addExtensibilityElement(WSDLReaderImpl.parseExtensibilityElement(class$javax$wsdl$Types != null ? class$javax$wsdl$Types : WSDLReaderImpl.class$("javax.wsdl.Types"), tempEl, def));
            }
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        return types;
    }

    public Definition readWSDL(String wsdlURI) throws WSDLException {
        return this.readWSDL(null, wsdlURI);
    }

    public Definition readWSDL(String contextURI, String wsdlURI) throws WSDLException {
        try {
            if (this.verbose) {
                System.out.println("Retrieving document at '" + wsdlURI + "'" + (contextURI == null ? "." : ", relative to '" + contextURI + "'."));
            }
            URL contextURL = contextURI != null ? StringUtils.getURL(null, contextURI) : null;
            URL url = StringUtils.getURL(contextURL, wsdlURI);
            Reader reader = StringUtils.getContentAsReader(url);
            InputSource inputSource = new InputSource(reader);
            Document doc = WSDLReaderImpl.getDocument(inputSource, wsdlURI);
            Definition def = this.readWSDL(url.toString(), doc);
            return def;
        }
        catch (WSDLException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new WSDLException("OTHER_ERROR", "Unable to resolve imported document at '" + wsdlURI + "'.", t);
        }
    }

    public Definition readWSDL(String documentBaseURI, Document wsdlDocument) throws WSDLException {
        return this.readWSDL(documentBaseURI, wsdlDocument.getDocumentElement());
    }

    public Definition readWSDL(String documentBaseURI, Element definitionsElement) throws WSDLException {
        return this.readWSDL(documentBaseURI, definitionsElement, null);
    }

    private Definition readWSDL(String documentBaseURI, Element definitionsElement, Map importedDefs) throws WSDLException {
        return this.parseDefinitions(documentBaseURI, definitionsElement, importedDefs);
    }

    public Definition readWSDL(String documentBaseURI, InputSource inputSource) throws WSDLException {
        return this.readWSDL(documentBaseURI, WSDLReaderImpl.getDocument(inputSource, "- WSDL Document -"));
    }

    public void setExtensionRegistry(ExtensionRegistry extReg) {
        this.extReg = extReg;
    }

    public void setFactoryImplName(String factoryImplName) throws UnsupportedOperationException {
        this.factoryImplName = factoryImplName;
    }

    public void setFeature(String name, boolean value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Feature name must not be null.");
        }
        if (name.equals("javax.wsdl.verbose")) {
            this.verbose = value;
        } else if (name.equals("javax.wsdl.importDocuments")) {
            this.importDocuments = value;
        } else {
            throw new IllegalArgumentException("Feature name '" + name + "' not recognized.");
        }
    }
}

