/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import org.jboss.ejb.Container;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.StatefulSessionContainer;
import org.jboss.ejb.StatefulSessionEnterpriseContext;
import org.jboss.ejb.StatefulSessionPersistenceManager;
import org.jboss.ejb.plugins.HAPersistentManager;
import org.jboss.ejb.plugins.SessionObjectInputStream;
import org.jboss.ejb.plugins.SessionObjectOutputStream;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.hasessionstate.interfaces.HASessionState;
import org.jboss.ha.hasessionstate.interfaces.PackagedSession;
import org.jboss.logging.Logger;
import org.jboss.metadata.ClusterConfigMetaData;

public class StatefulHASessionPersistenceManager
implements StatefulSessionPersistenceManager,
HASessionState.HASessionStateListener,
HAPersistentManager {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$ejb$plugins$StatefulSessionFilePersistenceManager == null ? (class$org$jboss$ejb$plugins$StatefulSessionFilePersistenceManager = StatefulHASessionPersistenceManager.class$("org.jboss.ejb.plugins.StatefulSessionFilePersistenceManager")) : class$org$jboss$ejb$plugins$StatefulSessionFilePersistenceManager));
    private StatefulSessionContainer con;
    private Method ejbActivate;
    private Method ejbPassivate;
    private Method ejbRemove;
    private ArrayList fields;
    private HASessionState sessionState = null;
    private String localNodeName = null;
    private String appName = null;
    private static long id = System.currentTimeMillis();
    private static String DEFAULT_HASESSIONSTATE_JNDI_NAME = "/HASessionState/Default";
    static /* synthetic */ Class class$org$jboss$ejb$plugins$StatefulSessionFilePersistenceManager;
    static /* synthetic */ Class class$javax$ejb$SessionBean;
    static /* synthetic */ Class class$java$lang$Object;

    public void setContainer(Container c) {
        this.con = (StatefulSessionContainer)c;
    }

    public void create() throws Exception {
        this.ejbActivate = (class$javax$ejb$SessionBean == null ? (class$javax$ejb$SessionBean = StatefulHASessionPersistenceManager.class$("javax.ejb.SessionBean")) : class$javax$ejb$SessionBean).getMethod("ejbActivate", new Class[0]);
        this.ejbPassivate = (class$javax$ejb$SessionBean == null ? (class$javax$ejb$SessionBean = StatefulHASessionPersistenceManager.class$("javax.ejb.SessionBean")) : class$javax$ejb$SessionBean).getMethod("ejbPassivate", new Class[0]);
        this.ejbRemove = (class$javax$ejb$SessionBean == null ? (class$javax$ejb$SessionBean = StatefulHASessionPersistenceManager.class$("javax.ejb.SessionBean")) : class$javax$ejb$SessionBean).getMethod("ejbRemove", new Class[0]);
        String ejbName = this.con.getBeanMetaData().getEjbName();
        String sessionStateName = "/HASessionState/Default";
        ClusterConfigMetaData config = this.con.getBeanMetaData().getClusterConfigMetaData();
        if (config != null) {
            sessionStateName = config.getHaSessionStateName();
        }
        InitialContext ctx = new InitialContext();
        this.sessionState = (HASessionState)ctx.lookup(sessionStateName);
        this.localNodeName = this.sessionState.getNodeName();
        Class beanClass = this.con.getBeanClass();
        this.fields = new ArrayList();
        while (!beanClass.equals(class$java$lang$Object == null ? StatefulHASessionPersistenceManager.class$("java.lang.Object") : class$java$lang$Object)) {
            Field[] f = beanClass.getDeclaredFields();
            int i = 0;
            while (i < f.length) {
                if (!Modifier.isTransient(f[i].getModifiers())) {
                    this.fields.add(f[i]);
                }
                ++i;
            }
            beanClass = beanClass.getSuperclass();
        }
        this.appName = this.con.getBeanMetaData().getJndiName();
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public void createSession(Method m, Object[] args, StatefulSessionEnterpriseContext ctx) throws Exception {
        ctx.setId((Object)this.nextId());
        try {
            Method createMethod = this.con.getBeanClass().getMethod("ejbCreate", m.getParameterTypes());
            createMethod.invoke(ctx.getInstance(), args);
            this.sessionState.createSession(this.appName, ctx.getId());
        }
        catch (IllegalAccessException e) {
            ctx.setId(null);
            throw new EJBException((Exception)e);
        }
        catch (InvocationTargetException ite) {
            ctx.setId(null);
            Throwable e = ite.getTargetException();
            if (e instanceof EJBException) {
                throw (EJBException)e;
            }
            if (e instanceof RuntimeException) {
                throw new EJBException((Exception)e);
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw (Error)e;
        }
        this.con.getInstanceCache().insert((EnterpriseContext)ctx);
        if (this.con.getContainerInvoker() != null) {
            ctx.setEJBObject((EJBObject)this.con.getContainerInvoker().getStatefulSessionEJBObject(ctx.getId()));
        }
        if (this.con.getLocalHomeClass() != null) {
            ctx.setEJBLocalObject(this.con.getLocalContainerInvoker().getStatefulSessionEJBLocalObject(ctx.getId()));
        }
    }

    public void activateSession(StatefulSessionEnterpriseContext ctx) throws RemoteException {
        try {
            PackagedSession state = this.sessionState.getStateWithOwnership(this.appName, ctx.getId());
            SessionObjectInputStream in = new SessionObjectInputStream(ctx, (InputStream)new ByteArrayInputStream(state.getState()));
            ctx.setInstance(in.readObject());
            in.close();
            this.removePassivated(ctx.getId());
            this.ejbActivate.invoke(ctx.getInstance(), new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new ServerException("Could not activate", e);
        }
        catch (IOException e) {
            throw new ServerException("Could not activate", e);
        }
        catch (IllegalAccessException e) {
            throw new EJBException((Exception)e);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            if (e instanceof EJBException) {
                throw (EJBException)e;
            }
            if (e instanceof RuntimeException) {
                throw new EJBException((Exception)e);
            }
            if (e instanceof RemoteException) {
                throw (RemoteException)e;
            }
            throw (Error)e;
        }
    }

    public void passivateSession(StatefulSessionEnterpriseContext ctx) throws RemoteException {
    }

    public void synchroSession(StatefulSessionEnterpriseContext ctx) throws RemoteException {
        try {
            this.ejbPassivate.invoke(ctx.getInstance(), new Object[0]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SessionObjectOutputStream out = new SessionObjectOutputStream((OutputStream)baos);
            out.writeObject(ctx.getInstance());
            out.close();
            this.sessionState.setState(this.appName, ctx.getId(), baos.toByteArray());
            this.ejbActivate.invoke(ctx.getInstance(), new Object[0]);
        }
        catch (IOException e) {
            throw new ServerException("Could not passivate", e);
        }
        catch (IllegalAccessException e) {
            throw new EJBException((Exception)e);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            if (e instanceof EJBException) {
                throw (EJBException)e;
            }
            if (e instanceof RuntimeException) {
                throw new EJBException((Exception)e);
            }
            if (e instanceof RemoteException) {
                throw (RemoteException)e;
            }
            throw (Error)e;
        }
    }

    public void removeSession(StatefulSessionEnterpriseContext ctx) throws RemoteException, RemoveException {
        try {
            try {
                this.ejbRemove.invoke(ctx.getInstance(), new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new EJBException((Exception)e);
            }
            catch (InvocationTargetException ite) {
                Throwable e = ite.getTargetException();
                if (e instanceof EJBException) {
                    throw (EJBException)e;
                }
                if (e instanceof RuntimeException) {
                    throw new EJBException((Exception)e);
                }
                if (e instanceof RemoveException) {
                    throw (RemoveException)e;
                }
                if (e instanceof RemoteException) {
                    throw (RemoteException)e;
                }
                throw (Error)e;
            }
            Object var6_2 = null;
        }
        catch (Throwable throwable) {
            Object var6_3 = null;
            this.sessionState.removeSession(this.appName, ctx.getId());
            throw throwable;
        }
        this.sessionState.removeSession(this.appName, ctx.getId());
    }

    public void removePassivated(Object key) {
        this.sessionState.removeSession(this.appName, key);
    }

    protected String nextId() {
        return this.localNodeName + ":" + id++;
    }

    public void sessionExternallyModified(PackagedSession session) {
        this.con.getInstanceCache().remove((Object)session.getKey());
    }

    public void newSessionStateTopology(HAPartition haSubPartition) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

