/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEApplication;
import org.jboss.management.j2ee.J2EEDeployedObject;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEModule;
import org.jboss.management.j2ee.J2EEServer;
import org.jboss.management.j2ee.ResourceAdapterModuleMBean;
import org.jboss.management.j2ee.StateManagement;

public class ResourceAdapterModule
extends J2EEModule
implements ResourceAdapterModuleMBean {
    public static final String J2EE_TYPE = "ResourceAdapterModule";
    private StateManagement mState;
    private List mResourceAdapters = new ArrayList();
    private ObjectName mService;
    private static final Map mCreatedParents = new HashMap();
    static /* synthetic */ Class class$org$jboss$management$j2ee$ResourceAdapterModule;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$management$ObjectName;
    static /* synthetic */ Class array$Ljavax$management$ObjectName;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectName create(MBeanServer pServer, String pApplicationName, String pName, URL pURL, ObjectName pService) {
        Logger lLog = Logger.getLogger((Class)(class$org$jboss$management$j2ee$ResourceAdapterModule == null ? (class$org$jboss$management$j2ee$ResourceAdapterModule = ResourceAdapterModule.class$("org.jboss.management.j2ee.ResourceAdapterModule")) : class$org$jboss$management$j2ee$ResourceAdapterModule));
        if (!J2EEServer.sIsActive) {
            return null;
        }
        String lDD = null;
        ObjectName lApplication = null;
        ObjectName lCreated = null;
        try {
            ObjectName lServer = pServer.queryNames(new ObjectName(J2EEManagedObject.getDomainName() + ":" + "j2eeType" + "=" + "J2EEServer" + "," + "*"), null).iterator().next();
            String lServerName = lServer.getKeyPropertyList().get("j2eeType") + "=" + lServer.getKeyPropertyList().get("name");
            lLog.debug((Object)("ResourceAdapterModule.create(), server name: " + lServerName));
            if (pName.compareTo(pApplicationName) != 0) {
                ObjectName parentAppQuery = new ObjectName(J2EEManagedObject.getDomainName() + ":" + "j2eeType" + "=" + "J2EEApplication" + "," + "name=" + pApplicationName + "," + lServerName + "," + "*");
                Set<ObjectName> parentApps = pServer.queryNames(parentAppQuery, null);
                if (parentApps.size() == 0) {
                    lApplication = lCreated = J2EEApplication.create(pServer, pApplicationName, null);
                } else {
                    if (parentApps.size() != 1) return null;
                    lApplication = parentApps.iterator().next();
                }
            } else {
                Hashtable<String, String> lProperties = new Hashtable<String, String>();
                lProperties.put("J2EEServer", lServer.getKeyPropertyList().get("name"));
                lProperties.put("name", " ");
                lApplication = new ObjectName(J2EEManagedObject.getDomainName(), lProperties);
            }
            lDD = J2EEDeployedObject.getDeploymentDescriptor(pURL, 3);
        }
        catch (Exception e) {
            return null;
        }
        try {
            lLog.debug((Object)("Create ResourceAdapterModule, name: " + pName + ", application: " + lApplication + ", dd: " + lDD));
            ObjectName lModule = pServer.createMBean("org.jboss.management.j2ee.ResourceAdapterModule", null, new Object[]{pName, lApplication, null, lDD, pService}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = ResourceAdapterModule.class$("java.lang.String")) : class$java$lang$String).getName(), (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = ResourceAdapterModule.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName(), (array$Ljavax$management$ObjectName == null ? (array$Ljavax$management$ObjectName = ResourceAdapterModule.class$("[Ljavax.management.ObjectName;")) : array$Ljavax$management$ObjectName).getName(), (class$java$lang$String == null ? (class$java$lang$String = ResourceAdapterModule.class$("java.lang.String")) : class$java$lang$String).getName(), (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = ResourceAdapterModule.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName()}).getObjectName();
            if (lCreated == null) return lModule;
            mCreatedParents.put(lModule, lCreated);
            return lModule;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void destroy(MBeanServer pServer, String pModuleName) {
        Logger lLog = Logger.getLogger((Class)(class$org$jboss$management$j2ee$ResourceAdapterModule == null ? (class$org$jboss$management$j2ee$ResourceAdapterModule = ResourceAdapterModule.class$("org.jboss.management.j2ee.ResourceAdapterModule")) : class$org$jboss$management$j2ee$ResourceAdapterModule));
        if (!J2EEServer.sIsActive) {
            return;
        }
        try {
            ObjectName lSearch = new ObjectName(J2EEManagedObject.getDomainName() + ":" + "j2eeType" + "=" + J2EE_TYPE + "," + "name=" + pModuleName + "," + "*");
            Set<ObjectName> lNames = pServer.queryNames(lSearch, null);
            if (!lNames.isEmpty()) {
                ObjectName lResourceAdapterModule = lNames.iterator().next();
                pServer.unregisterMBean(lResourceAdapterModule);
                ObjectName lApplication = (ObjectName)mCreatedParents.get(lResourceAdapterModule);
                if (lApplication != null) {
                    lLog.info((Object)("Remove fake JSR-77 parent Application: " + lApplication.toString()));
                    J2EEApplication.destroy(pServer, lApplication.toString());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ResourceAdapterModule(String pName, ObjectName pApplication, ObjectName[] pJVMs, String pDeploymentDescriptor, ObjectName pService) throws MalformedObjectNameException, InvalidParentException {
        super(J2EE_TYPE, pName, pApplication, pJVMs, pDeploymentDescriptor);
        this.mService = pService;
        this.mState = new StateManagement(this);
    }

    public ObjectName[] getResourceAdapters() {
        return this.mResourceAdapters.toArray(new ObjectName[0]);
    }

    public ObjectName getResourceAdapter(int pIndex) {
        if (pIndex >= 0 && pIndex < this.mResourceAdapters.size()) {
            return (ObjectName)this.mResourceAdapters.get(pIndex);
        }
        return null;
    }

    public void addChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("ResourceAdapter".equals(lType)) {
            this.mResourceAdapters.add(pChild);
        }
    }

    public void removeChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("ResourceAdapter".equals(lType)) {
            this.mResourceAdapters.remove(pChild);
        }
    }

    public void postCreation() {
        this.sendNotification(new Notification(StateManagement.sTypes[0], this.getName(), 1L, System.currentTimeMillis(), "Resource Adapter Module created"));
    }

    public void preDestruction() {
        this.sendNotification(new Notification(StateManagement.sTypes[1], this.getName(), 1L, System.currentTimeMillis(), "Resource Adapter Module deleted"));
    }

    public String[] getEventTypes() {
        return StateManagement.sTypes;
    }

    public String getEventType(int pIndex) {
        if (pIndex >= 0 && pIndex < StateManagement.sTypes.length) {
            return StateManagement.sTypes[pIndex];
        }
        return null;
    }

    public long getStartTime() {
        return this.mState.getStartTime();
    }

    public int getState() {
        return this.mState.getState();
    }

    public void mejbStart() {
        this.mState.setState(4);
        try {
            this.getServer().invoke(this.mService, "start", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.getLog().error((Object)"Start of Resource Adapter Module failed", (Throwable)e);
        }
        this.mState.setState(5);
    }

    public void mejbStartRecursive() {
        this.mejbStart();
    }

    public void mejbStop() {
        this.mState.setState(3);
        try {
            this.getServer().invoke(this.mService, "stop", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.getLog().error((Object)"Stop of Resource Adapter Module failed", (Throwable)e);
        }
        this.mState.setState(2);
    }

    public String toString() {
        return "ResourceAdapterModule[ " + super.toString() + "ResourceAdapters: " + this.mResourceAdapters + " ]";
    }

    protected Hashtable getParentKeys(ObjectName pParent) {
        Hashtable<String, String> lReturn = new Hashtable<String, String>();
        Hashtable<String, String> lProperties = pParent.getKeyPropertyList();
        lReturn.put("J2EEApplication", lProperties.get("name"));
        lReturn.put("J2EEServer", lProperties.get("J2EEServer"));
        return lReturn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

