/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.Debug;
import javax.security.auth.login.LoginException;

public class LoginContext {
    private static final String INIT_METHOD = "initialize";
    private static final String LOGIN_METHOD = "login";
    private static final String COMMIT_METHOD = "commit";
    private static final String ABORT_METHOD = "abort";
    private static final String LOGOUT_METHOD = "logout";
    private static final String OTHER = "other";
    private static final String DEFAULT_HANDLER = "auth.login.defaultCallbackHandler";
    private Subject subject = null;
    private boolean subjectProvided = false;
    private boolean loginSucceeded = false;
    private CallbackHandler callbackHandler;
    private Map state = new HashMap();
    private Configuration config;
    private AppConfigurationEntry[] moduleStack;
    private ClassLoader contextClassLoader = null;
    private static final Class[] PARAMS = new Class[0];
    private static final Debug debug = Debug.getInstance("logincontext", "\t[LoginContext]");

    private void init(String name) throws LoginException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("createLoginContext." + name));
        }
        if (name == null) {
            throw new LoginException("Invalid null input: name");
        }
        if (this.config == null) {
            this.config = (Configuration)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Configuration.getConfiguration();
                }
            });
        }
        this.moduleStack = this.config.getAppConfigurationEntry(name);
        if (this.moduleStack == null) {
            if (sm != null) {
                sm.checkPermission(new AuthPermission("createLoginContext.other"));
            }
            this.moduleStack = this.config.getAppConfigurationEntry(OTHER);
            if (this.moduleStack == null) {
                MessageFormat form = new MessageFormat("No LoginModules configured for name");
                Object[] source = new Object[]{name};
                throw new LoginException(form.format(source));
            }
        }
        this.contextClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private void loadDefaultCallbackHandler() throws LoginException {
        try {
            final ClassLoader finalLoader = this.contextClassLoader;
            this.callbackHandler = (CallbackHandler)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String defaultHandler = Security.getProperty(LoginContext.DEFAULT_HANDLER);
                    if (defaultHandler == null || defaultHandler.length() == 0) {
                        return null;
                    }
                    Class<?> c = Class.forName(defaultHandler, true, finalLoader);
                    return c.newInstance();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new LoginException(pae.getException().toString());
        }
        if (this.callbackHandler != null) {
            this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), this.callbackHandler);
        }
    }

    public LoginContext(String name) throws LoginException {
        this.init(name);
        this.loadDefaultCallbackHandler();
    }

    public LoginContext(String name, Subject subject) throws LoginException {
        this.init(name);
        if (subject == null) {
            throw new LoginException("invalid null Subject provided");
        }
        this.subject = subject;
        this.subjectProvided = true;
        this.loadDefaultCallbackHandler();
    }

    public LoginContext(String name, CallbackHandler callbackHandler) throws LoginException {
        this.init(name);
        if (callbackHandler == null) {
            throw new LoginException("invalid null CallbackHandler provided");
        }
        this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), callbackHandler);
    }

    public LoginContext(String name, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        this(name, subject);
        if (callbackHandler == null) {
            throw new LoginException("invalid null CallbackHandler provided");
        }
        this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), callbackHandler);
    }

    public void login() throws LoginException {
        this.loginSucceeded = false;
        if (this.subject == null) {
            this.subject = new Subject();
        }
        try {
            this.invokeModule(LOGIN_METHOD);
            this.invokeModule(COMMIT_METHOD);
            this.loginSucceeded = true;
        }
        catch (LoginException le) {
            try {
                this.invokeModule(ABORT_METHOD);
            }
            catch (LoginException le2) {
                throw le;
            }
            throw le;
        }
    }

    public void logout() throws LoginException {
        if (this.subject == null) {
            throw new LoginException("null subject - logout called before login");
        }
        this.invokeModule(LOGOUT_METHOD);
    }

    public Subject getSubject() {
        if (!this.loginSucceeded && !this.subjectProvided) {
            return null;
        }
        return this.subject;
    }

    private void throwException(LoginException originalError, LoginException le) throws LoginException {
        LoginException error = originalError != null ? originalError : le;
        throw error;
    }

    private void invokeModule(String methodName) throws LoginException {
        try {
            final String finalName = methodName;
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws LoginException {
                    LoginContext.this.invoke(finalName);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (LoginException)pae.getException();
        }
    }

    private void invoke(String methodName) throws LoginException {
        LoginException firstError = null;
        LoginException firstRequiredError = null;
        boolean success = false;
        int i = 0;
        while (i < this.moduleStack.length) {
            block34: {
                try {
                    int mIndex = 0;
                    Method[] methods = null;
                    if (this.moduleStack[i].module != null) {
                        methods = this.moduleStack[i].module.getClass().getMethods();
                    } else {
                        Class<?> c = Class.forName(this.moduleStack[i].getLoginModuleName(), true, this.contextClassLoader);
                        Constructor<?> constructor = c.getConstructor(PARAMS);
                        Object[] args = new Object[]{};
                        this.moduleStack[i].module = constructor.newInstance(args);
                        methods = this.moduleStack[i].module.getClass().getMethods();
                        mIndex = 0;
                        while (mIndex < methods.length) {
                            if (methods[mIndex].getName().equals(INIT_METHOD)) break;
                            ++mIndex;
                        }
                        Object[] initArgs = new Object[]{this.subject, this.callbackHandler, this.state, this.moduleStack[i].getOptions()};
                        methods[mIndex].invoke(this.moduleStack[i].module, initArgs);
                    }
                    mIndex = 0;
                    while (mIndex < methods.length) {
                        if (methods[mIndex].getName().equals(methodName)) break;
                        ++mIndex;
                    }
                    Object[] args = new Object[]{};
                    boolean status = (Boolean)methods[mIndex].invoke(this.moduleStack[i].module, args);
                    if (status) {
                        if (!methodName.equals(ABORT_METHOD) && !methodName.equals(LOGOUT_METHOD) && this.moduleStack[i].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT && firstRequiredError == null) {
                            if (debug != null) {
                                debug.println(methodName + " SUFFICIENT success");
                            }
                            return;
                        }
                        if (debug != null) {
                            debug.println(methodName + " success");
                        }
                        success = true;
                    } else if (debug != null) {
                        debug.println(methodName + " ignored");
                    }
                }
                catch (NoSuchMethodException nsme) {
                    MessageFormat form = new MessageFormat("unable to instantiate LoginModule, module, because it does not provide a no-argument constructor");
                    Object[] source = new Object[]{this.moduleStack[i].getLoginModuleName()};
                    throw new LoginException(form.format(source));
                }
                catch (InstantiationException ie) {
                    throw new LoginException("unable to instantiate LoginModule: " + ie.getMessage());
                }
                catch (ClassNotFoundException cnfe) {
                    throw new LoginException("unable to find LoginModule class: " + cnfe.getMessage());
                }
                catch (IllegalAccessException iae) {
                    throw new LoginException("unable to access LoginModule: " + iae.getMessage());
                }
                catch (InvocationTargetException ite) {
                    LoginException le;
                    if (ite.getTargetException() instanceof LoginException) {
                        le = (LoginException)ite.getTargetException();
                    } else {
                        StringWriter sw = new StringWriter();
                        ite.getTargetException().printStackTrace(new PrintWriter(sw));
                        sw.flush();
                        le = new LoginException(sw.toString());
                    }
                    if (this.moduleStack[i].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                        if (debug != null) {
                            debug.println(methodName + " REQUISITE failure");
                        }
                        if (methodName.equals(ABORT_METHOD) || methodName.equals(LOGOUT_METHOD)) {
                            if (firstRequiredError == null) {
                                firstRequiredError = le;
                            }
                        } else {
                            this.throwException(firstRequiredError, le);
                        }
                    }
                    if (this.moduleStack[i].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
                        if (debug != null) {
                            debug.println(methodName + " REQUIRED failure");
                        }
                        if (firstRequiredError == null) {
                            firstRequiredError = le;
                        }
                    }
                    if (debug != null) {
                        debug.println(methodName + " OPTIONAL failure");
                    }
                    if (firstError != null) break block34;
                    firstError = le;
                }
            }
            ++i;
        }
        if (firstRequiredError != null) {
            this.throwException(firstRequiredError, null);
        } else if (!success && firstError != null) {
            this.throwException(firstError, null);
        } else if (!success) {
            this.throwException(new LoginException("Login Failure: all modules ignored"), null);
        } else {
            return;
        }
    }

    private class SecureCallbackHandler
    implements CallbackHandler {
        private final AccessControlContext acc;
        private final CallbackHandler ch;

        SecureCallbackHandler(AccessControlContext acc, CallbackHandler ch) {
            this.acc = acc;
            this.ch = ch;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            try {
                Callback[] finalCallbacks = callbacks;
                AccessController.doPrivileged(new PrivilegedExceptionAction(this, finalCallbacks){
                    private final /* synthetic */ Callback[] val$finalCallbacks;
                    private final /* synthetic */ SecureCallbackHandler this$1;
                    {
                        this.this$1 = this$1;
                        this.val$finalCallbacks = val$finalCallbacks;
                    }

                    public Object run() throws IOException, UnsupportedCallbackException {
                        SecureCallbackHandler.access$100(this.this$1).handle(this.val$finalCallbacks);
                        return null;
                    }
                }, this.acc);
            }
            catch (PrivilegedActionException pae) {
                if (pae.getException() instanceof IOException) {
                    throw (IOException)pae.getException();
                }
                throw (UnsupportedCallbackException)pae.getException();
            }
        }

        static /* synthetic */ CallbackHandler access$100(SecureCallbackHandler x0) {
            return x0.ch;
        }
    }
}

