/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.axis;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;

public class AxisInvocationHandler
implements InvocationHandler {
    protected final Map methodToInterface;
    protected final Map methodToName;
    protected final Call call;

    public AxisInvocationHandler(Call call, Map methodMap, Map interfaceMap) {
        this.call = call;
        this.methodToInterface = interfaceMap;
        this.methodToName = methodMap;
    }

    public AxisInvocationHandler(URL endpoint, Service service, Map methodMap, Map interfaceMap) {
        this(new Call(service), methodMap, interfaceMap);
        this.call.setTargetEndpointAddress(endpoint);
        this.setBasicAuthentication(endpoint);
    }

    public AxisInvocationHandler(URL endPoint, Map methodMap, Map interfaceMap, boolean maintainSession) {
        this(endPoint, new Service(), methodMap, interfaceMap);
        this.call.setMaintainSession(maintainSession);
    }

    public AxisInvocationHandler(URL endPoint, Map methodMap, Map interfaceMap) {
        this(endPoint, methodMap, interfaceMap, true);
    }

    public AxisInvocationHandler(URL endPoint, Map methodMap) {
        this(endPoint, methodMap, (Map)new DefaultInterfaceMap());
    }

    public AxisInvocationHandler(URL endPoint) {
        this(endPoint, new DefaultMethodMap());
    }

    protected void setBasicAuthentication(URL target) {
        StringTokenizer tok;
        String userInfo = target.getUserInfo();
        if (userInfo != null && (tok = new StringTokenizer(userInfo, ":")).hasMoreTokens()) {
            this.call.setUsername(tok.nextToken());
            if (tok.hasMoreTokens()) {
                this.call.setPassword(tok.nextToken());
            }
        }
    }

    public Object invoke(String serviceName, String methodName, Object[] args) throws RemoteException {
        return this.call.invoke(serviceName, methodName, args);
    }

    public Object invoke(String serviceName, String methodName, Object[] args, Class[] parameters) throws RemoteException {
        return this.invoke(serviceName, methodName, args);
    }

    public Object invoke(Object target, Method method, Object[] args) throws Throwable {
        return this.invoke((String)this.methodToInterface.get(method), (String)this.methodToName.get(method), args, method.getParameterTypes());
    }

    public static Object createAxisService(Class _interface, URL endpoint) {
        return AxisInvocationHandler.createAxisService(_interface, new AxisInvocationHandler(endpoint));
    }

    public static Object createAxisService(Class _interface, URL endpoint, Service service) {
        return AxisInvocationHandler.createAxisService(_interface, new AxisInvocationHandler(endpoint, service, (Map)new DefaultMethodMap(), new DefaultInterfaceMap()));
    }

    public static Object createAxisService(Class _interface, Call call) {
        return AxisInvocationHandler.createAxisService(_interface, new AxisInvocationHandler(call, (Map)new DefaultMethodMap(), (Map)new DefaultInterfaceMap()));
    }

    public static Object createAxisService(Class _interface, AxisInvocationHandler handler) {
        return Proxy.newProxyInstance(_interface.getClassLoader(), new Class[]{_interface}, (InvocationHandler)handler);
    }

    public static class DefaultMethodMap
    extends HashMap {
        public DefaultMethodMap() {
            super(0);
        }

        public Object get(Object key) {
            Object result = super.get(key);
            if (result == null && key instanceof Method) {
                result = ((Method)key).getName();
            }
            return result;
        }
    }

    public static class DefaultInterfaceMap
    extends HashMap {
        public DefaultInterfaceMap() {
            super(0);
        }

        public Object get(Object key) {
            Object result = super.get(key);
            if (result == null && key instanceof Method && (result = super.get(((Method)key).getDeclaringClass())) == null) {
                String sresult = ((Method)key).getDeclaringClass().getName();
                if (sresult.indexOf(".") != -1) {
                    sresult = sresult.substring(sresult.lastIndexOf(".") + 1);
                }
                result = sresult;
            }
            return result;
        }
    }
}

