/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.axis;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.ConfigurationException;
import org.apache.axis.deployment.DeploymentException;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.deployment.wsdd.WSDDTypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.jboss.net.axis.ParameterizableDeserializerFactory;
import org.jboss.net.axis.TypeMapping;
import org.w3c.dom.Element;

public class Deployment
extends WSDDDeployment {
    protected Map service2ClassLoader;
    protected boolean tmrCreated = false;

    public Deployment(Element e) throws WSDDException {
        super(e);
        Element[] elements = this.getChildElements(e, "typeMapping");
        int i = 0;
        while (i < elements.length) {
            TypeMapping mapping = new TypeMapping(elements[i]);
            this.deployTypeMapping(mapping);
            ++i;
        }
    }

    protected synchronized Map getService2ClassLoader() {
        if (this.service2ClassLoader == null) {
            this.service2ClassLoader = new HashMap();
        }
        return this.service2ClassLoader;
    }

    protected void equipTypeMappingWithOptions(TypeMapping typeMapping) throws ConfigurationException {
        DeserializerFactory dser = ((org.apache.axis.encoding.TypeMapping)this.getTypeMappingRegistry().getTypeMapping(typeMapping.getEncodingStyle())).getDeserializer(typeMapping.getQName());
        if (dser instanceof ParameterizableDeserializerFactory) {
            ((ParameterizableDeserializerFactory)dser).setOptions(typeMapping.getParametersTable());
        }
    }

    public void deployService(WSDDService service) {
        service.deployToRegistry((WSDDDeployment)this);
        this.getService2ClassLoader().put(service.getQName(), Thread.currentThread().getContextClassLoader());
    }

    public void deployToRegistry(WSDDDeployment target) throws DeploymentException {
        super.deployToRegistry(target);
        if (target instanceof Deployment) {
            Map targetMap = ((Deployment)target).getService2ClassLoader();
            Iterator myEntries = this.getService2ClassLoader().entrySet().iterator();
            while (myEntries.hasNext()) {
                Map.Entry nextEntry = myEntries.next();
                targetMap.put(nextEntry.getKey(), nextEntry.getValue());
            }
        }
    }

    public ClassLoader getClassLoader(QName serviceName) {
        return (ClassLoader)this.getService2ClassLoader().get(serviceName);
    }

    public void deployTypeMapping(WSDDTypeMapping typeMapping) throws WSDDException {
        super.deployTypeMapping(typeMapping);
        if (typeMapping instanceof TypeMapping) {
            try {
                this.equipTypeMappingWithOptions((TypeMapping)typeMapping);
            }
            catch (ConfigurationException e) {
                throw new WSDDException("Could not equip typemapping with options because of" + (Object)((Object)e));
            }
        }
    }

    public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
        TypeMappingRegistry tmr = super.getTypeMappingRegistry();
        if (!this.tmrCreated) {
            this.tmrCreated = true;
            WSDDTypeMapping[] typeMappings = this.getTypeMappings();
            int count = 0;
            while (count < typeMappings.length) {
                if (typeMappings[count] instanceof TypeMapping) {
                    this.equipTypeMappingWithOptions((TypeMapping)typeMappings[count]);
                }
                ++count;
            }
        }
        return tmr;
    }
}

