/*
 * Decompiled with CFR 0.152.
 */
package org.jboss;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.jboss.system.server.Server;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerLoader;

public class Main {
    private String jaxpLib = "crimson.jar";
    private String jmxLib = "jboss-jmx.jar";
    private String concurrentLib = "concurrent.jar";
    private List extraLibraries = new LinkedList();
    private List extraClasspath = new LinkedList();
    private Properties props = new Properties(System.getProperties());
    static /* synthetic */ Class class$org$jboss$Main;

    public void boot(String[] args) throws Exception {
        File file;
        String homeDir = System.getProperty("jboss.home.dir");
        if (homeDir == null) {
            String path = (class$org$jboss$Main == null ? (class$org$jboss$Main = Main.class$("org.jboss.Main")) : class$org$jboss$Main).getProtectionDomain().getCodeSource().getLocation().getFile();
            file = new File(path).getParentFile().getParentFile();
            homeDir = file.getCanonicalPath();
        }
        this.props.setProperty("jboss.home.dir", homeDir);
        String homeURL = System.getProperty("jboss.home.url");
        if (homeURL == null) {
            file = new File(homeDir);
            homeURL = file.toURL().toString();
        }
        this.props.setProperty("jboss.home.url", homeURL);
        this.processCommandLine(args);
        ServerLoader loader = new ServerLoader(this.props);
        loader.addLibrary(this.jaxpLib);
        loader.addLibrary(this.jmxLib);
        loader.addLibrary(this.concurrentLib);
        Iterator iter = this.extraLibraries.iterator();
        while (iter.hasNext()) {
            loader.addLibrary((String)iter.next());
        }
        Iterator iter2 = this.extraClasspath.iterator();
        while (iter2.hasNext()) {
            loader.addURL((URL)iter2.next());
        }
        ClassLoader parentCL = Thread.currentThread().getContextClassLoader();
        Server server = loader.load(parentCL);
        server.init(this.props);
        ServerConfig config = server.getConfig();
        config.setExitOnShutdown(true);
        server.start();
    }

    /*
     * WARNING - void declaration
     */
    private void processCommandLine(String[] args) throws Exception {
        int code;
        String programName = System.getProperty("program.name", "jboss");
        String sopts = "-:hD:p:n:c:Vj:L:C:P:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("patchdir", 1, null, 112), new LongOpt("netboot", 1, null, 110), new LongOpt("configuration", 1, null, 99), new LongOpt("version", 0, null, 86), new LongOpt("jaxp", 1, null, 106), new LongOpt("library", 1, null, 76), new LongOpt("classpath", 1, null, 67), new LongOpt("properties", 1, null, 80)};
        Getopt getopt = new Getopt(programName, args, sopts, lopts);
        while ((code = getopt.getopt()) != -1) {
            void var6_6;
            switch (var6_6) {
                case 58: 
                case 63: {
                    System.exit(1);
                    break;
                }
                case 1: {
                    System.err.println(programName + ": unused non-option argument: " + getopt.getOptarg());
                    break;
                }
                case 104: {
                    System.out.println("usage: " + programName + " [options]");
                    System.out.println();
                    System.out.println("options:");
                    System.out.println("    -h, --help                    Show this help message");
                    System.out.println("    -V, --version                 Show version information");
                    System.out.println("    --                            Stop processing options");
                    System.out.println("    -D<name>[=<value>]            Set a system property");
                    System.out.println("    -p, --patchdir=<dir>          Set the patch directory; Must be absolute");
                    System.out.println("    -n, --netboot=<url>           Boot from net with the given url as base");
                    System.out.println("    -c, --configuration=<name>    Set the server configuration name");
                    System.out.println("    -j, --jaxp=<type>             Set the JAXP impl type (ie. crimson)");
                    System.out.println("    -L, --library=<filename>      Add an extra library to the loaders classpath");
                    System.out.println("    -C, --classpath=<url>         Add an extra url to the loaders classpath");
                    System.out.println("    -P, --properties=<url>        Load system properties from the given url");
                    System.out.println();
                    System.exit(0);
                    break;
                }
                case 68: {
                    String value;
                    String name;
                    String arg = getopt.getOptarg();
                    int i = arg.indexOf("=");
                    if (i == -1) {
                        name = arg;
                        value = "true";
                    } else {
                        name = arg.substring(0, i);
                        value = arg.substring(i + 1, arg.length());
                    }
                    System.setProperty(name, value);
                    break;
                }
                case 112: {
                    URL url;
                    String arg = getopt.getOptarg();
                    try {
                        url = new URL(arg);
                    }
                    catch (Exception e) {
                        File file = new File(arg);
                        url = file.toURL();
                    }
                    this.props.put("jboss.patch.url", url.toString());
                    break;
                }
                case 110: {
                    String arg = getopt.getOptarg();
                    if (!arg.endsWith("/")) {
                        arg = arg + "/";
                    }
                    this.props.put("jboss.home.url", new URL(arg).toString());
                    break;
                }
                case 99: {
                    String arg = getopt.getOptarg();
                    this.props.put("jboss.server.name", arg);
                    break;
                }
                case 86: {
                    Package jbossPackage = Package.getPackage("org.jboss");
                    System.out.println("JBoss " + jbossPackage.getImplementationVersion());
                    System.out.println();
                    System.out.println("Distributable under LGPL license.");
                    System.out.println("See terms of license at gnu.org.");
                    System.out.println();
                    System.exit(0);
                    break;
                }
                case 106: {
                    String saxFactoryType;
                    String domFactoryType;
                    String arg = getopt.getOptarg().toLowerCase();
                    if (arg.equals("crimson")) {
                        domFactoryType = "org.apache.crimson.jaxp.DocumentBuilderFactoryImpl";
                        saxFactoryType = "org.apache.crimson.jaxp.SAXParserFactoryImpl";
                        this.jaxpLib = "crimson.jar";
                    } else if (arg.equals("xerces")) {
                        domFactoryType = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
                        saxFactoryType = "org.apache.xerces.jaxp.SAXParserFactoryImpl";
                        this.jaxpLib = "xerces.jar";
                    } else {
                        System.err.println("Invalid JAXP type: " + arg + " (Expected 'crimson' or 'xerces')");
                        System.exit(1);
                        break;
                    }
                    System.setProperty("javax.xml.parsers.DocumentBuilderFactory", domFactoryType);
                    System.setProperty("javax.xml.parsers.SAXParserFactory", saxFactoryType);
                    break;
                }
                case 76: {
                    String arg = getopt.getOptarg();
                    this.extraLibraries.add(arg);
                    break;
                }
                case 67: {
                    URL url;
                    String arg = getopt.getOptarg();
                    try {
                        url = new URL(arg);
                    }
                    catch (Exception e) {
                        File file = new File(arg);
                        url = file.toURL();
                    }
                    this.extraClasspath.add(url);
                    break;
                }
                case 80: {
                    URL url;
                    String arg = getopt.getOptarg();
                    try {
                        url = new URL(arg);
                    }
                    catch (Exception e) {
                        File file = new File(arg);
                        url = file.toURL();
                    }
                    Properties props = System.getProperties();
                    props.load(url.openConnection().getInputStream());
                    break;
                }
                default: {
                    throw new Error("unhandled option code: " + (int)var6_6);
                }
            }
        }
    }

    public static void main(final String[] args) throws Exception {
        Runnable worker = new Runnable(){

            public void run() {
                try {
                    Main main = new Main();
                    main.boot(args);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        ThreadGroup threads = new ThreadGroup("jboss");
        new Thread(threads, worker, "main").start();
    }

    public static void systemExit(String[] argv) {
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

