/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.jms.JMSException;
import javax.sql.DataSource;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.server.MessageCache;
import org.jboss.mq.server.MessageReference;

public class MessageLog {
    private static boolean SUPPORTS_OBJECTS = true;
    private final DataSource datasource;
    private final MessageCache messageCache;
    private final String messageTableName;

    MessageLog(MessageCache messageCache, DataSource datasource, String messageTableName) throws JMSException {
        if (messageCache == null) {
            throw new IllegalArgumentException("Need a MessageCache to construct a MessageLog!");
        }
        if (datasource == null) {
            throw new IllegalArgumentException("Need a datasource to construct a MessageLog!");
        }
        this.messageCache = messageCache;
        this.datasource = datasource;
        this.messageTableName = messageTableName;
        try {
            Connection c = datasource.getConnection();
            try {
                ResultSet rs = c.getMetaData().getTables(null, null, this.messageTableName, null);
                if (!rs.next()) {
                    Statement s = c.createStatement();
                    try {
                        s.executeUpdate("create table " + this.messageTableName + " (destination varchar(32), messageblob object, messageid varchar(32))");
                        Object var8_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        s.close();
                        throw throwable;
                    }
                    s.close();
                    {
                    }
                }
                rs.close();
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                c.close();
                throw throwable;
            }
            c.close();
            {
            }
        }
        catch (SQLException e) {
            this.throwJMSException("could not find or set up message table", e);
        }
    }

    public void close() throws JMSException {
    }

    public Map restoreAll() throws JMSException {
        HashMap<String, TreeMap<Long, MessageReference>> unrestoredMessages = new HashMap<String, TreeMap<Long, MessageReference>>();
        Statement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            try {
                con = this.datasource.getConnection();
                try {
                    pstmt = con.prepareStatement("select destination, messageblob, messageid from " + this.messageTableName);
                    try {
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            String dest = rs.getString(1);
                            SpyMessage message = null;
                            if (SUPPORTS_OBJECTS) {
                                message = (SpyMessage)rs.getObject(2);
                            } else {
                                byte[] st = (byte[])rs.getObject(2);
                                ByteArrayInputStream baip = new ByteArrayInputStream(st);
                                ObjectInputStream ois = new ObjectInputStream(baip);
                                message = (SpyMessage)ois.readObject();
                            }
                            message.header.messageId = Long.parseLong(rs.getString(3).trim(), 16);
                            Long msgId = new Long(message.header.messageId);
                            MessageReference mr = this.messageCache.add(message);
                            TreeMap<Long, MessageReference> messageIndex = (TreeMap<Long, MessageReference>)unrestoredMessages.get(dest);
                            if (messageIndex == null) {
                                messageIndex = new TreeMap<Long, MessageReference>();
                                unrestoredMessages.put(dest, messageIndex);
                            }
                            messageIndex.put(msgId, mr);
                        }
                        Object var11_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        rs.close();
                        throw throwable;
                    }
                    rs.close();
                    Object var13_15 = null;
                }
                catch (Throwable throwable) {
                    Object var13_16 = null;
                    pstmt.close();
                    throw throwable;
                }
                pstmt.close();
                Object var15_18 = null;
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                con.close();
                throw throwable;
            }
            con.close();
            {
            }
        }
        catch (SQLException e) {
            this.throwJMSException("SQL error while rebuilding the tranaction log.", e);
        }
        catch (Exception e) {
            this.throwJMSException("Could not rebuild the queue from the queue's tranaction log.", e);
        }
        return unrestoredMessages;
    }

    private void throwJMSException(String message, Exception e) throws JMSException {
        SpyJMSException newE = new SpyJMSException(message);
        newE.setLinkedException(e);
        throw newE;
    }

    /*
     * Loose catch block
     */
    public void add(SpyMessage message, Tx transactionId) throws JMSException {
        block16: {
            PreparedStatement pstmt = null;
            Connection con = null;
            con = this.datasource.getConnection();
            pstmt = con.prepareStatement("insert into " + this.messageTableName + " (messageid, destination, messageblob) VALUES(?,?,?)");
            String hexString = null;
            hexString = message.header.messageId <= 0L ? "-" + Long.toHexString(-1L * message.header.messageId) : Long.toHexString(message.header.messageId);
            pstmt.setString(1, hexString);
            pstmt.setString(2, ((SpyDestination)message.getJMSDestination()).getName());
            if (SUPPORTS_OBJECTS) {
                pstmt.setObject(3, message);
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(message);
                byte[] messageAsBytes = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(messageAsBytes);
                pstmt.setBinaryStream(3, (InputStream)bais, messageAsBytes.length);
            }
            pstmt.executeUpdate();
            pstmt.close();
            Object var11_12 = null;
            try {
                if (con != null) {
                    con.close();
                }
                break block16;
            }
            catch (SQLException e2) {
                this.throwJMSException("Could not close the database.", e2);
            }
            break block16;
            {
                catch (IOException e) {
                    this.throwJMSException("Could serialize the message.", e);
                    Object var11_13 = null;
                    try {
                        if (con != null) {
                            con.close();
                        }
                        break block16;
                    }
                    catch (SQLException e2) {
                        this.throwJMSException("Could not close the database.", e2);
                    }
                    break block16;
                }
                catch (SQLException e) {
                    this.throwJMSException("Could not write message to the database.", e);
                    Object var11_14 = null;
                    try {
                        if (con != null) {
                            con.close();
                        }
                        break block16;
                    }
                    catch (SQLException e2) {
                        this.throwJMSException("Could not close the database.", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e2) {
                    this.throwJMSException("Could not close the database.", e2);
                }
                throw throwable;
            }
        }
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    /*
     * Loose catch block
     */
    public void remove(SpyMessage message, Tx transactionId) throws JMSException {
        block14: {
            Statement pstmt = null;
            Connection con = null;
            con = this.datasource.getConnection();
            pstmt = con.prepareStatement("delete from " + this.messageTableName + " where messageid = ? and destination = ?");
            String hexString = null;
            hexString = message.header.messageId <= 0L ? "-" + Long.toHexString(-1L * message.header.messageId) : Long.toHexString(message.header.messageId);
            pstmt.setString(1, hexString);
            pstmt.setString(2, ((SpyDestination)message.getJMSDestination()).getName().trim());
            pstmt.execute();
            Object var7_7 = null;
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                if (con != null) {
                    con.close();
                }
                break block14;
            }
            catch (SQLException e2) {
                this.throwJMSException("Could not close the database.", e2);
            }
            break block14;
            {
                catch (SQLException e) {
                    this.throwJMSException("Could not remove the message.", e);
                    Object var7_8 = null;
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                        if (con != null) {
                            con.close();
                        }
                        break block14;
                    }
                    catch (SQLException e2) {
                        this.throwJMSException("Could not close the database.", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e2) {
                    this.throwJMSException("Could not close the database.", e2);
                }
                throw throwable;
            }
        }
    }
}

