/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.TreeSet;
import javax.jms.JMSException;
import javax.sql.DataSource;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.pm.Tx;

public class TxLog {
    protected long nextTransactionId = Long.MIN_VALUE;
    private final DataSource ds;
    private String transactionTableName;

    public TxLog(DataSource ds, String transactionTableName) throws JMSException {
        if (ds == null) {
            throw new IllegalArgumentException("Must supply a datasource to construct a TxLog");
        }
        this.ds = ds;
        this.transactionTableName = transactionTableName;
        try {
            Connection c = ds.getConnection();
            try {
                ResultSet rs = c.getMetaData().getTables(null, null, this.transactionTableName, null);
                if (!rs.next()) {
                    Statement s = c.createStatement();
                    try {
                        s.executeUpdate("create table " + this.transactionTableName + " (id varchar(32) primary key)");
                        Object var7_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        s.close();
                        throw throwable;
                    }
                    s.close();
                    {
                    }
                }
                rs.close();
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                c.close();
                throw throwable;
            }
            c.close();
            {
            }
        }
        catch (SQLException e) {
            this.throwJMSException("could not find or set up transaction table", e);
        }
    }

    public synchronized TreeSet restore() throws JMSException {
        TreeSet<Long> items = new TreeSet<Long>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                con = this.getConnection();
                try {
                    stmt = con.prepareStatement("select id from " + this.transactionTableName);
                    try {
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            long id = Long.parseLong(rs.getString(1).trim(), 16);
                            items.add(new Long(id));
                        }
                        Object var8_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        rs.close();
                        throw throwable;
                    }
                    rs.close();
                    Object var10_10 = null;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    stmt.close();
                    throw throwable;
                }
                stmt.close();
                Object var12_13 = null;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                con.close();
                throw throwable;
            }
            con.close();
            {
            }
        }
        catch (SQLException e) {
            this.throwJMSException("Could not write transaction log on commit.", e);
        }
        return items;
    }

    public synchronized void commitTx(Tx txId) throws JMSException {
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            stmt = con.prepareStatement("delete from " + this.transactionTableName + " where id = ?");
            String hexString = null;
            long id = txId.longValue();
            hexString = id <= 0L ? "-" + Long.toHexString(-1L * id) : Long.toHexString(id);
            stmt.setString(1, hexString);
            stmt.executeUpdate();
            con.commit();
        }
        catch (SQLException e) {
            this.throwJMSException("Could not write transaction log on commit.", e);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            this.throwJMSException("Could not close database connection in transaction log (commitTx)", e);
        }
    }

    public synchronized Tx createTx() throws JMSException {
        Tx id = new Tx(this.nextTransactionId++);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            stmt = con.prepareStatement("insert into " + this.transactionTableName + " values(?)");
            String hexString = null;
            long lId = id.longValue();
            hexString = lId <= 0L ? "-" + Long.toHexString(-1L * lId) : Long.toHexString(lId);
            stmt.setString(1, hexString);
            stmt.executeUpdate();
            con.commit();
        }
        catch (SQLException e) {
            this.throwJMSException("Could not write transaction log on commit.", e);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            this.throwJMSException("Could not close database connection in transaction log (createTx).", e);
        }
        return id;
    }

    public synchronized void rollbackTx(Tx txId) throws JMSException {
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            stmt = con.prepareStatement("delete from " + this.transactionTableName + " where id = ?");
            String hexString = null;
            long id = txId.longValue();
            hexString = id <= 0L ? "-" + Long.toHexString(-1L * id) : Long.toHexString(id);
            stmt.setString(1, hexString);
            stmt.executeUpdate();
            con.commit();
        }
        catch (SQLException e) {
            this.throwJMSException("Could not write transaction log on commit.", e);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            this.throwJMSException("Could not close database connection in transaction log (rollbackTx)", e);
        }
    }

    private final Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    private void throwJMSException(String message, Exception e) throws JMSException {
        SpyJMSException newE = new SpyJMSException(message);
        newE.setLinkedException(e);
        throw newE;
    }
}

