/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.MessagePool;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.Subscription;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.selectors.Selector;
import org.jboss.mq.server.BasicQueue;
import org.jboss.mq.server.ClientConsumer;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.MessageReference;
import org.jboss.mq.server.PersistentQueue;
import org.jboss.mq.server.RoutedMessage;

public class BasicQueue {
    SortedSet messages = new TreeSet();
    JMSDestinationManager server;
    HashSet receivers = new HashSet();
    Subscription exclusiveSubscription;
    HashMap unacknowledgedMessages = new HashMap();
    HashMap removedSubscribers = new HashMap();
    static Logger cat;
    static /* synthetic */ Class class$org$jboss$mq$server$BasicQueue;

    public BasicQueue(JMSDestinationManager server, String description) throws JMSException {
        this(server, description, null);
    }

    public int getQueueDepth() {
        return this.messages.size();
    }

    public BasicQueue(JMSDestinationManager server, String description, Subscription exclusiveSubscription) throws JMSException {
        this.server = server;
        this.exclusiveSubscription = exclusiveSubscription;
        cat = Logger.getLogger((String)((class$org$jboss$mq$server$BasicQueue == null ? (class$org$jboss$mq$server$BasicQueue = BasicQueue.class$("org.jboss.mq.server.BasicQueue")) : class$org$jboss$mq$server$BasicQueue).getName() + "." + description));
    }

    public void clientConsumerStopped(ClientConsumer clientConsumer) {
        HashSet hashSet = this.receivers;
        synchronized (hashSet) {
            Iterator it = this.receivers.iterator();
            while (it.hasNext()) {
                Subscription sub = (Subscription)it.next();
                if (!sub.clientConsumer.equals(clientConsumer)) continue;
                clientConsumer.addBlockedSubscription(sub);
                it.remove();
            }
        }
    }

    public void restoreMessage(MessageReference mes) {
        this.internalAddMessage(mes);
    }

    public SpyMessage[] browse(String selector) throws JMSException {
        if (selector == null) {
            SpyMessage[] list;
            SortedSet sortedSet = this.messages;
            synchronized (sortedSet) {
                list = new SpyMessage[this.messages.size()];
                Iterator iter = this.messages.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    list[i] = ((MessageReference)iter.next()).getMessage();
                    ++i;
                }
            }
            return list;
        }
        Selector s = new Selector(selector);
        LinkedList<SpyMessage> selection = new LinkedList<SpyMessage>();
        SortedSet sortedSet = this.messages;
        synchronized (sortedSet) {
            Iterator i = this.messages.iterator();
            while (i.hasNext()) {
                MessageReference m = (MessageReference)i.next();
                if (!s.test(m.getHeaders())) continue;
                selection.add(m.getMessage());
            }
        }
        SpyMessage[] list = new SpyMessage[selection.size()];
        list = selection.toArray(list);
        return list;
    }

    public void addReceiver(Subscription sub) {
        SortedSet sortedSet = this.messages;
        synchronized (sortedSet) {
            if (this.messages.size() != 0) {
                Iterator it = this.messages.iterator();
                while (it.hasNext()) {
                    MessageReference message = (MessageReference)it.next();
                    try {
                        if (!sub.accepts(message.getHeaders())) continue;
                        this.queueMessageForSending(sub, message);
                        it.remove();
                        return;
                    }
                    catch (JMSException ignore) {
                        cat.info((Object)"Caught unusual exception in addToReceivers.", (Throwable)ignore);
                    }
                }
            }
        }
        this.addToReceivers(sub);
    }

    public void removeReceiver(Subscription sub) {
        HashSet hashSet = this.receivers;
        synchronized (hashSet) {
            this.receivers.remove(sub);
        }
    }

    public void removeSubscriber(Subscription sub) {
        this.removeReceiver(sub);
        if (this.hasUnackedMessages(sub.subscriptionId)) {
            HashMap hashMap = this.removedSubscribers;
            synchronized (hashMap) {
                this.removedSubscribers.put(new Integer(sub.subscriptionId), sub);
            }
        } else {
            ((ClientConsumer)sub.clientConsumer).removeRemovedSubscription(sub.subscriptionId);
        }
    }

    public boolean isInUse() {
        HashSet hashSet = this.receivers;
        synchronized (hashSet) {
            boolean bl = this.receivers.size() > 0;
            return bl;
        }
    }

    public SpyMessage receive(Subscription sub, boolean wait) throws JMSException {
        MessageReference messageRef = null;
        HashSet hashSet = this.receivers;
        synchronized (hashSet) {
            if (sub.getSelector() == null && !sub.noLocal) {
                SortedSet sortedSet = this.messages;
                synchronized (sortedSet) {
                    if (this.messages.size() != 0) {
                        messageRef = (MessageReference)this.messages.first();
                        this.messages.remove(messageRef);
                    }
                }
            }
            SortedSet sortedSet = this.messages;
            synchronized (sortedSet) {
                Iterator i = this.messages.iterator();
                while (i.hasNext()) {
                    MessageReference mr = (MessageReference)i.next();
                    if (!sub.accepts(mr.getHeaders())) continue;
                    messageRef = mr;
                    i.remove();
                    break;
                }
            }
            if (messageRef == null) {
                if (wait) {
                    this.addToReceivers(sub);
                }
            } else {
                this.setupMessageAcknowledgement(sub, messageRef);
            }
        }
        if (messageRef == null) {
            return null;
        }
        return messageRef.getMessage();
    }

    public void removeAllMessages() throws JMSException {
        HashMap hashMap = this.unacknowledgedMessages;
        synchronized (hashMap) {
            Iterator i = ((HashMap)this.unacknowledgedMessages.clone()).keySet().iterator();
            while (i.hasNext()) {
                AcknowledgementRequest item = (AcknowledgementRequest)i.next();
                try {
                    this.acknowledge(item, null);
                }
                catch (JMSException ignore) {
                    // empty catch block
                }
            }
        }
        SortedSet sortedSet = this.messages;
        synchronized (sortedSet) {
            Iterator i = this.messages.iterator();
            while (i.hasNext()) {
                MessageReference message = (MessageReference)i.next();
                if (this instanceof PersistentQueue && message.getHeaders().jmsDeliveryMode == 2) {
                    try {
                        this.server.getPersistenceManager().remove(message, null);
                    }
                    catch (JMSException e) {
                        cat.warn((Object)("Message removed from queue, but not from the persistent store: " + message.getMessage()), (Throwable)e);
                    }
                }
                this.server.getMessageCache().remove(message);
                MessagePool.releaseMessage(message.hardReference);
            }
        }
    }

    public void acknowledge(AcknowledgementRequest item, Tx txId) throws JMSException {
        class RestoreMessageTask
        implements Runnable {
            MessageReference message;
            int subscriptionId;
            private final /* synthetic */ BasicQueue this$0;

            RestoreMessageTask(BasicQueue this$0, MessageReference m, int subscriptionId) {
                this.this$0 = this$0;
                this.message = m;
                this.subscriptionId = subscriptionId;
            }

            public void run() {
                if (BasicQueue.cat.isTraceEnabled()) {
                    BasicQueue.cat.trace((Object)("Restoring message: " + this.message));
                }
                this.this$0.restoreMessage(this.message);
            }
        }
        MessageReference m;
        HashMap hashMap = this.unacknowledgedMessages;
        synchronized (hashMap) {
            m = (MessageReference)this.unacknowledgedMessages.remove(item);
        }
        this.checkRemovedSubscribers(item.subscriberId);
        if (m == null) {
            return;
        }
        if (!item.isAck) {
            SpyMessage spyMessage = m.getMessage();
            spyMessage.setJMSRedelivered(true);
            m.invalidate();
            RestoreMessageTask task = new RestoreMessageTask(this, m, item.subscriberId);
            this.server.getPersistenceManager().getTxManager().addPostCommitTask(txId, task);
        } else {
            if (this instanceof PersistentQueue && m.getHeaders().jmsDeliveryMode == 2) {
                this.server.getPersistenceManager().remove(m, txId);
            }
            Runnable task = new RestoreMessageTask(this, m, item.subscriberId);
            this.server.getPersistenceManager().getTxManager().addPostRollbackTask(txId, task);
            class RemoveMessageTask
            implements Runnable {
                MessageReference message;
                private final /* synthetic */ BasicQueue this$0;

                RemoveMessageTask(BasicQueue this$0, MessageReference m) {
                    this.this$0 = this$0;
                    this.message = m;
                }

                public void run() {
                    try {
                        this.this$0.server.getMessageCache().remove(this.message);
                        MessagePool.releaseMessage(this.message.hardReference);
                    }
                    catch (JMSException e) {
                        BasicQueue.cat.error((Object)"Could not remove an acknowleged message from the message cache: ", (Throwable)e);
                    }
                }
            }
            task = new RemoveMessageTask(this, m);
            this.server.getPersistenceManager().getTxManager().addPostCommitTask(txId, task);
        }
    }

    public void addMessage(MessageReference mes, Tx txId) throws JMSException {
        class AddMessagePostCommitTask
        implements Runnable {
            MessageReference message;
            private final /* synthetic */ BasicQueue this$0;

            AddMessagePostCommitTask(BasicQueue this$0, MessageReference m) {
                this.this$0 = this$0;
                this.message = m;
            }

            public void run() {
                BasicQueue.access$000(this.this$0, this.message);
            }
        }
        AddMessagePostCommitTask task = new AddMessagePostCommitTask(this, mes);
        this.server.getPersistenceManager().getTxManager().addPostCommitTask(txId, task);
    }

    protected void setupMessageAcknowledgement(Subscription sub, MessageReference messageRef) throws JMSException {
        SpyMessage message = messageRef.getMessage();
        AcknowledgementRequest ack = new AcknowledgementRequest();
        ack.destination = message.getJMSDestination();
        ack.messageID = message.getJMSMessageID();
        ack.subscriberId = sub.subscriptionId;
        ack.isAck = false;
        HashMap hashMap = this.unacknowledgedMessages;
        synchronized (hashMap) {
            this.unacknowledgedMessages.put(ack, messageRef);
        }
    }

    protected void queueMessageForSending(Subscription sub, MessageReference message) throws JMSException {
        this.setupMessageAcknowledgement(sub, message);
        RoutedMessage r = new RoutedMessage();
        r.message = message;
        r.subscriptionId = new Integer(sub.subscriptionId);
        ((ClientConsumer)sub.clientConsumer).queueMessageForSending(r);
    }

    protected void addToReceivers(Subscription sub) {
        HashSet hashSet = this.receivers;
        synchronized (hashSet) {
            this.receivers.add(sub);
        }
    }

    protected boolean hasUnackedMessages(int sub) {
        HashMap hashMap = this.unacknowledgedMessages;
        synchronized (hashMap) {
            Iterator it = this.unacknowledgedMessages.keySet().iterator();
            while (it.hasNext()) {
                if (((AcknowledgementRequest)it.next()).subscriberId != sub) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    protected void checkRemovedSubscribers(int subId) {
        Integer id = new Integer(subId);
        HashMap hashMap = this.removedSubscribers;
        synchronized (hashMap) {
            if (this.removedSubscribers.containsKey(id) && !this.hasUnackedMessages(subId)) {
                Subscription sub = (Subscription)this.removedSubscribers.remove(id);
                ((ClientConsumer)sub.clientConsumer).removeRemovedSubscription(subId);
            }
        }
    }

    private void internalAddMessage(MessageReference message) {
        try {
            if (this.exclusiveSubscription != null && !this.exclusiveSubscription.accepts(message.getHeaders())) {
                return;
            }
            HashSet hashSet = this.receivers;
            synchronized (hashSet) {
                if (!this.receivers.isEmpty()) {
                    Iterator it = this.receivers.iterator();
                    while (it.hasNext()) {
                        Subscription sub = (Subscription)it.next();
                        if (!sub.accepts(message.getHeaders())) continue;
                        this.queueMessageForSending(sub, message);
                        it.remove();
                        return;
                    }
                }
            }
            SortedSet sortedSet = this.messages;
            synchronized (sortedSet) {
                this.messages.add(message);
            }
        }
        catch (JMSException e) {
            cat.error((Object)"Caught unusual exception in internalAddMessage.", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$000(BasicQueue x0, MessageReference x1) {
        x0.internalAddMessage(x1);
    }
}

