/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.Subscription;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.server.ClientConsumer;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.MessageReference;

public abstract class JMSDestination {
    SpyDestination destination;
    ClientConsumer temporaryDestination;
    JMSDestinationManager server;
    long messageIdCounter = 0L;
    Logger cat;

    JMSDestination(SpyDestination dest, ClientConsumer temporary, JMSDestinationManager server) throws JMSException {
        this.cat = Logger.getLogger((String)(this.getClass().getName() + ":" + dest));
        this.destination = dest;
        this.temporaryDestination = temporary;
        this.server = server;
    }

    public SpyDestination getSpyDestination() {
        return this.destination;
    }

    public abstract void addSubscriber(Subscription var1) throws JMSException;

    public abstract void removeSubscriber(Subscription var1) throws JMSException;

    public abstract SpyMessage receive(Subscription var1, boolean var2) throws JMSException;

    public abstract void addReceiver(Subscription var1);

    public abstract void removeReceiver(Subscription var1);

    public abstract void restoreMessage(MessageReference var1);

    public abstract void clientConsumerStopped(ClientConsumer var1);

    public abstract boolean isInUse();

    public abstract void close() throws JMSException;

    public abstract void removeAllMessages() throws JMSException;

    public abstract void acknowledge(AcknowledgementRequest var1, Subscription var2, Tx var3) throws JMSException;

    public abstract void addMessage(SpyMessage var1, Tx var2) throws JMSException;
}

