/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TransactionRolledBackException;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyQueue;
import org.jboss.mq.SpyTemporaryQueue;
import org.jboss.mq.SpyTemporaryTopic;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.pm.PersistenceManager;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.TxManager;
import org.jboss.mq.server.ClientConsumer;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.JMSQueue;
import org.jboss.mq.server.JMSServerInterceptorSupport;
import org.jboss.mq.server.JMSTopic;
import org.jboss.mq.server.MessageCache;
import org.jboss.mq.sm.StateManager;

public class JMSDestinationManager
extends JMSServerInterceptorSupport {
    static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$server$JMSDestinationManager == null ? (class$org$jboss$mq$server$JMSDestinationManager = JMSDestinationManager.class$("org.jboss.mq.server.JMSDestinationManager")) : class$org$jboss$mq$server$JMSDestinationManager));
    public static final String JBOSS_VESION = "JBossMQ ver. 0.9b";
    public HashMap destinations = new HashMap();
    public ThreadGroup threadGroup = new ThreadGroup("JBossMQ Server Threads");
    HashMap clientConsumers = new HashMap();
    private int lastID = 1;
    private int lastTemporaryTopic = 1;
    private int lastTemporaryQueue = 1;
    private StateManager stateManager;
    private PersistenceManager persistenceManager;
    private MessageCache messageCache;
    private Object stateLock = new Object();
    private Object idLock = new Object();
    private boolean alive = true;
    private boolean stopped = true;
    static /* synthetic */ Class class$org$jboss$mq$server$JMSDestinationManager;

    public void setEnabled(ConnectionToken dc, boolean enabled) throws JMSException {
        ClientConsumer ClientConsumer2 = this.getClientConsumer(dc);
        ClientConsumer2.setEnabled(enabled);
    }

    public void setStateManager(StateManager newStateManager) {
        this.stateManager = newStateManager;
    }

    public void setPersistenceManager(PersistenceManager newPersistenceManager) {
        this.persistenceManager = newPersistenceManager;
    }

    public boolean isStopped() {
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = this.stopped;
            return bl;
        }
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public String getID() {
        String ID = null;
        while (true) {
            try {
                Object object = this.idLock;
                synchronized (object) {
                    ID = "ID:" + new Integer(this.lastID++).toString();
                }
                this.stateManager.addLoggedOnClientId(ID);
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        return ID;
    }

    public synchronized TemporaryTopic getTemporaryTopic(ConnectionToken dc) throws JMSException {
        SpyTemporaryTopic topic = new SpyTemporaryTopic("JMS_TT" + new Integer(this.lastTemporaryTopic++).toString(), dc);
        ClientConsumer ClientConsumer2 = this.getClientConsumer(dc);
        HashMap hashMap = this.destinations;
        synchronized (hashMap) {
            JMSTopic queue = new JMSTopic(topic, ClientConsumer2, this);
            HashMap newMap = (HashMap)this.destinations.clone();
            newMap.put(topic, queue);
            this.destinations = newMap;
        }
        return topic;
    }

    public synchronized TemporaryQueue getTemporaryQueue(ConnectionToken dc) throws JMSException {
        SpyTemporaryQueue newQueue = new SpyTemporaryQueue("JMS_TQ" + new Integer(this.lastTemporaryQueue++).toString(), dc);
        ClientConsumer ClientConsumer2 = this.getClientConsumer(dc);
        HashMap hashMap = this.destinations;
        synchronized (hashMap) {
            JMSQueue queue = new JMSQueue(newQueue, ClientConsumer2, this);
            HashMap newMap = (HashMap)this.destinations.clone();
            newMap.put(newQueue, queue);
            this.destinations = newMap;
        }
        return newQueue;
    }

    public ClientConsumer getClientConsumer(ConnectionToken dc) throws JMSException {
        ClientConsumer cq = (ClientConsumer)this.clientConsumers.get(dc);
        if (cq == null) {
            cq = new ClientConsumer(this, dc);
            this.clientConsumers.put(dc, cq);
        }
        return cq;
    }

    public JMSDestination getJMSDestination(SpyDestination dest) {
        return (JMSDestination)this.destinations.get(dest);
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public void startServer() {
        Object object = this.stateLock;
        synchronized (object) {
            this.stopped = false;
        }
    }

    public void stopServer() {
        Object object = this.stateLock;
        synchronized (object) {
            this.stopped = true;
            this.alive = false;
        }
    }

    public void checkID(String ID) throws JMSException {
        if (ID != null && ID.startsWith("ID")) {
            throw new InvalidClientIDException("clientID is not a valid ID: " + ID);
        }
        this.stateManager.addLoggedOnClientId(ID);
    }

    public void addMessage(ConnectionToken dc, SpyMessage val) throws JMSException {
        this.addMessage(dc, val, null);
    }

    public void addMessage(ConnectionToken dc, SpyMessage val, Tx txId) throws JMSException {
        JMSDestination queue = (JMSDestination)this.destinations.get(val.getJMSDestination());
        if (queue == null) {
            throw new JMSException("This destination does not exist !");
        }
        val.setReadOnlyMode();
        queue.addMessage(val, txId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void transact(ConnectionToken dc, TransactionRequest t) throws JMSException {
        TxManager txManager = this.persistenceManager.getTxManager();
        if (t.requestType == 0) {
            Tx txId = txManager.createTx();
            try {
                int i;
                if (t.messages != null) {
                    i = 0;
                    while (i < t.messages.length) {
                        this.addMessage(dc, t.messages[i], txId);
                        ++i;
                    }
                }
                if (t.acks != null) {
                    i = 0;
                    while (i < t.acks.length) {
                        this.acknowledge(dc, t.acks[i], txId);
                        ++i;
                    }
                }
                txManager.commitTx(txId);
                return;
            }
            catch (JMSException e) {
                log.debug((Object)"Exception occured, rolling back transaction: ", (Throwable)e);
                txManager.rollbackTx(txId);
                TransactionRolledBackException newE = new TransactionRolledBackException("Transaction was rolled back.");
                newE.setLinkedException((Exception)((Object)e));
                throw newE;
            }
        } else if (t.requestType == 1) {
            Tx txId = txManager.createTx(dc, t.xid);
            try {
                int i;
                if (t.messages != null) {
                    i = 0;
                    while (i < t.messages.length) {
                        this.addMessage(dc, t.messages[i], txId);
                        ++i;
                    }
                }
                if (t.acks == null) return;
                i = 0;
                while (i < t.acks.length) {
                    this.acknowledge(dc, t.acks[i], txId);
                    ++i;
                }
                return;
            }
            catch (JMSException e) {
                txManager.rollbackTx(txId);
                TransactionRolledBackException newE = new TransactionRolledBackException("Transaction was rolled back.");
                newE.setLinkedException((Exception)((Object)e));
                throw newE;
            }
        } else if (t.requestType == 3) {
            Tx txId = txManager.getPrepared(dc, t.xid);
            txManager.rollbackTx(txId);
            return;
        } else {
            if (t.requestType != 2) return;
            Tx txId = txManager.getPrepared(dc, t.xid);
            txManager.commitTx(txId);
        }
    }

    public void acknowledge(ConnectionToken dc, AcknowledgementRequest item) throws JMSException {
        this.acknowledge(dc, item, null);
    }

    public void acknowledge(ConnectionToken dc, AcknowledgementRequest item, Tx txId) throws JMSException {
        ClientConsumer cc = this.getClientConsumer(dc);
        cc.acknowledge(item, txId);
    }

    public synchronized void connectionClosing(ConnectionToken dc) throws JMSException {
        if (dc == null) {
            return;
        }
        ClientConsumer cq = (ClientConsumer)this.clientConsumers.remove(dc);
        if (cq != null) {
            cq.close();
        }
        if (dc.getClientID() != null) {
            this.stateManager.removeLoggedOnClientId(dc.getClientID());
        }
        HashMap hashMap = this.destinations;
        synchronized (hashMap) {
            Iterator i = this.destinations.values().iterator();
            while (i.hasNext()) {
                JMSDestination sq = (JMSDestination)i.next();
                ClientConsumer cc = sq.temporaryDestination;
                if (cc == null || !dc.equals(cc.connectionToken)) continue;
                i.remove();
            }
        }
        try {
            if (dc.clientIL != null) {
                dc.clientIL.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void connectionFailure(ConnectionToken dc) throws JMSException {
        log.error((Object)("The connection to client " + dc.getClientID() + " failed."));
        this.connectionClosing(dc);
    }

    public void subscribe(ConnectionToken dc, Subscription sub) throws JMSException {
        ClientConsumer clientConsumer = this.getClientConsumer(dc);
        clientConsumer.addSubscription(sub);
    }

    public void unsubscribe(ConnectionToken dc, int subscriptionId) throws JMSException {
        ClientConsumer clientConsumer = this.getClientConsumer(dc);
        clientConsumer.removeSubscription(subscriptionId);
    }

    public void destroySubscription(ConnectionToken dc, DurableSubscriptionID id) throws JMSException {
        this.getStateManager().setDurableSubscription(this, id, null);
    }

    public SpyMessage[] browse(ConnectionToken dc, Destination dest, String selector) throws JMSException {
        JMSDestination queue = (JMSDestination)this.destinations.get(dest);
        if (queue == null) {
            throw new JMSException("That destination does not exist");
        }
        if (!(queue instanceof JMSQueue)) {
            throw new JMSException("That destination is not a queue");
        }
        return ((JMSQueue)queue).browse(selector);
    }

    public SpyMessage receive(ConnectionToken dc, int subscriberId, long wait) throws JMSException {
        ClientConsumer clientConsumer = this.getClientConsumer(dc);
        return clientConsumer.receive(subscriberId, wait);
    }

    public synchronized Queue createQueue(ConnectionToken dc, String name) throws JMSException {
        SpyQueue newQueue = new SpyQueue(name);
        if (!this.destinations.containsKey(newQueue)) {
            throw new JMSException("This destination does not exist !");
        }
        return newQueue;
    }

    public synchronized Topic createTopic(ConnectionToken dc, String name) throws JMSException {
        SpyTopic newTopic = new SpyTopic(name);
        if (!this.destinations.containsKey(newTopic)) {
            throw new JMSException("This destination does not exist !");
        }
        return newTopic;
    }

    public synchronized void deleteTemporaryDestination(ConnectionToken dc, SpyDestination dest) {
        HashMap hashMap = this.destinations;
        synchronized (hashMap) {
            HashMap newMap = (HashMap)this.destinations.clone();
            newMap.remove(dest);
            this.destinations = newMap;
        }
    }

    public String checkUser(String userName, String password) throws JMSException {
        return this.stateManager.checkUser(userName, password);
    }

    public String authenticate(String id, String password) throws JMSException {
        return null;
    }

    public void addDestination(JMSDestination destination) throws JMSException {
        if (this.destinations.containsKey(destination.getSpyDestination())) {
            throw new JMSException("This destination has allready been added to the server!");
        }
        HashMap hashMap = this.destinations;
        synchronized (hashMap) {
            HashMap newMap = (HashMap)this.destinations.clone();
            newMap.put(destination.getSpyDestination(), destination);
            this.destinations = newMap;
        }
        if (destination instanceof JMSTopic) {
            Collection durableSubs = this.getStateManager().getDurableSubscriptionIdsForTopic((SpyTopic)destination.getSpyDestination());
            Iterator i = durableSubs.iterator();
            while (i.hasNext()) {
                DurableSubscriptionID sub = (DurableSubscriptionID)i.next();
                log.debug((Object)("creating the durable subscription for :" + sub));
                ((JMSTopic)destination).createDurableSubscription(sub);
            }
        } else {
            this.getPersistenceManager().restoreQueue(destination, destination.getSpyDestination());
        }
    }

    public void closeDestination(SpyDestination dest) throws JMSException {
        JMSDestination destination = (JMSDestination)this.destinations.get(dest);
        if (destination == null) {
            throw new JMSException("This destination is not open!");
        }
        HashMap hashMap = this.destinations;
        synchronized (hashMap) {
            if (destination.isInUse()) {
                throw new JMSException("The destination is being used.");
            }
            HashMap newMap = (HashMap)this.destinations.clone();
            newMap.remove(dest);
            this.destinations = newMap;
        }
        destination.close();
    }

    public String toString() {
        return JBOSS_VESION;
    }

    public synchronized void ping(ConnectionToken dc, long clientTime) throws JMSException {
        try {
            dc.clientIL.pong(System.currentTimeMillis());
        }
        catch (Exception e) {
            throw new SpyJMSException("Could not pong", e);
        }
    }

    public MessageCache getMessageCache() {
        return this.getPersistenceManager().getMessageCacheInstance();
    }

    public SpyTopic getDurableTopic(DurableSubscriptionID sub) throws JMSException {
        return this.getStateManager().getDurableTopic(sub);
    }

    public Subscription getSubscription(ConnectionToken dc, int subscriberId) throws JMSException {
        ClientConsumer clientConsumer = this.getClientConsumer(dc);
        return clientConsumer.getSubscription(subscriberId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

