/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.JMSException;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.Subscription;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.selectors.Selector;
import org.jboss.mq.server.BasicQueue;
import org.jboss.mq.server.ClientConsumer;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.JMSTopic;
import org.jboss.mq.server.MessageReference;
import org.jboss.mq.server.PersistentQueue;

public class JMSTopic
extends JMSDestination {
    HashMap durQueues = new HashMap();
    HashMap tempQueues = new HashMap();

    public JMSTopic(SpyDestination dest, ClientConsumer temporary, JMSDestinationManager server) throws JMSException {
        super(dest, temporary, server);
    }

    public void clientConsumerStopped(ClientConsumer clientConsumer) {
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            Iterator iter = this.durQueues.values().iterator();
            while (iter.hasNext()) {
                ((BasicQueue)iter.next()).clientConsumerStopped(clientConsumer);
            }
        }
        HashMap hashMap2 = this.tempQueues;
        synchronized (hashMap2) {
            Iterator iter = this.tempQueues.values().iterator();
            while (iter.hasNext()) {
                ((BasicQueue)iter.next()).clientConsumerStopped(clientConsumer);
            }
        }
    }

    public void addSubscriber(Subscription sub) throws JMSException {
        SpyTopic topic = (SpyTopic)sub.destination;
        DurableSubscriptionID id = topic.getDurableSubscriptionID();
        if (id == null) {
            BasicQueue q = new BasicQueue(this.server, this.destination.toString() + "." + sub.connectionToken.getClientID(), sub);
            HashMap hashMap = this.tempQueues;
            synchronized (hashMap) {
                this.tempQueues.put(sub, q);
            }
        }
        PersistentQueue q = null;
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            q = (PersistentQueue)this.durQueues.get(id);
        }
        if (q == null || !q.destination.equals(topic)) {
            this.server.getStateManager().setDurableSubscription(this.server, id, topic);
        }
    }

    public void removeSubscriber(Subscription sub) throws JMSException {
        BasicQueue queue = null;
        SpyTopic topic = (SpyTopic)sub.destination;
        DurableSubscriptionID id = topic.getDurableSubscriptionID();
        if (id == null) {
            HashMap hashMap = this.tempQueues;
            synchronized (hashMap) {
                queue = (BasicQueue)this.tempQueues.get(sub);
            }
        }
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            queue = (BasicQueue)this.durQueues.get(id);
        }
        if (queue == null) {
            ((ClientConsumer)sub.clientConsumer).removeRemovedSubscription(sub.subscriptionId);
        } else {
            queue.removeSubscriber(sub);
        }
    }

    void cleanupSubscription(Subscription sub) {
        HashMap hashMap = this.tempQueues;
        synchronized (hashMap) {
            this.tempQueues.remove(sub);
        }
    }

    public void addReceiver(Subscription sub) {
        this.getQueue(sub).addReceiver(sub);
    }

    public void removeReceiver(Subscription sub) {
        this.getQueue(sub).removeReceiver(sub);
    }

    public void restoreMessage(MessageReference messageRef) {
        try {
            SpyMessage spyMessage = messageRef.getMessage();
            JMSTopic jMSTopic = this;
            synchronized (jMSTopic) {
                this.messageIdCounter = Math.max(this.messageIdCounter, spyMessage.header.messageId + 1L);
            }
            if (spyMessage.header.durableSubscriberID == null) {
                this.cat.debug((Object)"Trying to restore message with null durableSubscriberID");
            } else {
                ((BasicQueue)this.durQueues.get(spyMessage.header.durableSubscriberID)).restoreMessage(messageRef);
            }
        }
        catch (JMSException e) {
            this.cat.error((Object)"Could not restore message:", (Throwable)e);
        }
    }

    public void createDurableSubscription(DurableSubscriptionID id) throws JMSException {
        if (this.temporaryDestination != null) {
            throw new JMSException("Not a valid operation on a temporary topic");
        }
        SpyTopic dstopic = new SpyTopic((SpyTopic)this.destination, id);
        class SelectorPersistentQueue
        extends PersistentQueue {
            Selector selector;
            private final /* synthetic */ JMSTopic this$0;

            SelectorPersistentQueue(JMSTopic this$0, JMSDestinationManager server, SpyTopic dstopic, String selector) throws JMSException {
                super(server, dstopic);
                this.this$0 = this$0;
                this.selector = new Selector(selector);
            }

            public void addMessage(MessageReference mesRef, Tx txId) throws JMSException {
                if (this.selector.test(mesRef.getHeaders())) {
                    super.addMessage(mesRef, txId);
                }
            }
        }
        PersistentQueue queue = id.getSelector() == null ? new PersistentQueue(this.server, dstopic) : new SelectorPersistentQueue(this, this.server, dstopic, id.getSelector());
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            this.durQueues.put(id, queue);
        }
        this.server.getPersistenceManager().restoreQueue(this, dstopic);
    }

    public void close() throws JMSException {
        if (this.temporaryDestination != null) {
            throw new JMSException("Not a valid operation on a temporary topic");
        }
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            Iterator i = this.durQueues.values().iterator();
            while (i.hasNext()) {
                PersistentQueue queue = (PersistentQueue)i.next();
                this.server.getPersistenceManager().closeQueue(this, queue.getSpyDestination());
            }
        }
    }

    public void destroyDurableSubscription(DurableSubscriptionID id) throws JMSException {
        BasicQueue queue;
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            queue = (BasicQueue)this.durQueues.remove(id);
        }
        queue.removeAllMessages();
    }

    public SpyMessage receive(Subscription sub, boolean wait) throws JMSException {
        return this.getQueue(sub).receive(sub, wait);
    }

    public void acknowledge(AcknowledgementRequest req, Subscription sub, Tx txId) throws JMSException {
        this.getQueue(sub).acknowledge(req, txId);
    }

    public void addMessage(SpyMessage message, Tx txId) throws JMSException {
        long messageId = 0L;
        JMSTopic jMSTopic = this;
        synchronized (jMSTopic) {
            MessageReference ref;
            SpyMessage clone;
            BasicQueue q;
            messageId = this.messageIdCounter++;
            HashMap hashMap = this.durQueues;
            synchronized (hashMap) {
                Iterator iter = this.durQueues.keySet().iterator();
                while (iter.hasNext()) {
                    DurableSubscriptionID id = (DurableSubscriptionID)iter.next();
                    q = (PersistentQueue)this.durQueues.get(id);
                    clone = message.myClone();
                    clone.header.durableSubscriberID = id;
                    clone.header.messageId = messageId;
                    ref = this.server.getMessageCache().add(clone);
                    ((PersistentQueue)q).addMessage(ref, txId);
                }
            }
            HashMap hashMap2 = this.tempQueues;
            synchronized (hashMap2) {
                Iterator iter = this.tempQueues.values().iterator();
                while (iter.hasNext()) {
                    q = (BasicQueue)iter.next();
                    clone = message.myClone();
                    clone.header.messageId = messageId;
                    ref = this.server.getMessageCache().add(clone);
                    q.addMessage(ref, txId);
                }
            }
        }
    }

    public ArrayList getPersistentQueues() {
        return new ArrayList(this.durQueues.values());
    }

    PersistentQueue getDurableSubscription(DurableSubscriptionID id) {
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            PersistentQueue persistentQueue = (PersistentQueue)this.durQueues.get(id);
            return persistentQueue;
        }
    }

    private BasicQueue getQueue(Subscription sub) {
        SpyTopic topic = (SpyTopic)sub.destination;
        DurableSubscriptionID id = topic.getDurableSubscriptionID();
        if (id != null) {
            return this.getDurableSubscription(id);
        }
        HashMap hashMap = this.tempQueues;
        synchronized (hashMap) {
            BasicQueue basicQueue = (BasicQueue)this.tempQueues.get(sub);
            return basicQueue;
        }
    }

    public boolean isInUse() {
        if (this.tempQueues.size() > 0) {
            return true;
        }
        Iterator iter = this.durQueues.values().iterator();
        while (iter.hasNext()) {
            PersistentQueue q = (PersistentQueue)iter.next();
            if (!q.isInUse()) continue;
            return true;
        }
        return false;
    }

    public void removeAllMessages() throws JMSException {
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            Iterator i = this.durQueues.values().iterator();
            while (i.hasNext()) {
                PersistentQueue queue = (PersistentQueue)i.next();
                queue.removeAllMessages();
            }
        }
    }
}

