/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server.jmx;

import javax.management.InvalidAttributeValueException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.logging.Logger;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.jmx.DestinationMBean;
import org.jboss.naming.Util;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;

public abstract class DestinationMBeanSupport
extends ServiceMBeanSupport
implements DestinationMBean,
MBeanRegistration {
    SpyDestination spyDest;
    String destinationName;
    String jndiName;
    boolean jndiBound;
    ObjectName jbossMQService;
    Element securityConf;
    ObjectName securityManager;

    public ObjectName getDestinationManager() {
        return this.jbossMQService;
    }

    public void setDestinationManager(ObjectName jbossMQService) {
        this.jbossMQService = jbossMQService;
    }

    public void setSecurityConf(Element securityConf) throws Exception {
        this.log.debug((Object)("Setting securityConf: " + securityConf));
        this.securityConf = securityConf;
    }

    public void setSecurityManager(ObjectName securityManager) {
        this.securityManager = securityManager;
    }

    public void startService() throws Exception {
        if (this.securityManager != null) {
            this.getServer().invoke(this.securityManager, "addDestination", new Object[]{this.spyDest.getName(), this.securityConf}, new String[]{"java.lang.String", "org.w3c.dom.Element"});
        }
    }

    public void stopService() throws Exception {
        if (this.jndiBound) {
            InitialContext ctx = new InitialContext();
            try {
                Util.unbind((Context)ctx, (String)this.jndiName);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ctx.close();
                throw throwable;
            }
            ctx.close();
            this.jndiName = null;
            this.jndiBound = false;
        }
        if (this.securityManager != null) {
            this.getServer().invoke(this.securityManager, "removeDestination", new Object[]{this.spyDest.getName()}, new String[]{"java.lang.String"});
        }
    }

    protected void destroyService() throws Exception {
        JMSDestinationManager jmsServer = (JMSDestinationManager)this.server.getAttribute(this.jbossMQService, "Interceptor");
        jmsServer.closeDestination(this.spyDest);
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        this.destinationName = name.getKeyProperty("name");
        if (this.destinationName == null || this.destinationName.length() == 0) {
            throw new MalformedObjectNameException("Property 'name' not provided");
        }
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + this.destinationName));
        return name;
    }

    public synchronized void setJNDIName(String name) throws Exception {
        if (this.spyDest == null) {
            this.jndiName = name;
            return;
        }
        if (name == null) {
            throw new InvalidAttributeValueException("Destination JNDI names can not be null");
        }
        InitialContext ic = new InitialContext();
        try {
            if (this.jndiName != null && this.jndiBound) {
                Util.unbind((Context)ic, (String)this.jndiName);
                this.jndiName = null;
                this.jndiBound = false;
            }
            Util.rebind((Context)ic, (String)name, (Object)this.spyDest);
            this.jndiName = name;
            this.jndiBound = true;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ic.close();
            throw throwable;
        }
        ic.close();
        this.log.info((Object)("Bound to JNDI name: " + this.jndiName));
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public abstract void removeAllMessages() throws Exception;
}

