/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.DriverManager;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class ConnectionDialogSwing
extends JDialog
implements ActionListener,
ItemListener {
    static final String[][] sJDBCTypes = new String[][]{{"HypersonicSQL In-Memory", "org.hsql.jdbcDriver", "jdbc:HypersonicSQL:."}, {"HypersonicSQL Standalone", "org.hsql.jdbcDriver", "jdbc:HypersonicSQL:test"}, {"HypersonicSQL Server", "org.hsql.jdbcDriver", "jdbc:HypersonicSQL:hsql://localhost"}, {"HypersonicSQL WebServer", "org.hsql.jdbcDriver", "jdbc:HypersonicSQL:http://localhost"}, {"JDBC-ODBC Brigde from Sun", "sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:test"}, {"Oracle", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@"}, {"IBM DB2", "COM.ibm.db2.jdbc.app.DB2Driver", "jdbc:db2:test"}, {"Cloudscape RMI", "RmiJdbc.RJDriver", "jdbc:rmi://localhost:1099/jdbc:cloudscape:test;create=true"}, {"InstantDb", "jdbc.idbDriver", "jdbc:idb:sample.prp"}, {"Postgresql 6.5", "postgresql.Driver", "jdbc:postgresql://hostname/dbname"}};
    Connection mConnection;
    JTextField mDriver;
    JTextField mURL;
    JTextField mUser;
    JTextField mError;
    JPasswordField mPassword;

    public static Connection createConnection(String driver, String url, String user, String password) throws Exception {
        Class.forName(driver).newInstance();
        return DriverManager.getConnection(url, user, password);
    }

    ConnectionDialogSwing(JFrame owner, String title) {
        super(owner, title, true);
    }

    void create() {
        Box main = Box.createHorizontalBox();
        Box labels = Box.createVerticalBox();
        Box controls = Box.createVerticalBox();
        Box buttons = Box.createHorizontalBox();
        Box whole = Box.createVerticalBox();
        Box status = Box.createHorizontalBox();
        main.add(Box.createHorizontalGlue());
        main.add(labels);
        main.add(Box.createHorizontalStrut(10));
        main.add(Box.createHorizontalGlue());
        main.add(controls);
        main.add(Box.createHorizontalGlue());
        whole.add(Box.createVerticalGlue());
        whole.add(Box.createVerticalStrut(10));
        whole.add(main);
        whole.add(Box.createVerticalGlue());
        whole.add(Box.createVerticalStrut(10));
        whole.add(buttons);
        whole.add(Box.createVerticalGlue());
        whole.add(Box.createVerticalStrut(10));
        whole.add(status);
        whole.add(Box.createVerticalStrut(10));
        whole.add(Box.createVerticalGlue());
        labels.add(Box.createVerticalGlue());
        labels.add(ConnectionDialogSwing.createLabel("Type:"));
        labels.add(Box.createVerticalGlue());
        labels.add(ConnectionDialogSwing.createLabel("Driver"));
        labels.add(Box.createVerticalGlue());
        labels.add(ConnectionDialogSwing.createLabel("URL"));
        labels.add(Box.createVerticalGlue());
        labels.add(ConnectionDialogSwing.createLabel("User:"));
        labels.add(Box.createVerticalGlue());
        labels.add(ConnectionDialogSwing.createLabel("Password:"));
        labels.add(Box.createVerticalGlue());
        labels.add(Box.createVerticalStrut(10));
        controls.add(Box.createVerticalGlue());
        JComboBox<String> types = new JComboBox<String>();
        int i = 0;
        while (i < sJDBCTypes.length) {
            types.addItem(sJDBCTypes[i][0]);
            ++i;
        }
        types.addItemListener(this);
        controls.add(types);
        controls.add(Box.createVerticalGlue());
        this.mDriver = new JTextField("org.hsql.jdbcDriver");
        controls.add(this.mDriver);
        this.mURL = new JTextField("jdbc:HypersonicSQL:.");
        controls.add(this.mURL);
        controls.add(Box.createVerticalGlue());
        this.mUser = new JTextField("sa");
        controls.add(this.mUser);
        controls.add(Box.createVerticalGlue());
        this.mPassword = new JPasswordField("");
        controls.add(this.mPassword);
        controls.add(Box.createVerticalGlue());
        controls.add(Box.createVerticalStrut(10));
        buttons.add(Box.createHorizontalGlue());
        buttons.add(Box.createHorizontalStrut(10));
        JButton b = new JButton("Ok");
        b.setActionCommand("ConnectOk");
        b.addActionListener(this);
        buttons.add(b);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(Box.createHorizontalStrut(20));
        b = new JButton("Cancel");
        b.setActionCommand("ConnectCancel");
        b.addActionListener(this);
        buttons.add(b);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(Box.createHorizontalStrut(10));
        this.mError = new JTextField("");
        this.mError.setEditable(false);
        status.add(Box.createHorizontalGlue());
        status.add(this.mError);
        status.add(Box.createHorizontalGlue());
        JPanel jp = new JPanel();
        jp.setBorder(new EmptyBorder(10, 10, 10, 10));
        jp.add("Center", whole);
        this.getContentPane().add("Center", jp);
        this.doLayout();
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        ((Component)this).setLocation((d.width - size.width) / 2, (d.height - size.height) / 2);
        this.show();
    }

    void trace(String s) {
        this.mError.setText(s);
        System.out.println(s);
    }

    public static Connection createConnection(JFrame owner, String title) {
        ConnectionDialogSwing dialog = new ConnectionDialogSwing(owner, title);
        dialog.create();
        return dialog.mConnection;
    }

    public static JLabel createLabel(String s) {
        JLabel l = new JLabel(s);
        return l;
    }

    public static JPanel createBorderPanel(Component center) {
        JPanel p = new JPanel();
        p.setBackground(SystemColor.control);
        p.setLayout(new BorderLayout());
        p.add("Center", center);
        p.setBackground(SystemColor.control);
        return p;
    }

    public void actionPerformed(ActionEvent ev) {
        String s = ev.getActionCommand();
        if (s.equals("ConnectOk")) {
            try {
                this.mConnection = ConnectionDialogSwing.createConnection(this.mDriver.getText(), this.mURL.getText(), this.mUser.getText(), new String(this.mPassword.getPassword()));
                this.dispose();
            }
            catch (Exception e) {
                this.mError.setText(e.toString());
            }
        } else if (s.equals("ConnectCancel")) {
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        String s = (String)e.getItem();
        int i = 0;
        while (i < sJDBCTypes.length) {
            if (s.equals(sJDBCTypes[i][0])) {
                this.mDriver.setText(sJDBCTypes[i][1]);
                this.mURL.setText(sJDBCTypes[i][2]);
            }
            ++i;
        }
    }
}

