/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import org.hsqldb.Column;
import org.hsqldb.Record;
import org.hsqldb.Trace;

class Result {
    private Record rTail;
    private int iSize;
    private int iColumnCount;
    static final int UPDATECOUNT = 0;
    static final int ERROR = 1;
    static final int DATA = 2;
    int iMode;
    String sError;
    int iUpdateCount;
    Record rRoot;
    String[] sLabel;
    String[] sTable;
    String[] sName;
    int[] iType;

    Result() {
        this.iMode = 0;
        this.iUpdateCount = 0;
    }

    Result(String error) {
        this.iMode = 1;
        this.sError = error;
    }

    Result(int columns) {
        this.prepareData(columns);
        this.iColumnCount = columns;
    }

    int getSize() {
        return this.iSize;
    }

    void setColumnCount(int columns) {
        this.iColumnCount = columns;
    }

    int getColumnCount() {
        return this.iColumnCount;
    }

    void append(Result a) {
        if (this.rRoot == null) {
            this.rRoot = a.rRoot;
        } else {
            this.rTail.next = a.rRoot;
        }
        this.rTail = a.rTail;
        this.iSize += a.iSize;
    }

    void add(Object[] d) {
        Record r = new Record();
        r.data = d;
        if (this.rRoot == null) {
            this.rRoot = r;
        } else {
            this.rTail.next = r;
        }
        this.rTail = r;
        ++this.iSize;
    }

    Result(byte[] b) throws SQLException {
        ByteArrayInputStream bin = new ByteArrayInputStream(b);
        DataInputStream in = new DataInputStream(bin);
        try {
            this.iMode = in.readInt();
            if (this.iMode == 1) {
                throw Trace.getError(in.readUTF());
            }
            if (this.iMode == 0) {
                this.iUpdateCount = in.readInt();
            } else if (this.iMode == 2) {
                int l = in.readInt();
                this.prepareData(l);
                this.iColumnCount = l;
                int i = 0;
                while (i < l) {
                    this.iType[i] = in.readInt();
                    this.sLabel[i] = in.readUTF();
                    this.sTable[i] = in.readUTF();
                    this.sName[i] = in.readUTF();
                    ++i;
                }
                while (in.available() != 0) {
                    this.add(Column.readData(in, l));
                }
            }
        }
        catch (IOException e) {
            Trace.error(18);
        }
    }

    byte[] getBytes() throws SQLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        try {
            out.writeInt(this.iMode);
            if (this.iMode == 0) {
                out.writeInt(this.iUpdateCount);
            } else if (this.iMode == 1) {
                out.writeUTF(this.sError);
            } else {
                int l = this.iColumnCount;
                out.writeInt(l);
                Record n = this.rRoot;
                int i = 0;
                while (i < l) {
                    out.writeInt(this.iType[i]);
                    out.writeUTF(this.sLabel[i]);
                    out.writeUTF(this.sTable[i]);
                    out.writeUTF(this.sName[i]);
                    ++i;
                }
                while (n != null) {
                    Column.writeData(out, l, this.iType, n.data);
                    n = n.next;
                }
            }
            return bout.toByteArray();
        }
        catch (IOException e) {
            throw Trace.error(18);
        }
    }

    private void prepareData(int columns) {
        this.iMode = 2;
        this.sLabel = new String[columns];
        this.sTable = new String[columns];
        this.sName = new String[columns];
        this.iType = new int[columns];
    }
}

