/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.hsqldb.Channel;
import org.hsqldb.Database;
import org.hsqldb.Result;
import org.hsqldb.StringConverter;
import org.hsqldb.Trace;
import org.hsqldb.jdbcDatabaseMetaData;
import org.hsqldb.jdbcPreparedStatement;
import org.hsqldb.jdbcResultSet;
import org.hsqldb.jdbcStatement;

public class jdbcConnection
implements Connection {
    private boolean bClosed;
    private boolean bAutoCommit;
    private String sDatabaseName;
    private static final int HTTP = 0;
    private static final int STANDALONE = 1;
    private static final int INTERNAL = 2;
    private static final int HSQL = 3;
    private int iType;
    private Database dDatabase;
    private Channel cChannel;
    Socket sSocket;
    DataOutputStream dOutput;
    DataInputStream dInput;
    public static final int DEFAULT_HSQL_PORT = 9001;
    private static Hashtable tDatabase = new Hashtable();
    private static Hashtable iUsageCount = new Hashtable();
    private String sConnect;
    private String sUser;
    private String sPassword;
    static final String ENCODING = "8859_1";

    public Statement createStatement() {
        if (this.bClosed) {
            return null;
        }
        return new jdbcStatement(this);
    }

    public PreparedStatement prepareStatement(String sql) {
        if (this.bClosed) {
            return null;
        }
        return new jdbcPreparedStatement(this, sql);
    }

    public CallableStatement prepareCall(String sql) {
        if (this.bClosed) {
            return null;
        }
        return new jdbcPreparedStatement(this, sql);
    }

    public String nativeSQL(String sql) {
        if (sql.indexOf(123) == -1) {
            return sql;
        }
        char[] s = sql.toCharArray();
        boolean changed = false;
        int state = 0;
        int len = s.length;
        int i = 0;
        while (i < len) {
            char c = s[i];
            switch (state) {
                case 0: {
                    if (c == '\'') {
                        state = 1;
                        break;
                    }
                    if (c == '\"') {
                        state = 2;
                        break;
                    }
                    if (c != '{') break;
                    s[i] = 32;
                    changed = true;
                    String sub = sql.substring(i + 1).toUpperCase();
                    if (sub.startsWith("?=")) {
                        i += 2;
                    } else if (sub.startsWith("CALL")) {
                        i += 4;
                    } else if (sub.startsWith("ESCAPE")) {
                        i += 6;
                    }
                    state = 3;
                    break;
                }
                case 1: 
                case 5: {
                    if (c != '\'') break;
                    --state;
                    break;
                }
                case 2: 
                case 6: {
                    if (c != '\"') break;
                    state -= 2;
                    break;
                }
                case 3: {
                    if (c == ' ') {
                        state = 4;
                        break;
                    }
                    s[i] = 32;
                    changed = true;
                    break;
                }
                case 4: {
                    if (c == '\'') {
                        state = 5;
                        break;
                    }
                    if (c == '\"') {
                        state = 6;
                        break;
                    }
                    if (c != '}') break;
                    s[i] = 32;
                    changed = true;
                    state = 0;
                }
            }
            ++i;
        }
        if (changed) {
            sql = new String(s);
        }
        return sql;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.bAutoCommit = autoCommit;
        this.execute("SET AUTOCOMMIT " + (this.bAutoCommit ? "TRUE" : "FALSE"));
    }

    public boolean getAutoCommit() {
        return this.bAutoCommit;
    }

    public void commit() throws SQLException {
        this.execute("COMMIT");
    }

    public void rollback() throws SQLException {
        this.execute("ROLLBACK");
    }

    public void close() throws SQLException {
        if (this.bClosed) {
            return;
        }
        if (this.iType == 1 || this.iType == 2) {
            this.closeStandalone();
        } else {
            this.execute("DISCONNECT");
        }
        this.bClosed = true;
    }

    public boolean isClosed() {
        return this.bClosed;
    }

    public DatabaseMetaData getMetaData() {
        return new jdbcDatabaseMetaData(this);
    }

    public void setReadOnly(boolean readonly) throws SQLException {
        this.execute("SET READONLY " + (readonly ? "TRUE" : "FALSE"));
    }

    public boolean isReadOnly() throws SQLException {
        String s = "SELECT * FROM SYSTEM_CONNECTIONINFO WHERE KEY='READONLY'";
        jdbcResultSet r = this.execute(s);
        r.next();
        return r.getString(2).equals("TRUE");
    }

    public void setCatalog(String catalog) {
    }

    public String getCatalog() {
        return null;
    }

    public void setTransactionIsolation(int level) {
    }

    public int getTransactionIsolation() {
        return 1;
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public Statement createStatement(int type, int concurrency) throws SQLException {
        return this.createStatement();
    }

    public PreparedStatement prepareStatement(String sql, int type, int concurrency) throws SQLException {
        return this.prepareStatement(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql);
    }

    public Map getTypeMap() throws SQLException {
        return new HashMap(0);
    }

    public void setTypeMap(Map map) throws SQLException {
        throw Trace.error(19);
    }

    jdbcConnection(String s, String user, String password) throws SQLException {
        this.bAutoCommit = true;
        this.sDatabaseName = s;
        if (s.toUpperCase().startsWith("HTTP://")) {
            this.iType = 0;
            this.openHTTP(user, password);
        } else if (s.toUpperCase().startsWith("HSQL://")) {
            this.iType = 3;
            this.openHSQL(user, password);
        } else {
            this.iType = 1;
            this.openStandalone(user, password);
        }
    }

    jdbcConnection(Channel c) throws SQLException {
        this.iType = 2;
        this.cChannel = c;
        this.dDatabase = c.getDatabase();
    }

    jdbcResultSet execute(String s) throws SQLException {
        Trace.check(!this.bClosed, 1);
        if (this.iType == 0) {
            return this.executeHTTP(s);
        }
        if (this.iType == 3) {
            return this.executeHSQL(s);
        }
        return this.executeStandalone(s);
    }

    boolean usesLocalFiles() {
        return this.iType != 0;
    }

    String getName() {
        return this.sDatabaseName;
    }

    private void openHTTP(String user, String password) throws SQLException {
        this.sConnect = this.sDatabaseName;
        this.sUser = user;
        this.sPassword = password;
        this.executeHTTP(" ");
    }

    private synchronized jdbcResultSet executeHTTP(String s) throws SQLException {
        byte[] result;
        try {
            URL url = new URL(this.sConnect);
            String p = StringConverter.unicodeToHexString(this.sUser);
            p = p + "+" + StringConverter.unicodeToHexString(this.sPassword);
            p = p + "+" + StringConverter.unicodeToHexString(s);
            URLConnection c = url.openConnection();
            c.setDoOutput(true);
            OutputStream os = c.getOutputStream();
            os.write(p.getBytes(ENCODING));
            os.close();
            c.connect();
            InputStream is = (InputStream)c.getContent();
            BufferedInputStream in = new BufferedInputStream(is);
            int len = c.getContentLength();
            result = new byte[len];
            int i = 0;
            while (i < len) {
                int r = in.read();
                result[i] = (byte)r;
                ++i;
            }
        }
        catch (Exception e) {
            throw Trace.error(2, e.getMessage());
        }
        return new jdbcResultSet(new Result(result));
    }

    private void openHSQL(String user, String password) throws SQLException {
        this.sConnect = this.sDatabaseName.substring(7);
        this.sUser = user;
        this.sPassword = password;
        this.reconnectHSQL();
        this.sUser = user;
        this.sPassword = password;
        this.reconnectHSQL();
    }

    private void reconnectHSQL() throws SQLException {
        try {
            StringTokenizer st = new StringTokenizer(this.sConnect, ":");
            String host = st.hasMoreTokens() ? st.nextToken() : "";
            int port = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 9001;
            this.sSocket = new Socket(host, port);
            this.sSocket.setTcpNoDelay(true);
            this.dOutput = new DataOutputStream(new BufferedOutputStream(this.sSocket.getOutputStream()));
            this.dInput = new DataInputStream(new BufferedInputStream(this.sSocket.getInputStream()));
            this.dOutput.writeUTF(this.sUser);
            this.dOutput.writeUTF(this.sPassword);
            this.dOutput.flush();
        }
        catch (Exception e) {
            throw Trace.error(2, e.getMessage());
        }
    }

    private synchronized jdbcResultSet executeHSQL(String s) throws SQLException {
        byte[] result;
        try {
            int l;
            this.dOutput.writeUTF(s);
            this.dOutput.flush();
            int len = this.dInput.readInt();
            result = new byte[len];
            int p = 0;
            while ((l = this.dInput.read(result, p, len)) != len) {
                len -= l;
                p += l;
            }
        }
        catch (Exception e) {
            throw Trace.error(2, e.getMessage());
        }
        return new jdbcResultSet(new Result(result));
    }

    private synchronized void openStandalone(String user, String password) throws SQLException {
        int usage;
        this.dDatabase = (Database)tDatabase.get(this.sDatabaseName);
        if (this.dDatabase == null) {
            this.dDatabase = new Database(this.sDatabaseName);
            tDatabase.put(this.sDatabaseName, this.dDatabase);
            usage = 1;
        } else {
            usage = 1 + (Integer)iUsageCount.get(this.sDatabaseName);
        }
        iUsageCount.put(this.sDatabaseName, new Integer(usage));
        this.cChannel = this.dDatabase.connect(user, password);
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private synchronized void closeStandalone() throws SQLException {
        Integer i = (Integer)iUsageCount.get(this.sDatabaseName);
        if (i == null) {
            return;
        }
        int usage = i - 1;
        if (usage == 0) {
            iUsageCount.remove(this.sDatabaseName);
            tDatabase.remove(this.sDatabaseName);
            if (!this.dDatabase.isShutdown()) {
                this.execute("SHUTDOWN");
            }
            this.dDatabase = null;
            this.cChannel = null;
        } else {
            iUsageCount.put(this.sDatabaseName, new Integer(usage));
            this.execute("DISCONNECT");
        }
    }

    private jdbcResultSet executeStandalone(String s) throws SQLException {
        return new jdbcResultSet(this.dDatabase.execute(s, this.cChannel));
    }
}

