/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.iiop.server;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.jboss.ejb.plugins.iiop.CDRStream;
import org.jboss.ejb.plugins.iiop.CDRStreamReader;
import org.jboss.ejb.plugins.iiop.CDRStreamWriter;
import org.jboss.iiop.rmi.ExceptionAnalysis;
import org.jboss.iiop.rmi.RMIIIOPViolationException;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class SkeletonStrategy {
    private CDRStreamReader[] paramReaders;
    private Method m;
    private ExceptionWriter[] excepWriters;
    private CDRStreamWriter retvalWriter;
    static /* synthetic */ Class class$java$rmi$RemoteException;

    public SkeletonStrategy(Method m) {
        this.m = m;
        Class<?>[] paramTypes = m.getParameterTypes();
        int len = paramTypes.length;
        this.paramReaders = new CDRStreamReader[len];
        int i = 0;
        while (i < len) {
            this.paramReaders[i] = CDRStream.readerFor(paramTypes[i]);
            ++i;
        }
        Class<?>[] excepTypes = m.getExceptionTypes();
        len = excepTypes.length;
        int n = 0;
        int i2 = 0;
        while (i2 < len) {
            if (!(class$java$rmi$RemoteException == null ? SkeletonStrategy.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(excepTypes[i2])) {
                ++n;
            }
            ++i2;
        }
        this.excepWriters = new ExceptionWriter[n];
        int j = 0;
        int i3 = 0;
        while (i3 < len) {
            if (!(class$java$rmi$RemoteException == null ? SkeletonStrategy.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(excepTypes[i3])) {
                this.excepWriters[j++] = new ExceptionWriter(excepTypes[i3]);
            }
            ++i3;
        }
        ExceptionWriter.arraysort(this.excepWriters);
        this.retvalWriter = CDRStream.writerFor(m.getReturnType());
    }

    public Object[] readParams(InputStream in) {
        int len = this.paramReaders.length;
        Object[] params = new Object[len];
        int i = 0;
        while (i < len) {
            params[i] = this.paramReaders[i].read(in);
            ++i;
        }
        return params;
    }

    public Method getMethod() {
        return this.m;
    }

    public boolean isNonVoid() {
        return this.retvalWriter != null;
    }

    public void writeRetval(OutputStream out, Object retVal) {
        this.retvalWriter.write(out, retVal);
    }

    public void writeException(OutputStream out, Exception e) {
        int len = this.excepWriters.length;
        int i = 0;
        while (i < len) {
            if (this.excepWriters[i].getExceptionClass().isInstance(e)) {
                this.excepWriters[i].write(out, e);
                return;
            }
            ++i;
        }
        throw new UnknownException((Throwable)e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ExceptionWriter
    implements CDRStreamWriter {
        private Class clz;
        private String reposId;

        ExceptionWriter(Class clz) {
            this.clz = clz;
            try {
                this.reposId = ExceptionAnalysis.getExceptionAnalysis(clz).getExceptionRepositoryId();
            }
            catch (RMIIIOPViolationException e) {
                throw new RuntimeException("Cannot obtain exception repository id for " + clz.getName() + ":\n" + e);
            }
        }

        Class getExceptionClass() {
            return this.clz;
        }

        public void write(OutputStream out, Object excep) {
            out.write_string(this.reposId);
            out.write_value((Serializable)((Exception)excep), this.clz);
        }

        static void arraysort(ExceptionWriter[] a) {
            int len = a.length;
            int i = 0;
            while (i < len - 1) {
                int j = i + 1;
                while (j < len) {
                    if (a[i].clz.isAssignableFrom(a[j].clz)) {
                        ExceptionWriter tmp = a[i];
                        a[i] = a[j];
                        a[j] = tmp;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }
}

