/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.jboss.iiop.CorbaORBServiceMBean;
import org.jboss.iiop.rmi.RMIIIOPViolationException;
import org.jboss.iiop.rmi.ir.InterfaceRepository;
import org.jboss.logging.Logger;
import org.jboss.system.ORBSingleton;
import org.jboss.system.ServiceMBeanSupport;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Repository;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicy;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.RequestProcessingPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantRetentionPolicy;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public class CorbaORBService
extends ServiceMBeanSupport
implements CorbaORBServiceMBean,
ObjectFactory {
    public static String ORB_NAME = "JBossCorbaORB";
    public static String POA_NAME = "JBossCorbaPOA";
    public static String HOME_POA_NAME = "JBossCorbaHomePOA";
    public static String NAMING_NAME = "JBossCorbaNaming";
    public static String IRI_NAME = "JBossCorbaIRI";
    private MBeanServer server;
    private String orbClass = null;
    private String orbSingletonClass = null;
    private String orbSingletonDelegate = null;
    private String orbPropertiesFileName = "orb-properties-file-not-defined";
    private String portableInterceptorInitializerClass = null;
    private static ORB orb;
    private static POA poa;
    private static POA homePOA;
    private static POA namingPOA;
    private static POA irPOA;
    private static NamingContextExt namingService;
    private static InterfaceRepository iri;
    private static final Logger logger;
    static /* synthetic */ Class class$org$jboss$iiop$CorbaORBService;

    public String getName() {
        return "JBoss CORBA ORB";
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        this.server = server;
        return CorbaORBServiceMBean.OBJECT_NAME;
    }

    protected void startService() throws Exception {
        String jacorbVerbosity;
        Properties props = new Properties();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream(this.orbPropertiesFileName);
        props.load(is);
        Properties systemProps = System.getProperties();
        if (this.orbClass != null) {
            props.put("org.omg.CORBA.ORBClass", this.orbClass);
            systemProps.put("org.omg.CORBA.ORBClass", this.orbClass);
        }
        if (this.orbSingletonClass != null) {
            props.put("org.omg.CORBA.ORBSingletonClass", this.orbSingletonClass);
            systemProps.put("org.omg.CORBA.ORBSingletonClass", this.orbSingletonClass);
        }
        if (this.orbSingletonDelegate != null) {
            systemProps.put(ORBSingleton.DELEGATE_CLASS_KEY, this.orbSingletonDelegate);
        }
        if ((jacorbVerbosity = props.getProperty("jacorb.verbosity")) != null) {
            systemProps.put("jacorb.verbosity", jacorbVerbosity);
        }
        System.setProperties(systemProps);
        if (this.portableInterceptorInitializerClass != null) {
            props.put("org.omg.PortableInterceptor.ORBInitializerClass." + this.portableInterceptorInitializerClass, "");
        }
        orb = ORB.init((String[])new String[0], (Properties)props);
        this.bind(ORB_NAME, "org.omg.CORBA.ORB");
        poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        poa.the_POAManager().activate();
        this.bind(POA_NAME, "org.omg.PortableServer.POA");
        Policy[] policies = new Policy[]{poa.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), poa.create_lifespan_policy(LifespanPolicyValue.PERSISTENT)};
        homePOA = poa.create_POA("EJBHome", null, policies);
        homePOA.the_POAManager().activate();
        this.bind(HOME_POA_NAME, "org.omg.PortableServer.POA");
        namingPOA = poa.create_POA("Naming", null, policies);
        namingPOA.the_POAManager().activate();
        NamingContextImpl ns = new NamingContextImpl(namingPOA);
        byte[] rootContextId = "root".getBytes();
        namingPOA.activate_object_with_id(rootContextId, (Servant)ns);
        namingService = NamingContextExtHelper.narrow((Object)namingPOA.create_reference_with_id(rootContextId, "IDL:omg.org/CosNaming/NamingContextExt:1.0"));
        this.bind(NAMING_NAME, "org.omg.CosNaming.NamingContextExt");
        logger.info((java.lang.Object)("Naming: [" + orb.object_to_string((Object)namingService) + "]"));
        try {
            LifespanPolicy lifespanPolicy = poa.create_lifespan_policy(LifespanPolicyValue.PERSISTENT);
            IdUniquenessPolicy idUniquenessPolicy = poa.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID);
            IdAssignmentPolicy idAssignmentPolicy = poa.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID);
            ServantRetentionPolicy servantRetentionPolicy = poa.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN);
            RequestProcessingPolicy requestProcessingPolicy = poa.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT);
            irPOA = poa.create_POA("Test", null, new Policy[]{lifespanPolicy, idUniquenessPolicy, idAssignmentPolicy, servantRetentionPolicy, requestProcessingPolicy});
            iri = new InterfaceRepository(orb, irPOA);
            this.bind(IRI_NAME, "org.jboss.iiop.rmi.ir.InterfaceRepository");
            irPOA.the_POAManager().activate();
            Repository ir = iri.getReference();
            String s = orb.object_to_string((Object)ir);
            logger.info((java.lang.Object)("IR: [" + s + "]"));
        }
        catch (RMIIIOPViolationException violation) {
            logger.error((java.lang.Object)("RMI/IIOP violation, section: " + violation.getSection()), (Throwable)violation);
        }
        catch (Exception ex) {
            logger.error((java.lang.Object)"Error in interface repository initialization", (Throwable)ex);
        }
        new Thread(new Runnable(){

            public void run() {
                orb.run();
            }
        }, "ORB thread").start();
    }

    protected void stopService() {
        try {
            this.unbind(ORB_NAME);
            this.unbind(POA_NAME);
            this.unbind(HOME_POA_NAME);
            this.unbind(NAMING_NAME);
            this.unbind(IRI_NAME);
        }
        catch (Exception e) {
            this.log.error((java.lang.Object)"Exception while stopping ORB service", (Throwable)e);
        }
        try {
            namingPOA.destroy(false, false);
        }
        catch (Exception e) {
            this.log.error((java.lang.Object)"Exception while stopping ORB service", (Throwable)e);
        }
        try {
            homePOA.destroy(false, false);
        }
        catch (Exception e) {
            this.log.error((java.lang.Object)"Exception while stopping ORB service", (Throwable)e);
        }
        try {
            irPOA.destroy(false, false);
        }
        catch (Exception e) {
            this.log.error((java.lang.Object)"Exception while stopping ORB service", (Throwable)e);
        }
        try {
            orb.shutdown(false);
        }
        catch (Exception e) {
            this.log.error((java.lang.Object)"Exception while stopping ORB service", (Throwable)e);
        }
    }

    public String getORBClass() {
        return this.orbClass;
    }

    public void setORBClass(String orbClass) {
        this.orbClass = orbClass;
    }

    public String getORBSingletonClass() {
        return this.orbSingletonClass;
    }

    public void setORBSingletonClass(String orbSingletonClass) {
        this.orbSingletonClass = orbSingletonClass;
    }

    public String getORBSingletonDelegate() {
        return this.orbSingletonDelegate;
    }

    public void setORBSingletonDelegate(String orbSingletonDelegate) {
        this.orbSingletonDelegate = orbSingletonDelegate;
    }

    public void setORBPropertiesFileName(String orbPropertiesFileName) {
        this.orbPropertiesFileName = orbPropertiesFileName;
    }

    public String getORBPropertiesFileName() {
        return this.orbPropertiesFileName;
    }

    public String getPortableInterceptorInitializerClass() {
        return this.portableInterceptorInitializerClass;
    }

    public void setPortableInterceptorInitializerClass(String portableInterceptorInitializerClass) {
        this.portableInterceptorInitializerClass = portableInterceptorInitializerClass;
    }

    public java.lang.Object getObjectInstance(java.lang.Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        String s = name.toString();
        if (logger.isTraceEnabled()) {
            logger.trace((java.lang.Object)("getObjectInstance: obj.getClass().getName=\"" + obj.getClass().getName() + "\n                   name=" + s));
        }
        if (ORB_NAME.equals(s)) {
            return orb;
        }
        if (POA_NAME.equals(s)) {
            return poa;
        }
        if (HOME_POA_NAME.equals(s)) {
            return homePOA;
        }
        if (NAMING_NAME.equals(s)) {
            return namingService;
        }
        if (IRI_NAME.equals(s)) {
            return iri;
        }
        return null;
    }

    private void bind(String name, String className) throws Exception {
        Reference ref = new Reference(className, this.getClass().getName(), null);
        new InitialContext().bind("java:/" + name, (java.lang.Object)ref);
    }

    private void unbind(String name) throws Exception {
        new InitialContext().unbind("java:/" + name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = Logger.getLogger((Class)(class$org$jboss$iiop$CorbaORBService == null ? (class$org$jboss$iiop$CorbaORBService = CorbaORBService.class$("org.jboss.iiop.CorbaORBService")) : class$org$jboss$iiop$CorbaORBService));
    }

    static class NamingContextImpl
    extends org.jacorb.naming.NamingContextImpl {
        POA poa;
        int childCount = 0;

        NamingContextImpl(POA poa) {
            this.poa = poa;
        }

        public NamingContext new_context() {
            try {
                NamingContextImpl newContextImpl = new NamingContextImpl(this.poa);
                byte[] oid = (new String(this.poa.servant_to_id((Servant)this)) + "/ctx" + ++this.childCount).getBytes();
                this.poa.activate_object_with_id(oid, (Servant)newContextImpl);
                return NamingContextExtHelper.narrow((Object)this.poa.create_reference_with_id(oid, "IDL:omg.org/CosNaming/NamingContextExt:1.0"));
            }
            catch (Exception e) {
                logger.error((java.lang.Object)"Cannot create CORBA naming context", (Throwable)e);
                return null;
            }
        }
    }
}

