/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;

public class ClientLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private boolean useFirstPass;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        String passwordStacking;
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        String mt = (String)options.get("multi-threaded");
        if (mt != null && Boolean.valueOf(mt).booleanValue()) {
            SecurityAssociation.setServer();
        }
        this.useFirstPass = (passwordStacking = (String)options.get("password-stacking")) != null;
    }

    public boolean login() throws LoginException {
        if (this.useFirstPass) {
            try {
                String username = (String)this.sharedState.get("javax.security.auth.login.name");
                Object credential = this.sharedState.get("javax.security.auth.login.password");
                SecurityAssociation.setPrincipal(new SimplePrincipal(username));
                SecurityAssociation.setCredential(credential);
                SecurityAssociation.setSubject(this.subject);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        NameCallback nc = new NameCallback("User name: ", "guest");
        Callback[] callbacks = new Callback[]{nc, pc};
        try {
            char[] password = null;
            this.callbackHandler.handle(callbacks);
            String username = nc.getName();
            SecurityAssociation.setPrincipal(new SimplePrincipal(username));
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                password = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, password, 0, tmpPassword.length);
                pc.clearPassword();
            }
            SecurityAssociation.setCredential(password);
            SecurityAssociation.setSubject(this.subject);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        return true;
    }

    public boolean abort() throws LoginException {
        SecurityAssociation.clear();
        return true;
    }

    public boolean logout() throws LoginException {
        SecurityAssociation.clear();
        return true;
    }
}

