/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.Principal;
import java.security.acl.Group;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

public class DatabaseServerLoginModule
extends UsernamePasswordLoginModule {
    private String dsJndiName;
    private String principalsQuery = "select Password from Principals where PrincipalID=?";
    private String rolesQuery = "select Role, RoleGroup from Roles where PrincipalID=?";

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        Object tmp;
        super.initialize(subject, callbackHandler, sharedState, options);
        this.dsJndiName = (String)options.get("dsJndiName");
        if (this.dsJndiName == null) {
            this.dsJndiName = "java:/DefaultDS";
        }
        if ((tmp = options.get("principalsQuery")) != null) {
            this.principalsQuery = tmp.toString();
        }
        if ((tmp = options.get("rolesQuery")) != null) {
            this.rolesQuery = tmp.toString();
        }
        this.log.trace((Object)("DatabaseServerLoginModule, dsJndiName=" + this.dsJndiName));
        this.log.trace((Object)("principalsQuery=" + this.principalsQuery));
        this.log.trace((Object)("rolesQuery=" + this.rolesQuery));
    }

    /*
     * Loose catch block
     */
    protected String getUsersPassword() throws LoginException {
        String password;
        block16: {
            Statement ps;
            Connection conn;
            block15: {
                String username = this.getUsername();
                password = null;
                conn = null;
                ps = null;
                InitialContext ctx = new InitialContext();
                DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
                conn = ds.getConnection();
                ps = conn.prepareStatement(this.principalsQuery);
                ps.setString(1, username);
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) {
                    throw new FailedLoginException("No matching username found in Principals");
                }
                password = rs.getString(1);
                password = this.convertRawPassword(password);
                rs.close();
                Object var9_10 = null;
                if (ps == null) break block15;
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {}
            }
            break block16;
            {
                catch (NamingException ex) {
                    throw new LoginException(ex.toString(true));
                }
                catch (SQLException ex) {
                    this.log.error((Object)"Query failed", (Throwable)ex);
                    throw new LoginException(ex.toString());
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return password;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Group[] getRoleSets() throws LoginException {
        block25: {
            block23: {
                block21: {
                    block22: {
                        username = this.getUsername();
                        conn = null;
                        setsMap = new HashMap<String, Group>();
                        ps = null;
                        try {
                            try {
                                ctx = new InitialContext();
                                ds = (DataSource)ctx.lookup(this.dsJndiName);
                                conn = ds.getConnection();
                                ps = conn.prepareStatement(this.rolesQuery);
                                ps.setString(1, username);
                                rs = ps.executeQuery();
                                if (!rs.next()) {
                                    if (this.getUnauthenticatedIdentity() == null) {
                                        throw new FailedLoginException("No matching username found in Roles");
                                    }
                                    var9_12 = roleSets = new Group[]{new SimpleGroup("Roles")};
                                    var12_14 = null;
                                    if (ps == null) break block21;
                                    break block22;
                                }
                                do {
                                    name = rs.getString(1);
                                    groupName = rs.getString(2);
                                    if (groupName == null || groupName.length() == 0) {
                                        groupName = "Roles";
                                    }
                                    if ((group = (Group)setsMap.get(groupName)) == null) {
                                        group = new SimpleGroup(groupName);
                                        setsMap.put(groupName, group);
                                    }
                                    group.addMember((Principal)new SimplePrincipal(name));
                                } while (rs.next());
                                rs.close();
                                break block23;
                            }
                            catch (NamingException ex) {
                                throw new LoginException(ex.toString(true));
                            }
                            catch (SQLException ex) {
                                this.log.error((Object)"SQL failure", (Throwable)ex);
                                throw new LoginException(ex.toString());
                            }
                        }
                        catch (Throwable var11_21) {
                            var12_16 = null;
                            if (ps != null) {
                                try {
                                    ps.close();
                                }
                                catch (SQLException e) {
                                    // empty catch block
                                }
                            }
                            if (conn == null) throw var11_21;
                            try {
                                conn.close();
                                throw var11_21;
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            throw var11_21;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [3 : 304->314)] { 
lbl59:
                    // 1 sources

                    ps.close();
                    break block21;
lbl61:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                if (conn == null) return var9_12;
                ** try [egrp 3[TRYBLOCK] [4 : 320->329)] { 
lbl66:
                // 1 sources

                conn.close();
                return var9_12;
lbl68:
                // 1 sources

                catch (Exception ex) {
                    // empty catch block
                }
                return var9_12;
            }
            var12_15 = null;
            if (ps != null) {
                ** try [egrp 2[TRYBLOCK] [3 : 304->314)] { 
lbl75:
                // 1 sources

                ps.close();
                break block25;
lbl77:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        if (conn != null) {
            try {}
            catch (Exception ex) {}
            conn.close();
        }
        roleSets = new Group[setsMap.size()];
        setsMap.values().toArray(roleSets);
        return roleSets;
    }

    protected String convertRawPassword(String rawPassword) {
        return rawPassword;
    }
}

