/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.CharacterUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComplexTypeUnmarshaller;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class ElementUnmarshaller
extends SaxUnmarshaller {
    private static final String MAX_OCCURS_WILDCARD = "unbounded";
    private SaxUnmarshaller unmarshaller;
    private int depth = 0;
    private ElementDecl _element = null;
    private CharacterUnmarshaller charUnmarshaller = null;
    private Schema _schema = null;
    private boolean foundAnnotation = false;
    private boolean foundIdentityConstraint = false;
    private boolean foundSimpleType = false;
    private boolean foundComplexType = false;

    public ElementUnmarshaller(Schema schema, AttributeList attributeList, Resolver resolver) {
        this.setResolver(resolver);
        this._schema = schema;
        this._element = new ElementDecl(schema);
        String string = null;
        string = attributeList.getValue("ref");
        if (string != null) {
            this._element.setReference(string);
        }
        this._element.setName(attributeList.getValue("name"));
        String string2 = attributeList.getValue("default");
        if (string2 != null) {
            if (this._element.getFixedValue() != null) {
                throw new IllegalArgumentException("'default' and 'fixed' must not both be present.");
            }
            this._element.setDefaultValue(string2);
        }
        if ((string2 = attributeList.getValue("fixed")) != null) {
            if (this._element.getDefaultValue() != null) {
                throw new IllegalArgumentException("'default' and 'fixed' must not both be present.");
            }
            this._element.setFixedValue(string2);
        }
        string2 = null;
        string = attributeList.getValue("type");
        if (string != null) {
            this._element.setTypeReference(string);
        }
        if ((string = attributeList.getValue("nillable")) != null) {
            if (string.equals("true")) {
                this._element.setNillable(true);
            } else if (!string.equals("false")) {
                String string3 = "Invalid value for the 'nillable' attribute of an element definition: " + string;
                throw new IllegalArgumentException(string3);
            }
        }
        string = attributeList.getValue("minOccurs");
        int n = 1;
        if (string != null) {
            n = SaxUnmarshaller.toInt(string);
            this._element.setMinOccurs(n);
        }
        if ((string = attributeList.getValue("maxOccurs")) != null) {
            if (MAX_OCCURS_WILDCARD.equals(string)) {
                string = "-1";
            }
            int n2 = SaxUnmarshaller.toInt(string);
            this._element.setMaxOccurs(n2);
        } else if (n > 0) {
            this._element.setMaxOccurs(n);
        } else {
            this._element.setMaxOccurs(1);
        }
        this._element.setBlock(attributeList.getValue("block"));
        this.charUnmarshaller = new CharacterUnmarshaller();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }

    public String elementName() {
        return "element";
    }

    public void endElement(String string) throws SAXException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string);
            --this.depth;
            return;
        }
        if (this.unmarshaller != null && this.charUnmarshaller != this.unmarshaller && !string.equals(this.unmarshaller.elementName())) {
            String string2 = "missing end element for ";
            string2 = String.valueOf(string2) + this.unmarshaller.elementName();
            throw new SAXException(string2);
        }
        this.unmarshaller.finish();
        if ("annotation".equals(string)) {
            Annotation annotation = (Annotation)this.unmarshaller.getObject();
            this._element.addAnnotation(annotation);
        } else if ("complexType".equals(string)) {
            ComplexType complexType = ((ComplexTypeUnmarshaller)this.unmarshaller).getComplexType();
            this._element.setType(complexType);
        } else if ("simpleType".equals(string)) {
            SimpleType simpleType = ((SimpleTypeUnmarshaller)this.unmarshaller).getSimpleType();
            this._element.setType(simpleType);
        }
        this.unmarshaller = null;
    }

    public ElementDecl getElement() {
        return this._element;
    }

    public Object getObject() {
        return this._element;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, attributeList);
            ++this.depth;
            return;
        }
        if ("annotation".equals(string)) {
            if (this.foundSimpleType || this.foundIdentityConstraint || this.foundComplexType) {
                this.error("An annotation may only appear as the first child of an element definition.");
            }
            if (this.foundAnnotation) {
                this.error("Only one (1) 'annotation' is allowed as a child of element definitions.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(attributeList);
        } else if ("complexType".equals(string)) {
            if (this.foundComplexType) {
                this.error("Only one (1) 'complexType' may appear in an element definition.");
            }
            if (this.foundSimpleType) {
                this.error("Both 'simpleType' and 'complexType' cannot appear in the same element definition.");
            }
            if (this.foundIdentityConstraint) {
                this.error("A 'complexType' must appear before 'key', 'keyref' and 'unique' elements.");
            }
            this.foundComplexType = true;
            this.unmarshaller = new ComplexTypeUnmarshaller(this._schema, attributeList, this.getResolver());
        } else if ("simpleType".equals(string)) {
            if (this.foundSimpleType) {
                this.error("Only one (1) 'simpleType' may appear in an element definition.");
            }
            if (this.foundComplexType) {
                this.error("Both 'simpleType' and 'complexType' cannot appear in the same element definition.");
            }
            if (this.foundIdentityConstraint) {
                this.error("A 'simpleType' must appear before 'key', 'keyref' and 'unique' elements.");
            }
            this.foundSimpleType = true;
            this.unmarshaller = new SimpleTypeUnmarshaller(this._schema, attributeList);
        } else if ("key".equals(string)) {
            this.foundIdentityConstraint = true;
            this.error("Identity constraints are not yet supported");
        } else if ("keyref".equals(string)) {
            this.foundIdentityConstraint = true;
            this.error("Identity constraints are not yet supported");
        } else if ("unique".equals(string)) {
            this.foundIdentityConstraint = true;
            this.error("Identity constraints are not yet supported");
        } else {
            this.illegalElement(string);
        }
        this.unmarshaller.setResolver(this.getResolver());
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }
}

