/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.io.IOException;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class SchemaReader {
    private Parser _parser = null;
    private InputSource _source = null;
    private Schema _schema = null;

    private SchemaReader() throws IOException {
        Parser parser = null;
        parser = Configuration.getParser();
        if (parser == null) {
            throw new IOException("fatal error: unable to create SAX parser.");
        }
        this._parser = parser;
    }

    public SchemaReader(InputSource inputSource) throws IOException {
        this();
        if (inputSource == null) {
            throw new IllegalArgumentException("InputSource cannot be null");
        }
        this._source = inputSource;
    }

    public Schema read() throws IOException {
        if (this._schema != null) {
            return this._schema;
        }
        SchemaUnmarshaller schemaUnmarshaller = null;
        try {
            schemaUnmarshaller = new SchemaUnmarshaller();
            this._parser.setDocumentHandler(schemaUnmarshaller);
            this._parser.setErrorHandler(schemaUnmarshaller);
            this._parser.parse(this._source);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception == null) {
                exception = sAXException;
            }
            throw new IOException(exception.toString());
        }
        this._schema = schemaUnmarshaller.getSchema();
        return this._schema;
    }
}

