/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.File;
import java.io.FileFilter;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.JARDeployerMBean;
import org.jboss.deployment.SubDeployerSupport;

public class JARDeployer
extends SubDeployerSupport
implements JARDeployerMBean {
    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return JARDeployerMBean.OBJECT_NAME;
    }

    protected void stopService() {
    }

    public boolean accepts(DeploymentInfo di) {
        boolean trace = this.log.isTraceEnabled();
        try {
            URL ddDir;
            if (di.isXML) {
                return false;
            }
            URL wdDir = di.localCl.getResource("WEB-INF/");
            if (wdDir != null) {
                return false;
            }
            try {
                ddDir = ((URLClassLoader)di.localCl).findResource("META-INF/");
                if (ddDir == null) {
                    this.log.debug((Object)"no META-INF or WEB-INF found, this is for us");
                    return true;
                }
            }
            catch (ClassCastException e) {
                ddDir = new URL(di.url, "META-INF/");
            }
            if (ddDir.getProtocol().equals("file")) {
                this.log.debug((Object)"file protocol");
                File file = new File(ddDir.getFile());
                if (!file.exists()) {
                    this.log.info((Object)"file protocol, but file doesn't exist");
                    return true;
                }
                File[] entries = file.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.toString().endsWith(".xml");
                    }
                });
                this.log.debug((Object)("file protocol, entries.length " + entries.length));
                return entries.length == 0;
            }
            if (ddDir.getProtocol().equals("jar") || ddDir.getProtocol().equals("njar")) {
                this.log.trace((Object)("jar or njar protocol: " + ddDir.getProtocol()));
                JarFile jarFile = null;
                try {
                    URLConnection con = ddDir.openConnection();
                    JarURLConnection jarConn = (JarURLConnection)con;
                    jarFile = jarConn.getJarFile();
                }
                catch (Exception e) {
                    this.log.warn((Object)"looking inside jar failed; ignoring", (Throwable)e);
                    return false;
                }
                Enumeration<JarEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    String name = entry.getName();
                    if (trace) {
                        this.log.info((Object)("looking at entry: " + name));
                    }
                    if (!name.startsWith("META-INF/") || !name.endsWith(".xml")) continue;
                    return false;
                }
                this.log.debug((Object)"no xmls found");
                return true;
            }
            this.log.debug((Object)"unrecognized protocol");
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

