/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.deployment.SubDeployer;
import org.jboss.deployment.SubDeployerMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.stream.Streams;

public abstract class SubDeployerSupport
extends ServiceMBeanSupport
implements SubDeployer,
SubDeployerMBean {
    protected static final String nativeSuffix;
    protected static final String nativePrefix;
    private File tempNativeDir;

    protected void createService() throws Exception {
        ServerConfig config = ServerConfigLocator.locate();
        File basedir = config.getServerTempDir();
        this.tempNativeDir = new File(basedir, "native");
    }

    protected void startService() throws Exception {
        this.server.invoke(MainDeployerMBean.OBJECT_NAME, "addDeployer", new Object[]{this}, new String[]{"org.jboss.deployment.SubDeployer"});
    }

    protected void stopService() throws Exception {
        this.server.invoke(MainDeployerMBean.OBJECT_NAME, "removeDeployer", new Object[]{this}, new String[]{"org.jboss.deployment.SubDeployer"});
    }

    public void init(DeploymentInfo di) throws DeploymentException {
        this.processNestedDeployments(di);
    }

    public void create(DeploymentInfo di) throws DeploymentException {
    }

    public void start(DeploymentInfo di) throws DeploymentException {
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
    }

    public void destroy(DeploymentInfo di) throws DeploymentException {
    }

    protected void processNestedDeployments(DeploymentInfo di) throws DeploymentException {
        if (di.isXML) {
            return;
        }
        if (di.isDirectory) {
            File f = new File(di.url.getFile());
            if (!f.isDirectory()) {
                throw new DeploymentException("Deploy file incorrectly reported as a directory: " + di.url);
            }
            this.addDeployableFiles(di, f);
        } else {
            String jarURLString = "njar:" + di.localUrl.toString() + "^/";
            try {
                URL jarURL = new URL(jarURLString);
                URLConnection con = jarURL.openConnection();
                JarURLConnection jarConn = (JarURLConnection)con;
                JarFile jarFile = jarConn.getJarFile();
                this.addDeployableJar(di, jarFile);
            }
            catch (Exception e) {
                this.log.warn((Object)"operation failed; ignoring", (Throwable)e);
                this.log.info((Object)("deploying non-jar/xml file: " + di.url));
                return;
            }
        }
    }

    protected boolean isDeployable(String name, URL url) {
        return name.endsWith(".jar") || name.endsWith(".sar") || name.endsWith(".ear") || name.endsWith(".rar") || name.endsWith(".zip") || name.endsWith(".wsr") || name.endsWith(".war") || name.endsWith(nativeSuffix) && name.startsWith(nativePrefix);
    }

    protected void addDeployableFiles(DeploymentInfo di, File dir) throws DeploymentException {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            block5: {
                File file;
                block4: {
                    file = files[i];
                    String name = file.getName();
                    try {
                        URL url = file.toURL();
                        if (!this.isDeployable(name, url)) break block4;
                        this.deployUrl(di, url, name);
                        break block5;
                    }
                    catch (MalformedURLException e) {
                        this.log.warn((Object)("File name invalid.  Ignoring: " + file), (Throwable)e);
                    }
                }
                if (file.isDirectory()) {
                    this.addDeployableFiles(di, file);
                }
            }
            ++i;
        }
    }

    protected void addDeployableJar(DeploymentInfo di, JarFile jarFile) throws DeploymentException {
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String name = entry.getName();
            try {
                URL url = new URL("njar:" + di.localUrl.toString() + "^/" + name);
                if (!this.isDeployable(name, url)) continue;
                this.deployUrl(di, url, name);
            }
            catch (MalformedURLException mue) {
                this.log.warn((Object)("Jar entry invalid.  Ignoring: " + name), (Throwable)mue);
            }
        }
    }

    protected void deployUrl(DeploymentInfo di, URL url, String name) throws DeploymentException {
        try {
            if (name.endsWith(nativeSuffix) && name.startsWith(nativePrefix)) {
                File destFile = new File(this.tempNativeDir, name);
                this.log.info((Object)("Loading native library: " + destFile.toString()));
                File parent = destFile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                BufferedInputStream in = new BufferedInputStream(url.openStream());
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFile));
                Streams.copy((InputStream)in, (OutputStream)out);
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
                ((InputStream)in).close();
                System.load(destFile.toString());
            } else {
                DeploymentInfo sub = new DeploymentInfo(url, di);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("Error in subDeployment with name " + name), (Throwable)ex);
            throw new DeploymentException("Could not deploy sub deployment " + name + " of deployment " + di.url, ex);
        }
    }

    public abstract boolean accepts(DeploymentInfo var1);

    static {
        String nativex = System.mapLibraryName("XxX");
        int xPos = nativex.indexOf("XxX");
        nativePrefix = nativex.substring(0, xPos);
        nativeSuffix = nativex.substring(xPos + 3);
    }
}

