/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.scanner;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.Deployer;
import org.jboss.deployment.scanner.DeploymentScanner;
import org.jboss.deployment.scanner.DeploymentScannerMBean;
import org.jboss.logging.Logger;
import org.jboss.system.MissingAttributeException;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.MuBoolean;
import org.jboss.util.MuLong;
import org.jboss.util.NullArgumentException;
import org.jboss.util.jmx.MBeanProxy;
import org.jboss.util.jmx.MBeanProxyInstance;

public abstract class AbstractDeploymentScanner
extends ServiceMBeanSupport
implements DeploymentScanner,
DeploymentScannerMBean {
    protected MuLong scanPeriod = new MuLong(5000L);
    protected MuBoolean scanEnabled = new MuBoolean(true);
    protected Deployer deployer;
    protected ScannerThread scannerThread;
    static /* synthetic */ Class class$org$jboss$deployment$Deployer;

    public void setDeployer(ObjectName deployerName) {
        if (deployerName == null) {
            throw new NullArgumentException("deployerName");
        }
        this.deployer = (Deployer)MBeanProxy.create((Class)(class$org$jboss$deployment$Deployer == null ? (class$org$jboss$deployment$Deployer = AbstractDeploymentScanner.class$("org.jboss.deployment.Deployer")) : class$org$jboss$deployment$Deployer), (ObjectName)deployerName, (MBeanServer)this.server);
    }

    public ObjectName getDeployer() {
        return ((MBeanProxyInstance)this.deployer).getMBeanProxyObjectName();
    }

    public void setScanPeriod(long period) {
        if (period < 0L) {
            throw new IllegalArgumentException("ScanPeriod must be >= 0; have: " + period);
        }
        this.scanPeriod.set(period);
    }

    public long getScanPeriod() {
        return this.scanPeriod.longValue();
    }

    public void setScanEnabled(boolean flag) {
        this.scanEnabled.set(flag);
    }

    public boolean isScanEnabled() {
        return this.scanEnabled.get();
    }

    protected void createService() throws Exception {
        if (this.deployer == null) {
            throw new MissingAttributeException("Deployer");
        }
        this.scannerThread = new ScannerThread(false);
        this.scannerThread.start();
        this.log.debug((Object)"Scanner thread started");
    }

    protected void startService() throws Exception {
        this.scan();
        this.scannerThread.setEnabled(this.scanEnabled.get());
    }

    protected void stopService() throws Exception {
        this.scannerThread.setEnabled(false);
    }

    protected void destroyService() throws Exception {
        this.deployer = null;
        this.scannerThread.shutdown();
        this.scannerThread = null;
    }

    public abstract void scan() throws Exception;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ScannerThread
    extends Thread {
        protected Logger log = Logger.getLogger((Class)(class$org$jboss$deployment$scanner$AbstractDeploymentScanner$ScannerThread == null ? (class$org$jboss$deployment$scanner$AbstractDeploymentScanner$ScannerThread = ScannerThread.class$("org.jboss.deployment.scanner.AbstractDeploymentScanner$ScannerThread")) : class$org$jboss$deployment$scanner$AbstractDeploymentScanner$ScannerThread));
        protected boolean enabled;
        protected boolean shuttingDown;
        protected Object lock = new Object();
        static /* synthetic */ Class class$org$jboss$deployment$scanner$AbstractDeploymentScanner$ScannerThread;

        public ScannerThread(boolean enabled) {
            super("ScannerThread");
            this.enabled = enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Notified that enabled: " + enabled));
            }
        }

        public void shutdown() {
            this.enabled = false;
            this.shuttingDown = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Notified to shutdown");
            }
        }

        public void run() {
            this.log.info((Object)"Running");
            while (!this.shuttingDown) {
                if (!this.enabled) {
                    try {
                        this.log.debug((Object)"Disabled, waiting for notification");
                        Object object = this.lock;
                        synchronized (object) {
                            this.lock.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.loop();
            }
            this.log.info((Object)"Shutdown");
        }

        protected void loop() {
            while (this.enabled) {
                try {
                    AbstractDeploymentScanner.this.scan();
                }
                catch (Exception e) {
                    this.log.error((Object)"Scanning failed; continuing", (Throwable)e);
                }
                try {
                    this.log.trace((Object)"Sleeping...");
                    Thread.sleep(AbstractDeploymentScanner.this.scanPeriod.longValue());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

