/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceContext;
import org.jboss.system.ServiceController;
import org.jboss.system.ServiceCreator;
import org.jboss.util.Classes;
import org.jboss.util.jmx.JMXExceptionDecoder;
import org.jboss.util.jmx.ObjectNameFactory;
import org.jboss.util.xml.DOMWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ServiceConfigurator {
    private final MBeanServer server;
    private final ServiceController serviceController;
    private final ServiceCreator serviceCreator;
    private final Logger log = Logger.getLogger(this.getClass());
    static /* synthetic */ Class class$javax$management$ObjectName;
    static /* synthetic */ Class class$org$jboss$util$propertyeditor$ObjectNameEditor;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$org$jboss$util$propertyeditor$PropertiesEditor;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$org$jboss$util$propertyeditor$FileEditor;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$org$jboss$util$propertyeditor$URLEditor;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    public ServiceConfigurator(MBeanServer server, ServiceController serviceController, ServiceCreator serviceCreator) {
        this.server = server;
        this.serviceController = serviceController;
        this.serviceCreator = serviceCreator;
    }

    /*
     * Unable to fully structure code
     */
    public List install(Element config, ObjectName loaderName) throws DeploymentException {
        mbeans = new ArrayList<E>();
        try {
            if (config.getTagName().equals("mbean")) {
                this.internalInstall(config, mbeans, loaderName);
            } else {
                nl = config.getChildNodes();
                i = 0;
                while (i < nl.getLength()) {
                    if (nl.item(i).getNodeType() == 1 && (element = (Element)nl.item(i)).getTagName().equals("mbean")) {
                        mbean = (Element)nl.item(i);
                        this.internalInstall(mbean, mbeans, loaderName);
                    }
                    ++i;
                }
            }
            return mbeans;
        }
        catch (Exception e) {
            li = mbeans.listIterator(mbeans.size());
            ** while (li.hasPrevious())
        }
lbl-1000:
        // 1 sources

        {
            mbean = (ObjectName)li.previous();
            try {
                this.serviceCreator.remove(mbean);
            }
            catch (Exception n) {
                this.log.error((Object)("exception removing mbean after failed deployment: " + mbean), (Throwable)n);
            }
            continue;
        }
lbl27:
        // 1 sources

        if (e instanceof DeploymentException) {
            throw (DeploymentException)e;
        }
        throw new DeploymentException(e);
    }

    private ObjectName internalInstall(Element mbeanElement, List mbeans, ObjectName loaderName) throws Exception {
        ObjectInstance instance = null;
        ObjectName mbeanName = this.parseObjectName(mbeanElement);
        try {
            instance = this.serviceCreator.install(mbeanName, loaderName, mbeanElement);
        }
        catch (ClassNotFoundException cnfe) {
            this.serviceController.registerWaitingForClass(mbeanName, mbeanElement);
            return mbeanName;
        }
        this.serviceController.registerMBeanClassName(instance);
        mbeanName = instance.getObjectName();
        mbeans.add(mbeanName);
        if (mbeanName != null) {
            try {
                this.configure(mbeanName, loaderName, mbeanElement, mbeans);
                this.serviceController.getServiceContext((ObjectName)mbeanName).state = ServiceContext.CONFIGURED;
            }
            catch (Exception e) {
                this.serviceController.getServiceContext((ObjectName)mbeanName).state = ServiceContext.FAILED;
                throw e;
            }
        }
        return mbeanName;
    }

    protected void configure(ObjectName objectName, ObjectName loaderName, Element mbeanElement, List mbeans) throws Exception {
        MBeanInfo info;
        boolean debug = this.log.isDebugEnabled();
        try {
            info = this.server.getMBeanInfo(objectName);
        }
        catch (InstanceNotFoundException e) {
            throw new DeploymentException("trying to configure nonexistent mbean: " + objectName);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not get mbeanInfo", JMXExceptionDecoder.decode((Throwable)e));
        }
        if (info == null) {
            throw new DeploymentException("MBeanInfo is null for mbean: " + objectName);
        }
        MBeanAttributeInfo[] attributes = info.getAttributes();
        NodeList attrs = mbeanElement.getChildNodes();
        int j = 0;
        while (j < attrs.getLength()) {
            block33: {
                if (attrs.item(j).getNodeType() == 1) {
                    Element element = (Element)attrs.item(j);
                    if (element.getTagName().equals("attribute")) {
                        String attributeName = element.getAttribute("name");
                        if (element.hasChildNodes()) {
                            Node n = element.getFirstChild();
                            String attributeText = null;
                            if (n instanceof Text) {
                                attributeText = ((Text)n).getData().trim();
                            }
                            int k = 0;
                            while (k < attributes.length) {
                                if (attributeName.equals(attributes[k].getName())) {
                                    String typeName = attributes[k].getType();
                                    Class<?> typeClass = Classes.getPrimitiveTypeForName((String)typeName);
                                    if (typeClass == null) {
                                        try {
                                            typeClass = Class.forName(typeName);
                                        }
                                        catch (ClassNotFoundException e) {
                                            throw new DeploymentException("Class not found for attribute: " + attributeName, e);
                                        }
                                    }
                                    Object value = null;
                                    if (typeClass.equals(class$org$w3c$dom$Element == null ? ServiceConfigurator.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element)) {
                                        NodeList nl = element.getChildNodes();
                                        int i = 0;
                                        while (i < nl.getLength()) {
                                            n = nl.item(i);
                                            if (n.getNodeType() == 1) {
                                                value = (Element)n;
                                                break;
                                            }
                                            ++i;
                                        }
                                    }
                                    if (value == null) {
                                        PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
                                        if (editor == null) {
                                            throw new DeploymentException("No property editor for attribute: " + attributeName + "; type=" + typeClass);
                                        }
                                        editor.setAsText(attributeText);
                                        value = editor.getValue();
                                    }
                                    this.log.debug((Object)(attributeName + " set to " + value + " in " + objectName));
                                    this.setAttribute(objectName, new Attribute(attributeName, value));
                                    break block33;
                                }
                                ++k;
                            }
                            throw new DeploymentException("No Attribute found with name: " + attributeName);
                        }
                    } else if (element.getTagName().equals("depends")) {
                        if (!element.hasChildNodes()) {
                            throw new DeploymentException("No ObjectName supplied for depends in  " + objectName);
                        }
                        String mbeanRefName = element.getAttribute("optional-attribute-name");
                        if ("".equals(mbeanRefName)) {
                            mbeanRefName = null;
                        }
                        ObjectName dependsObjectName = this.processDependency(objectName, loaderName, element, mbeans);
                        if (debug) {
                            this.log.debug((Object)("considering " + (mbeanRefName == null ? "<anonymous>" : mbeanRefName.toString()) + " with object name " + dependsObjectName));
                        }
                        if (mbeanRefName != null) {
                            this.setAttribute(objectName, new Attribute(mbeanRefName, dependsObjectName));
                        }
                    } else if (element.getTagName().equals("depends-list")) {
                        String dependsListName = element.getAttribute("optional-attribute-name");
                        if ("".equals(dependsListName)) {
                            dependsListName = null;
                        }
                        NodeList dependsList = element.getChildNodes();
                        ArrayList<ObjectName> dependsListNames = new ArrayList<ObjectName>();
                        int l = 0;
                        while (l < dependsList.getLength()) {
                            Element dependsElement;
                            if (dependsList.item(l).getNodeType() == 1 && (dependsElement = (Element)dependsList.item(l)).getTagName().equals("depends-list-element")) {
                                if (!dependsElement.hasChildNodes()) {
                                    throw new DeploymentException("Empty depends-list-element!");
                                }
                                ObjectName dependsObjectName = this.processDependency(objectName, loaderName, dependsElement, mbeans);
                                if (!dependsListNames.contains(dependsObjectName)) {
                                    dependsListNames.add(dependsObjectName);
                                }
                            }
                            ++l;
                        }
                        if (dependsListName != null) {
                            this.setAttribute(objectName, new Attribute(dependsListName, dependsListNames));
                        }
                    }
                }
            }
            ++j;
        }
    }

    private ObjectName processDependency(ObjectName container, ObjectName loaderName, Element element, List mbeans) throws Exception {
        ObjectName dependsObjectName = null;
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node childNode = nl.item(i);
            if (childNode.getNodeType() == 1) {
                Element child = (Element)childNode;
                if (child.getTagName().equals("mbean")) {
                    dependsObjectName = this.internalInstall(child, mbeans, loaderName);
                    break;
                }
                throw new DeploymentException("Non mbean child element in depends tag: " + child);
            }
            ++i;
        }
        if (dependsObjectName == null) {
            if (nl.item(0).getNodeType() == 3) {
                String name = ((Text)nl.item(0)).getData().trim();
                dependsObjectName = ObjectNameFactory.create((String)name);
            } else {
                throw new DeploymentException("Nothing supplied for an object name! " + element);
            }
        }
        this.serviceController.registerDependency(container, dependsObjectName);
        return dependsObjectName;
    }

    private void setAttribute(ObjectName name, Attribute attr) throws Exception {
        try {
            this.server.setAttribute(name, attr);
        }
        catch (Exception e) {
            throw new DeploymentException("Exception setting attribute " + attr + " on mbean " + name, JMXExceptionDecoder.decode((Throwable)e));
        }
    }

    public String getConfiguration(ObjectName[] objectNames) throws Exception {
        boolean debug = this.log.isDebugEnabled();
        StringWriter out = new StringWriter();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element serverElement = doc.createElement("server");
        int j = 0;
        while (j < objectNames.length) {
            Element mbeanElement = this.internalGetConfiguration(doc, objectNames[j]);
            serverElement.appendChild(mbeanElement);
            ++j;
        }
        doc.appendChild(serverElement);
        new DOMWriter((Writer)out, false).print((Node)doc, true);
        ((Writer)out).close();
        return ((Object)out).toString();
    }

    Element getConfiguration(ObjectName name) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        return this.internalGetConfiguration(doc, name);
    }

    private Element internalGetConfiguration(Document doc, ObjectName name) throws Exception {
        Element mbeanElement = doc.createElement("mbean");
        mbeanElement.setAttribute("name", name.toString());
        MBeanInfo info = this.server.getMBeanInfo(name);
        mbeanElement.setAttribute("code", info.getClassName());
        MBeanAttributeInfo[] attributes = info.getAttributes();
        boolean hasAttributes = true;
        int i = 0;
        while (i < attributes.length) {
            this.log.trace((Object)("considering attribute: " + attributes[i]));
            if (attributes[i].isReadable() && attributes[i].isWritable()) {
                Element attributeElement = null;
                if (attributes[i].getType().equals("javax.management.ObjectName")) {
                    attributeElement = doc.createElement("depends");
                    attributeElement.setAttribute("optional-attribute-name", attributes[i].getName());
                } else {
                    attributeElement = doc.createElement("attribute");
                    attributeElement.setAttribute("name", attributes[i].getName());
                }
                Object value = this.server.getAttribute(name, attributes[i].getName());
                if (value != null) {
                    if (value instanceof Element) {
                        attributeElement.appendChild(doc.importNode((Element)value, true));
                    } else {
                        attributeElement.appendChild(doc.createTextNode(value.toString()));
                    }
                }
                mbeanElement.appendChild(attributeElement);
            }
            ++i;
        }
        ServiceContext sc = this.serviceController.getServiceContext(name);
        Iterator i2 = sc.iDependOn.iterator();
        while (i2.hasNext()) {
            ServiceContext needs = (ServiceContext)i2.next();
            Element dependsElement = doc.createElement("depends");
            dependsElement.appendChild(doc.createTextNode(needs.objectName.toString()));
            mbeanElement.appendChild(dependsElement);
        }
        return mbeanElement;
    }

    private ObjectName parseObjectName(Element element) throws Exception {
        String name = element.getAttribute("name");
        if (name == null || name.trim().equals("")) {
            throw new DeploymentException("MBean attribute 'name' must be given.");
        }
        return new ObjectName(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Class[] map = new Class[]{class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = ServiceConfigurator.class$("javax.management.ObjectName")) : class$javax$management$ObjectName, class$org$jboss$util$propertyeditor$ObjectNameEditor == null ? (class$org$jboss$util$propertyeditor$ObjectNameEditor = ServiceConfigurator.class$("org.jboss.util.propertyeditor.ObjectNameEditor")) : class$org$jboss$util$propertyeditor$ObjectNameEditor, class$java$util$Properties == null ? (class$java$util$Properties = ServiceConfigurator.class$("java.util.Properties")) : class$java$util$Properties, class$org$jboss$util$propertyeditor$PropertiesEditor == null ? (class$org$jboss$util$propertyeditor$PropertiesEditor = ServiceConfigurator.class$("org.jboss.util.propertyeditor.PropertiesEditor")) : class$org$jboss$util$propertyeditor$PropertiesEditor, class$java$io$File == null ? (class$java$io$File = ServiceConfigurator.class$("java.io.File")) : class$java$io$File, class$org$jboss$util$propertyeditor$FileEditor == null ? (class$org$jboss$util$propertyeditor$FileEditor = ServiceConfigurator.class$("org.jboss.util.propertyeditor.FileEditor")) : class$org$jboss$util$propertyeditor$FileEditor, class$java$net$URL == null ? (class$java$net$URL = ServiceConfigurator.class$("java.net.URL")) : class$java$net$URL, class$org$jboss$util$propertyeditor$URLEditor == null ? (class$org$jboss$util$propertyeditor$URLEditor = ServiceConfigurator.class$("org.jboss.util.propertyeditor.URLEditor")) : class$org$jboss$util$propertyeditor$URLEditor};
        int i = 0;
        while (i < map.length) {
            PropertyEditorManager.registerEditor(map[i++], map[i]);
            ++i;
        }
    }
}

