/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.system.Service;
import org.jboss.system.ServiceConfigurator;
import org.jboss.system.ServiceContext;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.ServiceCreator;
import org.jboss.system.ServiceFactory;
import org.jboss.util.jmx.JMXExceptionDecoder;
import org.jboss.util.jmx.ObjectNameFactory;
import org.w3c.dom.Element;

public class ServiceController
implements ServiceControllerMBean,
MBeanRegistration,
NotificationListener {
    public static final ObjectName DEFAULT_LOADER_REPOSITORY = ObjectNameFactory.create((String)"JMImplementation:service=LoaderRepository,name=Default");
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$system$ServiceController == null ? (class$org$jboss$system$ServiceController = ServiceController.class$("org.jboss.system.ServiceController")) : class$org$jboss$system$ServiceController));
    MBeanServer server;
    protected ServiceCreator creator;
    protected ServiceConfigurator configurator;
    protected Map nameToServiceMap = new HashMap();
    protected List installedServices = new LinkedList();
    private final Map classNameToMBeansMap = new HashMap();
    private Map waitingConfigs = new HashMap();
    private final Object CLASSLOADER_ADDED_OBJECT = new Object();
    private final Object CLASS_REMOVED_OBJECT = new Object();
    private static HashMap serviceOpMap = new HashMap();
    static /* synthetic */ Class class$org$jboss$system$ServiceController;
    static /* synthetic */ Class class$org$jboss$system$Service;

    public List listDeployed() {
        return new ArrayList(this.installedServices);
    }

    public List listDeployedNames() {
        ArrayList<ObjectName> names = new ArrayList<ObjectName>(this.installedServices.size());
        Iterator i = this.installedServices.iterator();
        while (i.hasNext()) {
            names.add(((ServiceContext)i.next()).objectName);
        }
        return names;
    }

    public String listConfiguration(ObjectName[] objectNames) throws Exception {
        return this.configurator.getConfiguration(objectNames);
    }

    public List listWaitingMBeans() throws Exception {
        return new ArrayList(this.waitingConfigs.keySet());
    }

    public synchronized List install(Element config, ObjectName loaderName) throws DeploymentException {
        List mbeans = this.configurator.install(config, loaderName);
        Iterator i = mbeans.iterator();
        while (i.hasNext()) {
            ObjectName mbean = (ObjectName)i.next();
            this.installedServices.add(this.getServiceContext(mbean));
        }
        return mbeans;
    }

    public synchronized void create(ObjectName serviceName) throws Exception {
        this.create(serviceName, null);
    }

    public synchronized void create(ObjectName serviceName, Collection depends) throws Exception {
        boolean debug = log.isDebugEnabled();
        ServiceContext ctx = this.getServiceContext(serviceName);
        if (depends != null) {
            log.debug((Object)("adding depends in ServiceController.create: " + depends));
            Iterator i = depends.iterator();
            while (i.hasNext()) {
                this.registerDependency(serviceName, (ObjectName)i.next());
            }
        }
        ctx.proxy = this.getServiceProxy(ctx.objectName, null);
        if (ctx.state == ServiceContext.CREATED || ctx.state == ServiceContext.RUNNING) {
            return;
        }
        int oldState = ctx.state;
        ctx.state = ServiceContext.CREATED;
        Iterator iterator = ctx.iDependOn.iterator();
        while (iterator.hasNext()) {
            ServiceContext sc = (ServiceContext)iterator.next();
            int state = sc.state;
            if (state == ServiceContext.CREATED || state == ServiceContext.RUNNING) continue;
            if (debug) {
                log.debug((Object)("waiting in create " + serviceName + " waiting on " + sc.objectName));
            }
            ctx.state = oldState;
            return;
        }
        try {
            ctx.proxy.create();
        }
        catch (Exception e) {
            ctx.state = ServiceContext.FAILED;
            throw e;
        }
        Iterator iterator2 = ctx.dependsOnMe.iterator();
        while (iterator2.hasNext()) {
            this.create(((ServiceContext)iterator2.next()).objectName);
        }
    }

    public synchronized void start(ObjectName serviceName) throws Exception {
        boolean debug = log.isDebugEnabled();
        ServiceContext ctx = this.getServiceContext(serviceName);
        if (ctx == null) {
            log.warn((Object)("Ignoring request to start nonexistent service: " + serviceName));
            return;
        }
        if (ctx.state == ServiceContext.RUNNING) {
            return;
        }
        int oldState = ctx.state;
        ctx.state = ServiceContext.RUNNING;
        Iterator iterator = ctx.iDependOn.iterator();
        while (iterator.hasNext()) {
            ServiceContext sctx = (ServiceContext)iterator.next();
            int state = sctx.state;
            if (state == ServiceContext.RUNNING) continue;
            if (debug) {
                log.debug((Object)("waiting in start " + serviceName + " on " + sctx.objectName));
            }
            ctx.state = oldState;
            return;
        }
        try {
            ctx.proxy.start();
        }
        catch (Exception e) {
            ctx.state = ServiceContext.FAILED;
            throw e;
        }
        ctx.state = ServiceContext.RUNNING;
        if (!this.installedServices.contains(ctx)) {
            this.installedServices.add(ctx);
        }
        Iterator iterator2 = ctx.dependsOnMe.iterator();
        while (iterator2.hasNext()) {
            this.start(((ServiceContext)iterator2.next()).objectName);
        }
    }

    public void stop(ObjectName serviceName) throws Exception {
        boolean debug = log.isDebugEnabled();
        ServiceContext ctx = (ServiceContext)this.nameToServiceMap.get(serviceName);
        if (debug) {
            log.debug((Object)("stopping service: " + serviceName));
        }
        if (ctx == null) {
            log.warn((Object)("Ignoring request to stop non-existant service: " + serviceName));
            return;
        }
        if (ctx.state != ServiceContext.RUNNING) {
            return;
        }
        ctx.state = ServiceContext.STOPPED;
        if (debug) {
            log.debug((Object)("service context has " + ctx.dependsOnMe.size() + " depending services"));
        }
        Iterator iterator = ctx.dependsOnMe.iterator();
        while (iterator.hasNext()) {
            ObjectName other = ((ServiceContext)iterator.next()).objectName;
            if (debug) {
                log.debug((Object)("stopping dependent service " + other));
            }
            this.stop(other);
        }
        if (ctx.proxy != null) {
            try {
                ctx.proxy.stop();
            }
            catch (Exception e) {
                ctx.state = ServiceContext.FAILED;
                throw e;
            }
        }
    }

    public void destroy(ObjectName serviceName) throws Exception {
        boolean debug = log.isDebugEnabled();
        ServiceContext ctx = (ServiceContext)this.nameToServiceMap.get(serviceName);
        if (debug) {
            log.debug((Object)("destroying service: " + serviceName));
        }
        if (ctx == null) {
            log.warn((Object)("Ignoring request to destroy non-existant service: " + serviceName));
            return;
        }
        if (ctx.state == ServiceContext.DESTROYED || ctx.state == ServiceContext.NOTYETINSTALLED) {
            return;
        }
        ctx.state = ServiceContext.DESTROYED;
        Iterator iterator = ctx.dependsOnMe.iterator();
        while (iterator.hasNext()) {
            ObjectName other = ((ServiceContext)iterator.next()).objectName;
            if (debug) {
                log.debug((Object)("destroying dependent service " + other));
            }
            this.destroy(other);
        }
        if (ctx.proxy != null) {
            try {
                ctx.proxy.destroy();
            }
            catch (Exception e) {
                ctx.state = ServiceContext.FAILED;
                throw e;
            }
        }
    }

    public void remove(ObjectName objectName) throws Exception {
        boolean debug = log.isDebugEnabled();
        ServiceContext ctx = this.getServiceContext(objectName);
        if (debug) {
            log.debug((Object)("removing service: " + objectName));
        }
        if (ctx == null) {
            log.warn((Object)("Ignoring request to remove non-existant service: " + objectName));
            return;
        }
        Iterator iterator = ctx.iDependOn.iterator();
        while (iterator.hasNext()) {
            ServiceContext iDependOnContext = (ServiceContext)iterator.next();
            iDependOnContext.dependsOnMe.remove(ctx);
            if (iDependOnContext.state != ServiceContext.NOTYETINSTALLED || iDependOnContext.dependsOnMe.size() != 0) continue;
            this.nameToServiceMap.remove(iDependOnContext.objectName);
            if (!debug) continue;
            log.debug((Object)("Removing context for non existent service it is no longer recording dependencies: " + iDependOnContext));
        }
        if (this.server.isRegistered(objectName)) {
            if (debug) {
                log.debug((Object)("removing " + objectName + " from server"));
            }
            if (ctx.dependsOnMe.size() == 0) {
                this.nameToServiceMap.remove(objectName);
            } else if (debug) {
                log.debug((Object)("Context not removed, it is recording dependencies: " + ctx));
            }
            this.installedServices.remove(ctx);
            ObjectInstance oi = this.server.getObjectInstance(objectName);
            String className = oi.getClassName();
            Set mbeans = (Set)this.classNameToMBeansMap.get(className);
            if (mbeans != null) {
                mbeans.remove(objectName);
            }
            this.creator.remove(objectName);
        } else if (debug) {
            log.debug((Object)("no need to remove " + objectName + " from server"));
        }
        ctx.state = ServiceContext.NOTYETINSTALLED;
    }

    public synchronized void shutdown() {
        log.info((Object)("Stopping " + this.nameToServiceMap.size() + " services"));
        ArrayList servicesCopy = new ArrayList(this.installedServices);
        int serviceCounter = 0;
        ObjectName name = null;
        ListIterator i = servicesCopy.listIterator(servicesCopy.size());
        while (i.hasPrevious()) {
            name = ((ServiceContext)i.previous()).objectName;
            try {
                this.remove(name);
                ++serviceCounter;
            }
            catch (Throwable e) {
                log.error((Object)("Could not remove " + name), e);
            }
        }
        log.info((Object)("Stopped " + serviceCounter + " services"));
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.creator = new ServiceCreator(server);
        this.configurator = new ServiceConfigurator(server, this, this.creator);
        NotificationFilterSupport removeFilter = new NotificationFilterSupport();
        removeFilter.enableType("jboss.mx.class.removed");
        server.addNotificationListener(DEFAULT_LOADER_REPOSITORY, this, (NotificationFilter)removeFilter, this.CLASS_REMOVED_OBJECT);
        NotificationFilterSupport addFilter = new NotificationFilterSupport();
        addFilter.enableType("jboss.mx.classloader.added");
        server.addNotificationListener(DEFAULT_LOADER_REPOSITORY, this, (NotificationFilter)addFilter, this.CLASSLOADER_ADDED_OBJECT);
        log.info((Object)"Controller MBean online");
        return name == null ? ServiceControllerMBean.OBJECT_NAME : name;
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            log.info((Object)"Registration of ServiceController failed");
        }
    }

    public void preDeregister() throws Exception {
        this.server.removeNotificationListener(DEFAULT_LOADER_REPOSITORY, this);
    }

    public void postDeregister() {
    }

    private Service getServiceProxy(ObjectName objectName, String serviceFactory) throws ClassNotFoundException, InstantiationException, IllegalAccessException, JMException {
        Service service = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (serviceFactory != null && serviceFactory.length() > 0) {
            Class<?> clazz = loader.loadClass(serviceFactory);
            ServiceFactory factory = (ServiceFactory)clazz.newInstance();
            service = factory.createService(this.server, objectName);
        } else {
            MBeanInfo info = this.server.getMBeanInfo(objectName);
            MBeanOperationInfo[] opInfo = info.getOperations();
            Class[] interfaces = new Class[]{class$org$jboss$system$Service == null ? (class$org$jboss$system$Service = ServiceController.class$("org.jboss.system.Service")) : class$org$jboss$system$Service};
            ServiceProxy handler = new ServiceProxy(objectName, opInfo);
            service = (Service)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)handler);
        }
        return service;
    }

    public synchronized ServiceContext getServiceContext(ObjectName objectName) {
        if (this.nameToServiceMap.containsKey(objectName)) {
            return (ServiceContext)this.nameToServiceMap.get(objectName);
        }
        ServiceContext ctx = new ServiceContext();
        ctx.objectName = objectName;
        this.nameToServiceMap.put(objectName, ctx);
        return ctx;
    }

    public synchronized void registerMBeanClassName(ObjectInstance instance) {
        String className = instance.getClassName();
        HashSet<ObjectName> mbeans = (HashSet<ObjectName>)this.classNameToMBeansMap.get(className);
        if (mbeans == null) {
            mbeans = new HashSet<ObjectName>();
            this.classNameToMBeansMap.put(className, mbeans);
        }
        if (!mbeans.contains(instance.getObjectName())) {
            mbeans.add(instance.getObjectName());
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        if (handback == this.CLASSLOADER_ADDED_OBJECT) {
            UnifiedClassLoader ucl = (UnifiedClassLoader)notification.getUserData();
            this.newClassLoaderNotification();
        } else if (handback == this.CLASS_REMOVED_OBJECT) {
            String className = notification.getMessage();
            this.unregisterClassName(className);
        }
    }

    void unregisterClassName(String className) {
        Set mbeans = (Set)this.classNameToMBeansMap.remove(className);
        if (mbeans != null) {
            Iterator i = mbeans.iterator();
            while (i.hasNext()) {
                ObjectName mbeanName = (ObjectName)i.next();
                try {
                    Element mbeanConfig = this.configurator.getConfiguration(mbeanName);
                    this.stop(mbeanName);
                    this.destroy(mbeanName);
                    this.remove(mbeanName);
                    this.registerWaitingForClass(mbeanName, mbeanConfig);
                }
                catch (Exception e) {
                    log.info((Object)("Exception removing mbean: " + mbeanName), (Throwable)e);
                }
            }
        }
    }

    synchronized void registerWaitingForClass(ObjectName mbeanName, Element mbeanElement) {
        log.trace((Object)("registering waiting for class: " + mbeanName));
        this.waitingConfigs.put(mbeanName, mbeanElement);
    }

    private void newClassLoaderNotification() {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Scanning for newly supplied classes for waiting mbeans");
        }
        Map waiting = null;
        ServiceController serviceController = this;
        synchronized (serviceController) {
            waiting = this.waitingConfigs;
            this.waitingConfigs = new HashMap();
        }
        Iterator i = waiting.values().iterator();
        while (i.hasNext()) {
            Element mbeanElement = (Element)i.next();
            try {
                if (trace) {
                    log.trace((Object)("trying to install mbean: " + mbeanElement));
                }
                List mbeans = this.configurator.install(mbeanElement, null);
                Iterator j = mbeans.iterator();
                while (j.hasNext()) {
                    ObjectName name = (ObjectName)j.next();
                    this.create(name);
                    this.start(name);
                }
            }
            catch (Exception e) {
                log.info((Object)("Exception when trying to deploy waiting mbean" + mbeanElement), (Throwable)e);
            }
        }
    }

    void registerDependency(ObjectName needs, ObjectName used) {
        log.debug((Object)("recording that " + needs + " depends on " + used));
        ServiceContext needsCtx = this.getServiceContext(needs);
        ServiceContext usedCtx = this.getServiceContext(used);
        if (!needsCtx.iDependOn.contains(usedCtx)) {
            needsCtx.iDependOn.add(usedCtx);
            usedCtx.dependsOnMe.add(needsCtx);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        serviceOpMap.put("create", new Integer(0));
        serviceOpMap.put("start", new Integer(1));
        serviceOpMap.put("destroy", new Integer(2));
        serviceOpMap.put("stop", new Integer(3));
    }

    public class ServiceProxy
    implements InvocationHandler {
        private boolean[] hasOp = new boolean[]{false, false, false, false};
        private ObjectName objectName;

        public ServiceProxy(ObjectName objectName, MBeanOperationInfo[] opInfo) {
            this.objectName = objectName;
            int opCount = 0;
            int op = 0;
            while (op < opInfo.length) {
                MBeanOperationInfo info = opInfo[op];
                String name = info.getName();
                Integer opID = (Integer)serviceOpMap.get(name);
                if (opID != null && info.getReturnType().equals("void") && info.getSignature().length == 0) {
                    this.hasOp[opID.intValue()] = true;
                    ++opCount;
                }
                ++op;
            }
            if (opCount == 0) {
                log.warn((Object)(objectName + " does not implement any Service methods"));
            }
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            Integer opID = (Integer)serviceOpMap.get(name);
            if (opID != null && this.hasOp[opID]) {
                try {
                    String[] sig = new String[]{};
                    ServiceController.this.server.invoke(this.objectName, name, args, sig);
                }
                catch (Exception e) {
                    throw JMXExceptionDecoder.decode((Throwable)e);
                }
            }
            return null;
        }
    }
}

