/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.jboss.Version;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.net.protocol.URLStreamHandlerFactory;
import org.jboss.system.server.Server;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigImpl;
import org.jboss.system.server.ServerConfigImplMBean;
import org.jboss.system.server.ServerImplMBean;
import org.jboss.util.UnexpectedThrowable;
import org.jboss.util.file.FileSuffixFilter;
import org.jboss.util.jmx.JMXExceptionDecoder;
import org.jboss.util.jmx.ObjectNameFactory;

public class ServerImpl
implements Server,
ServerImplMBean {
    private static final ObjectName DEFAULT_LOADER_NAME = ObjectNameFactory.create((String)"JMImplementation:service=LoaderRepository,name=Default");
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$system$server$Server == null ? (class$org$jboss$system$server$Server = ServerImpl.class$("org.jboss.system.server.Server")) : class$org$jboss$system$server$Server));
    private final Version version = Version.getInstance();
    private final Package jbossPackage = Package.getPackage("org.jboss");
    private ServerConfigImpl config;
    private MBeanServer server;
    private ObjectName mainDeployer;
    private Date startDate;
    private boolean started;
    private ShutdownHook shutdownHook;
    static /* synthetic */ Class class$org$jboss$system$server$Server;
    static /* synthetic */ Class class$javax$management$ObjectName;
    static /* synthetic */ Class class$java$lang$String;

    public void init(Properties props) throws IllegalStateException, Exception {
        if (props == null) {
            throw new IllegalArgumentException("props is null");
        }
        if (this.config != null) {
            throw new IllegalStateException("already initialized");
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.doInit(props);
            Object var4_3 = null;
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Thread.currentThread().setContextClassLoader(oldCL);
            throw throwable;
        }
    }

    private void doInit(Properties props) throws Exception {
        log.debug((Object)("server type: " + this.getClass()));
        log.info((Object)("JBoss Release: " + this.jbossPackage.getImplementationTitle()));
        URL.setURLStreamHandlerFactory((java.net.URLStreamHandlerFactory)new URLStreamHandlerFactory());
        URLStreamHandlerFactory.preload();
        String handlerPkgs = System.getProperty("java.protocol.handler.pkgs");
        handlerPkgs = handlerPkgs != null ? handlerPkgs + "|org.jboss.net.protocol" : "org.jboss.net.protocol";
        System.setProperty("java.protocol.handler.pkgs", handlerPkgs);
        this.config = new ServerConfigImpl(props);
        log.debug((Object)("Using config: " + this.config));
        log.info((Object)("Home Dir: " + this.config.getHomeDir()));
        log.info((Object)("Home URL: " + this.config.getHomeURL()));
        log.info((Object)("Library URL: " + this.config.getLibraryURL()));
        log.info((Object)("Patch URL: " + this.config.getPatchURL()));
        log.info((Object)("Server Name: " + this.config.getServerName()));
        log.info((Object)("Server Home Dir: " + this.config.getServerHomeDir()));
        log.info((Object)("Server Home URL: " + this.config.getServerHomeURL()));
        log.info((Object)("Server Data Dir: " + this.config.getServerDataDir()));
        log.info((Object)("Server Temp Dir: " + this.config.getServerTempDir()));
        log.info((Object)("Server Config URL: " + this.config.getServerConfigURL()));
        log.info((Object)("Server Library URL: " + this.config.getServerLibraryURL()));
        log.info((Object)("Root Deployemnt Filename: " + this.config.getRootDeploymentFilename()));
    }

    public ServerConfig getConfig() throws IllegalStateException {
        if (this.config == null) {
            throw new IllegalStateException("not initialized");
        }
        return this.config;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() throws IllegalStateException, Exception {
        this.getConfig();
        if (this.started) {
            throw new IllegalStateException("already started");
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                try {
                    this.doStart();
                }
                catch (Exception e) {
                    JMXExceptionDecoder.rethrow((Exception)e);
                }
                Object var4_4 = null;
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (Throwable t) {
                log.error((Object)"start failed", t);
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new UnexpectedThrowable(t);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            Thread.currentThread().setContextClassLoader(oldCL);
            throw throwable;
        }
    }

    private void doStart() throws Exception {
        this.startDate = new Date();
        log.info((Object)"Starting General Purpose Architecture (GPA)...");
        this.server = MBeanServerFactory.createMBeanServer("jboss");
        log.debug((Object)("Created MBeanServer: " + this.server));
        this.server.registerMBean(this, ServerImplMBean.OBJECT_NAME);
        this.server.registerMBean(this.config, ServerConfigImplMBean.OBJECT_NAME);
        UnifiedClassLoader ucl = this.initBootLibraries();
        Thread.currentThread().setContextClassLoader((ClassLoader)ucl);
        this.server.createMBean("org.jboss.system.server.ServerInfo", null);
        ObjectName controllerName = this.server.createMBean("org.jboss.system.ServiceController", null).getObjectName();
        log.debug((Object)("Registered service controller: " + controllerName));
        this.mainDeployer = this.server.createMBean("org.jboss.deployment.MainDeployer", null).getObjectName();
        this.server.invoke(controllerName, "create", new Object[]{this.mainDeployer}, new String[]{(class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = ServerImpl.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName()});
        this.server.invoke(controllerName, "start", new Object[]{this.mainDeployer}, new String[]{(class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = ServerImpl.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName()});
        this.shutdownHook = new ShutdownHook(controllerName);
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            log.debug((Object)"Shutdown hook added");
        }
        catch (Exception e) {
            log.warn((Object)"Failed to add shutdown hook", (Throwable)e);
        }
        ObjectName objectName = this.server.createMBean("org.jboss.deployment.JARDeployer", null).getObjectName();
        this.initService(controllerName, objectName);
        objectName = this.server.createMBean("org.jboss.deployment.SARDeployer", null).getObjectName();
        this.initService(controllerName, objectName);
        log.info((Object)"Core system initialized");
        this.server.invoke(this.mainDeployer, "deploy", new Object[]{this.config.getServerConfigURL() + this.config.getRootDeploymentFilename()}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = ServerImpl.class$("java.lang.String")) : class$java$lang$String).getName()});
        long lapsedTime = System.currentTimeMillis() - this.startDate.getTime();
        long minutes = lapsedTime / 60000L;
        long seconds = (lapsedTime - 60000L * minutes) / 1000L;
        long milliseconds = lapsedTime - 60000L * minutes - 1000L * seconds;
        log.info((Object)("JBoss (MX MicroKernel) [" + this.jbossPackage.getImplementationVersion() + "] Started in " + minutes + "m:" + seconds + "s:" + milliseconds + "ms"));
        this.started = true;
    }

    private void initService(ObjectName controllerName, ObjectName name) throws Exception {
        this.server.invoke(controllerName, "create", new Object[]{name}, new String[]{(class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = ServerImpl.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName()});
        this.server.invoke(controllerName, "start", new Object[]{name}, new String[]{(class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = ServerImpl.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName()});
    }

    private UnifiedClassLoader initBootLibraries() throws Exception {
        boolean debug = log.isDebugEnabled();
        ArrayList<URL> list = new ArrayList<URL>();
        URL patchURL = this.config.getPatchURL();
        if (patchURL != null) {
            if (patchURL.getProtocol().equals("file")) {
                File dir = new File(patchURL.getFile());
                if (dir.exists()) {
                    list.add(dir.toURL());
                    File[] jars = dir.listFiles((FileFilter)new FileSuffixFilter(new String[]{".jar", ".zip"}, true));
                    int j = 0;
                    while (jars != null && j < jars.length) {
                        list.add(jars[j].getCanonicalFile().toURL());
                        ++j;
                    }
                }
            } else {
                list.add(patchURL);
            }
        }
        list.add(this.config.getServerConfigURL());
        log.debug((Object)("Boot url list: " + list));
        UnifiedClassLoader loader = null;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            URL url = (URL)iter.next();
            if (debug) {
                log.debug((Object)("Creating loader for URL: " + url));
            }
            loader = new UnifiedClassLoader(url, this.server, DEFAULT_LOADER_NAME);
        }
        return loader;
    }

    public void shutdown() throws IllegalStateException {
        if (!this.started) {
            throw new IllegalStateException("not started");
        }
        ServerImpl server = this;
        log.info((Object)"Shutting down");
        boolean exitOnShutdown = this.config.getExitOnShutdown();
        if (log.isDebugEnabled()) {
            log.debug((Object)("exitOnShutdown: " + exitOnShutdown));
        }
        if (exitOnShutdown) {
            server.exit(0);
        } else {
            new Thread(){

                public void run() {
                    ServerImpl.this.shutdownHook.run();
                }
            }.start();
        }
    }

    public void exit(final int exitcode) {
        new Thread(){

            public void run() {
                log.info((Object)"Shutting down the JVM now!");
                Runtime.getRuntime().exit(exitcode);
            }
        }.start();
    }

    public void exit() {
        this.exit(1);
    }

    public void halt(final int exitcode) {
        new Thread(){

            public void run() {
                System.err.println("Halting the system now!");
                Runtime.getRuntime().halt(exitcode);
            }
        }.start();
    }

    public void halt() {
        this.halt(1);
    }

    private void logMemoryUsage(Runtime rt) {
        log.info((Object)("Total/free memory: " + rt.totalMemory() + "/" + rt.freeMemory()));
    }

    public void runGarbageCollector() {
        Runtime rt = Runtime.getRuntime();
        this.logMemoryUsage(rt);
        rt.gc();
        log.info((Object)"Hinted to the JVM to run garbage collection");
        this.logMemoryUsage(rt);
    }

    public void runFinalization() {
        Runtime.getRuntime().runFinalization();
        log.info((Object)"Hinted to the JVM to run any pending object finalizations");
    }

    public void traceMethodCalls(Boolean flag) {
        Runtime.getRuntime().traceMethodCalls(flag);
    }

    public void traceInstructions(Boolean flag) {
        Runtime.getRuntime().traceInstructions(flag);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public String getVersion() {
        return this.version.toString();
    }

    public String getVersionName() {
        return this.version.getName();
    }

    public String getBuildNumber() {
        return this.version.getBuildNumber();
    }

    public String getBuildID() {
        return this.version.getBuildID();
    }

    public String getBuildDate() {
        return this.version.getBuildDate();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ShutdownHook
    extends Thread {
        private ObjectName controllerName;

        public ShutdownHook(ObjectName controllerName) {
            super("JBoss Shutdown Hook");
            this.controllerName = controllerName;
        }

        public void run() {
            log.info((Object)"undeploying all packages");
            this.shutdownDeployments();
            log.info((Object)"Shutting down all services");
            System.out.println("Shutting down");
            this.shutdownServices();
            log.info((Object)"Shutdown complete");
            System.out.println("Shutdown complete");
        }

        protected void shutdownDeployments() {
            try {
                ServerImpl.this.server.invoke(ServerImpl.this.mainDeployer, "shutdown", new Object[0], new String[0]);
            }
            catch (Exception e) {
                Throwable t = JMXExceptionDecoder.decode((Throwable)e);
                log.error((Object)"failed to shutdown deployer", t);
            }
        }

        protected void shutdownServices() {
            try {
                ServerImpl.this.server.invoke(this.controllerName, "shutdown", new Object[0], new String[0]);
            }
            catch (Exception e) {
                Throwable t = JMXExceptionDecoder.decode((Throwable)e);
                log.error((Object)"failed to shutdown", t);
            }
        }
    }
}

