/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.system.server.ServerInfoMBean;
import org.jboss.util.jmx.ObjectNameFactory;
import org.jboss.util.platform.Java;

public class ServerInfo
implements ServerInfoMBean,
MBeanRegistration {
    public static final ObjectName DEFAULT_LOADER_REPOSITORY = ObjectNameFactory.create((String)"JMImplementation:service=LoaderRepository,name=Default");
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$system$server$ServerInfo == null ? (class$org$jboss$system$server$ServerInfo = ServerInfo.class$("org.jboss.system.server.ServerInfo")) : class$org$jboss$system$server$ServerInfo));
    private String hostName;
    private String hostAddress;
    private MBeanServer server;
    static /* synthetic */ Class class$org$jboss$system$server$ServerInfo;
    static /* synthetic */ Class class$java$lang$String;

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        log.info((Object)("Java version: " + System.getProperty("java.version") + "," + System.getProperty("java.vendor")));
        log.info((Object)("Java VM: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + "," + System.getProperty("java.vm.vendor")));
        log.info((Object)("OS-System: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "," + System.getProperty("os.arch")));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Full System Properties Dump");
            Enumeration<?> names = System.getProperties().propertyNames();
            while (names.hasMoreElements()) {
                String pname = (String)names.nextElement();
                log.debug((Object)("    " + pname + ": " + System.getProperty(pname)));
            }
        }
        return name == null ? ServerInfoMBean.OBJECT_NAME : name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public String getJavaVMName() {
        return System.getProperty("java.vm.name");
    }

    public String getJavaVMVersion() {
        return System.getProperty("java.vm.version");
    }

    public String getJavaVMVendor() {
        return System.getProperty("java.vm.vendor");
    }

    public String getOSName() {
        return System.getProperty("os.name");
    }

    public String getOSVersion() {
        return System.getProperty("os.version");
    }

    public String getOSArch() {
        return System.getProperty("os.arch");
    }

    public Long getTotalMemory() {
        return new Long(Runtime.getRuntime().totalMemory());
    }

    public Long getFreeMemory() {
        return new Long(Runtime.getRuntime().freeMemory());
    }

    public Long getMaxMemory() {
        if (Java.isVersion((int)5)) {
            try {
                Runtime rt = Runtime.getRuntime();
                Method m = rt.getClass().getMethod("maxMemory", new Class[0]);
                return (Long)m.invoke((Object)rt, new Object[0]);
            }
            catch (Exception e) {
                log.error((Object)"Operation failed", (Throwable)e);
            }
        }
        return new Long(-1L);
    }

    public String getHostName() {
        if (this.hostName == null) {
            try {
                this.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                log.error((Object)"Error looking up local hostname", (Throwable)e);
                this.hostName = "<unknown>";
            }
        }
        return this.hostName;
    }

    public String getHostAddress() {
        if (this.hostAddress == null) {
            try {
                this.hostAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                log.error((Object)"Error looking up local address", (Throwable)e);
                this.hostAddress = "<unknown>";
            }
        }
        return this.hostAddress;
    }

    private ThreadGroup getRootThreadGroup() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        return group;
    }

    public Integer getActiveThreadCount() {
        return new Integer(this.getRootThreadGroup().activeCount());
    }

    public Integer getActiveThreadGroupCount() {
        return new Integer(this.getRootThreadGroup().activeGroupCount());
    }

    public String listThreadDump() {
        ThreadGroup root = this.getRootThreadGroup();
        int activeThreads = root.activeCount() - 1;
        int activeGroups = root.activeGroupCount() + 1;
        String rc = "<b>Total Threads:</b> " + activeThreads + "<br>" + "<b>Total Thread Groups:</b> " + activeGroups + "<br>" + this.getThreadGroupInfo(root);
        return rc;
    }

    private String getThreadGroupInfo(ThreadGroup group) {
        StringBuffer rc = new StringBuffer();
        rc.append("<BR><B>");
        rc.append("Thread Group: " + group.getName());
        rc.append("</B> : ");
        rc.append("max priority:" + group.getMaxPriority() + ", demon:" + group.isDaemon());
        rc.append("<blockquote>");
        Thread[] threads = new Thread[group.activeCount()];
        group.enumerate(threads, false);
        int i = 0;
        while (i < threads.length && threads[i] != null) {
            rc.append("<B>");
            rc.append("Thread: " + threads[i].getName());
            rc.append("</B> : ");
            rc.append("priority:" + threads[i].getPriority() + ", demon:" + threads[i].isDaemon());
            rc.append("<BR>");
            ++i;
        }
        ThreadGroup[] groups = new ThreadGroup[group.activeGroupCount()];
        group.enumerate(groups, false);
        int i2 = 0;
        while (i2 < groups.length && groups[i2] != null) {
            rc.append(this.getThreadGroupInfo(groups[i2]));
            ++i2;
        }
        rc.append("</blockquote>");
        return rc.toString();
    }

    public String displayPackageInfo(String pkgName) {
        Package pkg = Package.getPackage(pkgName);
        if (pkg == null) {
            return "<h2>Package:" + pkgName + " Not Found!</h2>";
        }
        StringBuffer info = new StringBuffer("<h2>Package: " + pkgName + "</h2>");
        this.displayPackageInfo(pkg, info);
        return info.toString();
    }

    public String displayInfoForClass(String className) throws Exception {
        Class clazz = (Class)this.server.invoke(DEFAULT_LOADER_REPOSITORY, "findClass", new Object[]{className}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = ServerInfo.class$("java.lang.String")) : class$java$lang$String).getName()});
        if (clazz == null) {
            return "<h2>Class:" + className + " Not Found!</h2>";
        }
        Package pkg = clazz.getPackage();
        if (pkg == null) {
            return "<h2>Class:" + className + " has no Package info</h2>";
        }
        StringBuffer info = new StringBuffer("<h1>Class: " + pkg.getName() + "</h1>");
        ClassLoader cl = clazz.getClassLoader();
        info.append("<h2>ClassLoader: " + cl + "</h2>\n");
        info.append("<h3>ProtectionDomain</h3>\n");
        info.append("<pre>\n" + clazz.getProtectionDomain() + "</pre>\n");
        info.append("<h2>Package: " + pkg.getName() + "</h2>");
        this.displayPackageInfo(pkg, info);
        return info.toString();
    }

    public String displayAllPackageInfo() {
        return "Broken right now";
    }

    private void displayPackageInfo(Package pkg, StringBuffer info) {
        info.append("<pre>\n");
        info.append("SpecificationTitle: " + pkg.getSpecificationTitle());
        info.append("\nSpecificationVersion: " + pkg.getSpecificationVersion());
        info.append("\nSpecificationVendor: " + pkg.getSpecificationVendor());
        info.append("\nImplementationTitle: " + pkg.getImplementationTitle());
        info.append("\nImplementationVersion: " + pkg.getImplementationVersion());
        info.append("\nImplementationVendor: " + pkg.getImplementationVendor());
        info.append("\nisSealed: " + pkg.isSealed());
        info.append("</pre>\n");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

