/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource;

import java.io.File;
import java.net.URL;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.management.j2ee.ResourceAdapter;
import org.jboss.management.j2ee.ResourceAdapterModule;
import org.jboss.metadata.XmlFileLoader;
import org.jboss.resource.RARDeployerMBean;
import org.jboss.resource.RARMetaData;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.util.jmx.MBeanProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RARDeployer
extends SubDeployerSupport
implements RARDeployerMBean {
    private static int nextNum = 0;
    private ServiceControllerMBean serviceController;
    private int nextMessageNum = 0;
    static /* synthetic */ Class class$org$jboss$system$ServiceControllerMBean;

    public boolean accepts(DeploymentInfo sdi) {
        String urlStr = sdi.url.toString();
        return urlStr.endsWith("rar") || urlStr.endsWith("rar/");
    }

    public void postRegister(Boolean done) {
        super.postRegister(done);
        this.serviceController = (ServiceControllerMBean)MBeanProxy.create((Class)(class$org$jboss$system$ServiceControllerMBean == null ? (class$org$jboss$system$ServiceControllerMBean = RARDeployer.class$("org.jboss.system.ServiceControllerMBean")) : class$org$jboss$system$ServiceControllerMBean), (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)this.server);
    }

    public String getName() {
        return "RARDeployer";
    }

    public void init(DeploymentInfo rdi) throws DeploymentException {
        try {
            URL raUrl = rdi.localCl.getResource("META-INF/ra.xml");
            Document dd = XmlFileLoader.getDocument((URL)raUrl);
            Element root = dd.getDocumentElement();
            RARMetaData metadata = new RARMetaData();
            metadata.importXml(root);
            metadata.setClassLoader((ClassLoader)rdi.ucl);
            rdi.metaData = metadata;
            if (rdi.url.getProtocol().startsWith("http")) {
                rdi.watch = rdi.url;
            } else if (rdi.url.getProtocol().startsWith("file")) {
                File file = new File(rdi.url.getFile());
                rdi.watch = !file.isDirectory() ? rdi.url : new URL(rdi.url, "META-INF/application.xml");
            }
        }
        catch (Exception e) {
            throw new DeploymentException("problem with init in RARDeployer ", (Throwable)e);
        }
        this.processNestedDeployments(rdi);
    }

    public void create(DeploymentInfo rdi) throws DeploymentException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Attempting to deploy RAR at '" + rdi.url + "'"));
        }
        try {
            RARMetaData metaData = (RARMetaData)rdi.metaData;
            rdi.deployedObject = new ObjectName("jboss.jca:service=RARDeployment,name=" + metaData.getDisplayName());
            this.server.createMBean("org.jboss.resource.RARDeployment", rdi.deployedObject, new Object[]{metaData}, new String[]{"org.jboss.resource.RARMetaData"});
            this.serviceController.create(rdi.deployedObject);
            ObjectName lModule = ResourceAdapterModule.create((MBeanServer)this.server, (String)(rdi.parent == null ? rdi.shortName : rdi.parent.shortName), (String)rdi.shortName, (URL)rdi.localUrl, (ObjectName)rdi.deployedObject);
            ObjectName lResourceAdaptor = ResourceAdapter.create((MBeanServer)this.server, (String)(lModule + ""), (String)metaData.getDisplayName());
        }
        catch (Exception e) {
            this.log.error((Object)"Problem deploying RARDeployment MBean", (Throwable)e);
            throw new DeploymentException("Problem making RARDeployment MBean", (Throwable)e);
        }
    }

    public void start(DeploymentInfo rdi) throws DeploymentException {
        try {
            this.serviceController.start(rdi.deployedObject);
        }
        catch (Exception e) {
            this.log.error((Object)"Problem deploying RARDeployment MBean", (Throwable)e);
            throw new DeploymentException("Problem making RARDeployment MBean", (Throwable)e);
        }
    }

    public void stop(DeploymentInfo rdi) throws DeploymentException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Undeploying RAR at '" + rdi.url + "'"));
        }
        try {
            this.log.info((Object)("About to undeploy RARDeploymentMBean, objectname: " + rdi.deployedObject));
            this.serviceController.stop(rdi.deployedObject);
        }
        catch (Exception e) {
            this.log.error((Object)"Problem undeploying RARDeployment MBean", (Throwable)e);
            throw new DeploymentException("Problem undeploying RARDeployment MBean", (Throwable)e);
        }
    }

    public void destroy(DeploymentInfo rdi) throws DeploymentException {
        try {
            this.serviceController.destroy(rdi.deployedObject);
            this.serviceController.remove(rdi.deployedObject);
        }
        catch (Exception e) {
            this.log.error((Object)"Problem undeploying RARDeployment MBean", (Throwable)e);
            throw new DeploymentException("Problem undeploying RARDeployment MBean", (Throwable)e);
        }
        ((RARMetaData)rdi.metaData).setClassLoader(null);
        ResourceAdapter.destroy((MBeanServer)this.server, (String)((RARMetaData)rdi.metaData).getDisplayName());
        ResourceAdapterModule.destroy((MBeanServer)this.server, (String)rdi.shortName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

